/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.client.dii;

import com.sun.xml.rpc.client.dii.DynamicInvocationException;
import com.sun.xml.rpc.util.Holders;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.rpc.Call;
import javax.xml.rpc.Stub;
import javax.xml.rpc.holders.Holder;

public class CallInvocationHandler
implements InvocationHandler,
Stub {
    private static final Set recognizedProperties;
    private Map callMap = new HashMap();
    private Map properties = new HashMap();
    private Class portInterface;

    CallInvocationHandler(Class clazz) {
        this.portInterface = clazz;
    }

    public void addCall(Method method, Call call) {
        this.callMap.put(method, call);
    }

    public Call getCall(Method method) {
        return (Call)this.callMap.get(method);
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Exception {
        if (this.portInterface.equals(method.getDeclaringClass())) {
            Call call = this.getCall(method);
            if (call == null) {
                String string = "";
                Iterator iterator = this.callMap.keySet().iterator();
                while (iterator.hasNext()) {
                    Method method2 = (Method)iterator.next();
                    string = string + "\n" + method2.getName();
                }
                throw new DynamicInvocationException("dii.dynamicproxy.method.unrecognized", new Object[]{method != null ? method.getName() : null, string});
            }
            return this.doCall(call, objectArray);
        }
        return this.doNonPort(method, objectArray);
    }

    protected Object doCall(Call call, Object[] objectArray) throws RemoteException {
        Object object;
        Object object2;
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        Holder[] holderArray = new Holder[objectArray.length];
        int[] nArray = new int[objectArray.length];
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            object2 = objectArray[i];
            if (!(object2 instanceof Holder)) continue;
            object = (Holder)object2;
            nArray[n] = i;
            holderArray[n] = object;
            objectArray[i] = Holders.getValue((Holder)object);
            ++n;
        }
        Object object3 = call.invoke(objectArray);
        if (n > 0) {
            object2 = call.getOutputValues();
            object = object2.iterator();
            int n2 = 0;
            while (object.hasNext()) {
                Object e = object.next();
                int n3 = nArray[n2];
                Holder holder = holderArray[n2];
                Holders.setValue(holder, e);
                objectArray[n3] = holder;
                ++n2;
            }
        }
        return object3;
    }

    protected Object doNonPort(Method method, Object[] objectArray) {
        try {
            return method.invoke((Object)this, objectArray);
        }
        catch (Exception exception) {
            throw new DynamicInvocationException("dii.exception.nested", new LocalizableExceptionAdapter(exception));
        }
    }

    public void _setProperty(String string, Object object) {
        if (!recognizedProperties.contains(string)) {
            throw new IllegalArgumentException("Call object does not recognize property: " + string);
        }
        this.properties.put(string, object);
        this.setPropertyOnCallObjects(string, object);
    }

    public Object _getProperty(String string) {
        return this.properties.get(string);
    }

    public Iterator _getPropertyNames() {
        return this.properties.keySet().iterator();
    }

    private void setPropertyOnCallObjects(String string, Object object) {
        Iterator iterator = this.callMap.values().iterator();
        while (iterator.hasNext()) {
            Call call = (Call)iterator.next();
            if ("javax.xml.rpc.service.endpoint.address".equals(string)) {
                call.setTargetEndpointAddress((String)object);
                continue;
            }
            call.setProperty(string, object);
        }
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("javax.xml.rpc.security.auth.username");
        hashSet.add("javax.xml.rpc.security.auth.password");
        hashSet.add("javax.xml.rpc.service.endpoint.address");
        hashSet.add("javax.xml.rpc.session.maintain");
        recognizedProperties = Collections.unmodifiableSet(hashSet);
    }
}

