/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.client;

import com.sun.xml.rpc.client.HandlerException;
import com.sun.xml.rpc.soap.message.SOAPMessageContext;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.HandlerChain;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;

public class HandlerChainImpl
extends Vector
implements HandlerChain {
    protected List handlerInfos;
    String[] roles = null;
    boolean initialized = false;
    Hashtable handlerPool = new Hashtable();
    List understoodHeaders = new ArrayList();

    public HandlerChainImpl(List list) {
        this.handlerInfos = list;
        this.createHandlerInstances();
    }

    private void createHandlerInstances() {
        for (int i = 0; i < this.handlerInfos.size(); ++i) {
            this.add(this.newHandler(this.getHandlerInfo(i)));
        }
    }

    public boolean handleFault(MessageContext messageContext) {
        int n;
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
        for (int i = n = sOAPMessageContext.getCurrentHandler(); i >= 0; --i) {
            sOAPMessageContext.setCurrentHandler(i);
            if (this.getHandlerInstance(i).handleFault((MessageContext)sOAPMessageContext)) continue;
            return false;
        }
        sOAPMessageContext.setCurrentHandler(-1);
        return true;
    }

    public boolean handleRequest(MessageContext messageContext) {
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
        for (int i = 0; i < this.size(); ++i) {
            Handler handler = this.getHandlerInstance(i);
            sOAPMessageContext.setCurrentHandler(i);
            if (handler.handleRequest((MessageContext)sOAPMessageContext)) continue;
            return false;
        }
        sOAPMessageContext.setCurrentHandler(-1);
        return true;
    }

    public boolean handleResponse(MessageContext messageContext) {
        if (this.size() > 0) {
            SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
            int n = sOAPMessageContext.getCurrentHandler();
            if (n == -1) {
                n = this.size() - 1;
            }
            for (int i = n; i >= 0; --i) {
                sOAPMessageContext.setCurrentHandler(i);
                if (this.getHandlerInstance(i).handleResponse((MessageContext)sOAPMessageContext)) continue;
                sOAPMessageContext.setCurrentHandler(-1);
                return false;
            }
            sOAPMessageContext.setCurrentHandler(-1);
        }
        return true;
    }

    public void init(Map map) {
    }

    public void destroy() {
        for (int i = 0; i < this.size(); ++i) {
            this.deleteHandlerInstance(i);
        }
        this.clear();
    }

    protected void deleteHandlerInstance(int n) {
        Handler handler = this.getHandlerInstance(n);
        handler.destroy();
        this.removeHandlerFromPool(handler.getClass());
    }

    protected Handler getHandlerInstance(int n) {
        return this.castToHandler(this.get(n));
    }

    protected HandlerInfo getHandlerInfo(int n) {
        return (HandlerInfo)this.handlerInfos.get(n);
    }

    protected void removeHandlerFromPool(Class clazz) {
        this.handlerPool.remove(clazz.getName());
    }

    protected Handler getHandlerFromPool(HandlerInfo handlerInfo) {
        Class clazz = handlerInfo.getHandlerClass();
        Handler handler = (Handler)this.handlerPool.get(clazz.getName());
        if (handler == null) {
            try {
                handler = (Handler)clazz.newInstance();
                handler.init(handlerInfo);
                this.addUnderstoodHeaders(handler.getHeaders());
                this.handlerPool.put(clazz.getName(), handler);
            }
            catch (Exception exception) {
                throw new HandlerException("Unable to instantiate handler: ", new Object[]{handlerInfo.getHandlerClass(), new LocalizableExceptionAdapter(exception)});
            }
        }
        return handler;
    }

    protected Handler newHandler(HandlerInfo handlerInfo) {
        return this.getHandlerFromPool(handlerInfo);
    }

    public void setRoles(String[] stringArray) {
        this.roles = stringArray;
    }

    public String[] getRoles() {
        return this.roles;
    }

    protected Handler castToHandler(Object object) {
        if (!(object instanceof Handler)) {
            throw new HandlerException("handler.chain.contains.handler.only", new Object[]{object.getClass().getName()});
        }
        return (Handler)object;
    }

    public void addUnderstoodHeaders(QName[] qNameArray) {
        if (qNameArray != null) {
            for (int i = 0; i < qNameArray.length; ++i) {
                this.understoodHeaders.add(qNameArray[i]);
            }
        }
    }

    public boolean checkMustUnderstand(MessageContext messageContext) throws SOAPException {
        SOAPMessage sOAPMessage = ((SOAPMessageContext)messageContext).getMessage();
        if (this.roles != null) {
            for (int i = 0; i < this.roles.length; ++i) {
                String string = this.roles[i];
                SOAPHeader sOAPHeader = sOAPMessage.getSOAPPart().getEnvelope().getHeader();
                if (sOAPHeader == null) {
                    return true;
                }
                Iterator iterator = sOAPHeader.examineHeaderElements(string);
                while (iterator.hasNext()) {
                    SOAPHeaderElement sOAPHeaderElement = (SOAPHeaderElement)iterator.next();
                    Name name = sOAPHeaderElement.getElementName();
                    QName qName = new QName(name.getURI(), name.getLocalName());
                    if (!sOAPHeaderElement.getMustUnderstand() || this.understoodHeaders.contains(qName)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

