/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.client;

import com.sun.xml.rpc.client.ServiceExceptionImpl;
import com.sun.xml.rpc.client.dii.BasicCall;
import com.sun.xml.rpc.client.dii.CallEx;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistryImpl;
import com.sun.xml.rpc.encoding.SerializerConstants;
import com.sun.xml.rpc.encoding.StandardTypeMappings;
import com.sun.xml.rpc.encoding.TypeMappingImpl;
import com.sun.xml.rpc.encoding.TypeMappingRegistryImpl;
import com.sun.xml.rpc.naming.ServiceReferenceResolver;
import java.net.URL;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.rpc.handler.HandlerRegistry;

public class BasicService
implements Service,
SerializerConstants,
Referenceable {
    protected static final String DEFAULT_OPERATION_STYLE = "rpc";
    protected QName name;
    protected List ports;
    protected TypeMappingRegistry typeRegistry;
    protected InternalTypeMappingRegistry internalTypeRegistry;
    private HandlerRegistry handlerRegistry;

    protected QName[] getPortsAsArray() {
        return this.ports.toArray(new QName[this.ports.size()]);
    }

    protected void init(QName qName, TypeMappingRegistry typeMappingRegistry) {
        this.init();
        this.name = qName;
        this.typeRegistry = typeMappingRegistry;
        this.internalTypeRegistry = new InternalTypeMappingRegistryImpl(typeMappingRegistry);
    }

    protected void init() {
        this.ports = new ArrayList();
        this.handlerRegistry = null;
    }

    public BasicService(QName qName, TypeMappingRegistry typeMappingRegistry) {
        this.init(qName, typeMappingRegistry);
    }

    public BasicService(QName qName) {
        this.init(qName, BasicService.createStandardTypeMappingRegistry());
    }

    public BasicService(QName qName, QName[] qNameArray) {
        this(qName);
        this.addPorts(qNameArray);
    }

    public BasicService(QName qName, QName[] qNameArray, TypeMappingRegistry typeMappingRegistry) {
        this(qName, typeMappingRegistry);
        this.addPorts(qNameArray);
    }

    protected void addPorts(QName[] qNameArray) {
        if (qNameArray != null) {
            for (int i = 0; i < qNameArray.length; ++i) {
                this.addPort(qNameArray[i]);
            }
        }
    }

    public BasicService(QName qName, Iterator iterator) {
        this(qName);
        while (iterator.hasNext()) {
            this.addPort((QName)iterator.next());
        }
    }

    protected void addPort(QName qName) {
        this.ports.add(qName);
    }

    public Remote getPort(Class clazz) throws ServiceException {
        throw this.noWsdlException();
    }

    protected ServiceException noWsdlException() {
        return new ServiceExceptionImpl("dii.service.no.wsdl.available");
    }

    public Remote getPort(QName qName, Class clazz) throws ServiceException {
        throw this.noWsdlException();
    }

    public Call[] getCalls(QName qName) throws ServiceException {
        throw this.noWsdlException();
    }

    public Call createCall(QName qName) throws ServiceException {
        if (!this.ports.contains(qName)) {
            this.addPort(qName);
        }
        CallEx callEx = (CallEx)this.createCall();
        callEx.setPortName(qName);
        return callEx;
    }

    public Call createCall(QName qName, String string) throws ServiceException {
        return this.createCall(qName, new QName(string));
    }

    public Call createCall(QName qName, QName qName2) throws ServiceException {
        Call call = this.createCall(qName);
        call.setOperationName(qName2);
        return call;
    }

    public Call createCall() throws ServiceException {
        BasicCall basicCall = new BasicCall(this.internalTypeRegistry, this.getHandlerRegistry());
        basicCall.setProperty("javax.xml.rpc.soap.operation.style", DEFAULT_OPERATION_STYLE);
        return basicCall;
    }

    public QName getServiceName() {
        return this.name;
    }

    public Iterator getPorts() throws ServiceException {
        throw this.noWsdlException();
    }

    public URL getWSDLDocumentLocation() {
        return null;
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        return this.typeRegistry;
    }

    public HandlerRegistry getHandlerRegistry() {
        if (this.handlerRegistry == null) {
            this.handlerRegistry = new HandlerRegistryImpl();
        }
        return this.handlerRegistry;
    }

    public static TypeMappingRegistry createStandardTypeMappingRegistry() {
        TypeMappingRegistryImpl typeMappingRegistryImpl = new TypeMappingRegistryImpl();
        TypeMapping typeMapping = BasicService.createSoapMappings();
        typeMappingRegistryImpl.register("http://schemas.xmlsoap.org/soap/encoding/", typeMapping);
        TypeMapping typeMapping2 = BasicService.createLiteralMappings();
        typeMappingRegistryImpl.register("", typeMapping2);
        return typeMappingRegistryImpl;
    }

    protected static TypeMapping createSoapMappings() {
        TypeMappingImpl typeMappingImpl = new TypeMappingImpl(StandardTypeMappings.getSoap());
        typeMappingImpl.setSupportedEncodings(new String[]{"http://schemas.xmlsoap.org/soap/encoding/"});
        return typeMappingImpl;
    }

    protected static TypeMapping createLiteralMappings() {
        TypeMappingImpl typeMappingImpl = new TypeMappingImpl(StandardTypeMappings.getLiteral());
        typeMappingImpl.setSupportedEncodings(new String[]{""});
        return typeMappingImpl;
    }

    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), "com.sun.xml.rpc.naming.ServiceReferenceResolver", null);
        String string = ServiceReferenceResolver.registerService(this);
        reference.add(new StringRefAddr("ServiceName", string));
        return reference;
    }

    protected static class HandlerRegistryImpl
    implements HandlerRegistry {
        Map handlerChainsForPorts;

        public HandlerRegistryImpl() {
            this.init();
        }

        protected void init() {
            this.handlerChainsForPorts = new HashMap();
        }

        public List getHandlerChain(QName qName) {
            if (this.handlerChainsForPorts.get(qName) == null) {
                this.setHandlerChain(qName, new ArrayList());
            }
            return (List)this.handlerChainsForPorts.get(qName);
        }

        public void setHandlerChain(QName qName, List list) {
            this.handlerChainsForPorts.put(qName, list);
        }
    }
}

