/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.validators;

import org.exolab.castor.types.DateTimeBase;
import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationException;

public class DateTimeValidator
implements TypeValidator {
    private DateTimeBase _maxInclusive;
    private DateTimeBase _maxExclusive;
    private DateTimeBase _minInclusive;
    private DateTimeBase _minExclusive;

    public void setMaxExclusive(DateTimeBase dateTimeBase) {
        this._maxExclusive = dateTimeBase;
        this._maxInclusive = null;
    }

    public void setMaxInclusive(DateTimeBase dateTimeBase) {
        this._maxInclusive = dateTimeBase;
        this._maxExclusive = null;
    }

    public void setMinExclusive(DateTimeBase dateTimeBase) {
        this._minExclusive = dateTimeBase;
        this._minInclusive = null;
    }

    public void setMinInclusive(DateTimeBase dateTimeBase) {
        this._minInclusive = dateTimeBase;
        this._minExclusive = null;
    }

    public void validate(DateTimeBase dateTimeBase) throws ValidationException {
        boolean bl;
        boolean bl2 = this._minInclusive != null;
        boolean bl3 = this._minExclusive != null;
        boolean bl4 = this._maxInclusive != null;
        boolean bl5 = bl = this._maxExclusive != null;
        if (bl3 && bl2) {
            throw new ValidationException("both minInclusive and minExclusiveare set up");
        }
        if (bl && bl4) {
            throw new ValidationException("both maxInclusive and maxExclusiveare set up");
        }
        if (bl2 && dateTimeBase.compareTo(this._minInclusive) != 2) {
            String string = dateTimeBase + " must be greater than the minimum allowable ";
            string = string + "value of " + this._minInclusive;
            throw new ValidationException(string);
        }
        if (bl3 && dateTimeBase.compareTo(this._minExclusive) != 2 && !dateTimeBase.equals(this._minExclusive)) {
            String string = dateTimeBase + " must be greater than (or equal to) the minimum allowable ";
            string = string + "value of " + this._minExclusive;
            throw new ValidationException(string);
        }
        if (bl4 && dateTimeBase.compareTo(this._maxInclusive) != 0) {
            String string = dateTimeBase + " must be less than the maximum allowable ";
            string = string + "value of " + this._maxInclusive;
            throw new ValidationException(string);
        }
        if (bl && dateTimeBase.compareTo(this._maxExclusive) != 0 && !dateTimeBase.equals(this._maxExclusive)) {
            String string = dateTimeBase + " must be less than (or equal to) the maximum allowable ";
            string = string + "value of " + this._maxExclusive;
            throw new ValidationException(string);
        }
    }

    public void validate(Object object) throws ValidationException {
        if (object == null) {
            String string = "DateTimeValidator cannot validate a null object.";
            throw new ValidationException(string);
        }
        DateTimeBase dateTimeBase = null;
        try {
            dateTimeBase = (DateTimeBase)object;
        }
        catch (Exception exception) {
            String string = exception.toString() + "\nExpecting a RecurringDuration, received instead: ";
            string = string + object.getClass().getName();
            throw new ValidationException(string);
        }
        this.validate(dateTimeBase);
    }
}

