/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.SaxUnmarshaller;
import org.exolab.castor.xml.schema.reader.SimpleTypeDefinition;
import org.exolab.castor.xml.schema.reader.SimpleTypeListUnmarshaller;
import org.exolab.castor.xml.schema.reader.SimpleTypeRestrictionUnmarshaller;
import org.exolab.castor.xml.schema.reader.UnionUnmarshaller;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class SimpleTypeUnmarshaller
extends SaxUnmarshaller {
    private SaxUnmarshaller unmarshaller;
    private int depth = 0;
    private SimpleTypeDefinition _simpleTypeDef = null;
    private SimpleType _simpleType = null;
    private boolean foundAnnotation = false;
    private boolean foundList = false;
    private boolean foundRestriction = false;
    private boolean foundUnion = false;

    public SimpleTypeUnmarshaller(Schema schema, AttributeList attributeList) throws SAXException {
        String string = attributeList.getValue("name");
        String string2 = attributeList.getValue("id");
        this._simpleTypeDef = new SimpleTypeDefinition(schema, string, string2);
    }

    public String elementName() {
        return "simpleType";
    }

    public SimpleType getSimpleType() {
        if (this._simpleType == null) {
            this._simpleType = this._simpleTypeDef.createSimpleType();
        }
        return this._simpleType;
    }

    public Object getObject() {
        return this.getSimpleType();
    }

    public void finish() throws SAXException {
        if (!(this.foundList || this.foundUnion || this.foundRestriction)) {
            this.error("Invalid 'simpleType'; missing 'restriction' | 'union' | 'list'.");
        }
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(string, attributeList);
            ++this.depth;
            return;
        }
        if ("annotation".equals(string)) {
            if (this.foundAnnotation) {
                this.error("Only one (1) annotation may appear as a child of 'simpleType'.");
            }
            if (this.foundList || this.foundUnion || this.foundRestriction) {
                this.error("An annotation may only appear as the first child of 'simpleType'.");
            }
            this.foundAnnotation = true;
            this.unmarshaller = new AnnotationUnmarshaller(attributeList);
        } else if ("restriction".equals(string)) {
            if (this.foundList) {
                this.error("A 'simpleType' cannot have both a 'list' and a 'restriction' in the same definition.");
            }
            if (this.foundUnion) {
                this.error("A 'simpleType' cannot have both a 'union' and a 'restriction' in the same definition.");
            }
            this.foundRestriction = true;
            this.unmarshaller = new SimpleTypeRestrictionUnmarshaller(this._simpleTypeDef, attributeList);
        } else if ("list".equals(string)) {
            this.foundList = true;
            this.unmarshaller = new SimpleTypeListUnmarshaller(this._simpleTypeDef, attributeList);
        } else if ("union".equals(string)) {
            this.foundUnion = true;
            Schema schema = this._simpleTypeDef.getSchema();
            this.unmarshaller = new UnionUnmarshaller(schema, attributeList);
        } else {
            this.illegalElement(string);
        }
    }

    public void endElement(String string) throws SAXException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(string);
            --this.depth;
            return;
        }
        this.unmarshaller.finish();
        if ("annotation".equals(string)) {
            Annotation annotation = (Annotation)this.unmarshaller.getObject();
            this._simpleTypeDef.setAnnotation(annotation);
        } else if ("union".equals(string)) {
            this._simpleType = (SimpleType)this.unmarshaller.getObject();
            this._simpleTypeDef.copyInto(this._simpleType);
        }
        this.unmarshaller = null;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(cArray, n, n2);
        }
    }
}

