/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Enumeration;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.types.AnyNode;
import org.exolab.castor.util.Configuration;
import org.exolab.castor.util.List;
import org.exolab.castor.util.Messages;
import org.exolab.castor.util.MimeBase64Encoder;
import org.exolab.castor.util.Stack;
import org.exolab.castor.xml.ClassDescriptorResolver;
import org.exolab.castor.xml.Introspector;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.MarshalFramework;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.exolab.castor.xml.XMLClassDescriptor;
import org.exolab.castor.xml.XMLFieldDescriptor;
import org.exolab.castor.xml.XMLMappingLoader;
import org.exolab.castor.xml.XMLNaming;
import org.exolab.castor.xml.descriptors.StringClassDescriptor;
import org.exolab.castor.xml.handlers.DateFieldHandler;
import org.exolab.castor.xml.util.AnyNode2SAX;
import org.exolab.castor.xml.util.ClassDescriptorResolverImpl;
import org.exolab.castor.xml.util.SAX2DOMHandler;
import org.exolab.castor.xml.util.XMLFieldDescriptorImpl;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;

public class Marshaller
extends MarshalFramework {
    private static final String SERIALIZER_NOT_SAX_CAPABLE = "conf.serializerNotSaxCapable";
    public static final String XSI_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String XMLNS = "xmlns";
    private static final String XSI_PREFIX = "xsi";
    private static final String XSI_TYPE = "xsi:type";
    private static final String CDATA = "CDATA";
    private static final String QNAME_NAME = "QName";
    private static final String DEFAULT_PREFIX = "ns";
    private static int NAMESPACE_COUNTER = 0;
    public static boolean enableDebug = false;
    private boolean _debug = false;
    private PrintWriter _logWriter = null;
    private boolean _nsPrefixAtRoot = false;
    private String _rootElement = null;
    private String _defaultNamespace = null;
    private boolean _validate = false;
    private List _nsScope = null;
    private ClassDescriptorResolver _cdResolver = null;
    private Namespaces _namespaces = null;
    private DocumentHandler _handler = null;
    private Serializer _serializer = null;
    private XMLNaming _naming = null;
    private Node _node = null;
    private boolean _asDocument = true;
    int depth = 0;
    private List _packages = null;
    private Stack _parents = null;
    private boolean _marshalExtendedType = true;
    private static final StringClassDescriptor _StringClassDescriptor = new StringClassDescriptor();
    static /* synthetic */ Class class$java$lang$Void;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Class;

    public Marshaller(DocumentHandler documentHandler) {
        if (documentHandler == null) {
            throw new IllegalArgumentException("Argument 'handler' is null.");
        }
        this._handler = documentHandler;
        this.initialize();
    }

    public Marshaller(Writer writer) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("Argument 'out' is null.");
        }
        this.initialize();
        this._serializer = Configuration.getSerializer();
        if (this._serializer == null) {
            throw new RuntimeException("Unable to obtain serializer");
        }
        this._serializer.setOutputCharStream(writer);
        this._handler = this._serializer.asDocumentHandler();
        if (this._handler == null) {
            String string = Messages.format(SERIALIZER_NOT_SAX_CAPABLE, this._serializer.getClass().getName());
            throw new RuntimeException(string);
        }
    }

    public Marshaller(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 'node' is null.");
        }
        this._node = node;
        this._handler = new SAX2DOMHandler(node);
        this.initialize();
    }

    private void initialize() {
        this._debug = enableDebug;
        this._namespaces = new Namespaces();
        this._nsScope = new List(3);
        this._packages = new List(3);
        this._cdResolver = new ClassDescriptorResolverImpl();
        this._parents = new Stack();
        this._validate = Configuration.marshallingValidation();
        this._naming = XMLNaming.getInstance();
        this.setNamespaceMapping(XSI_PREFIX, XSI_NAMESPACE);
    }

    public void setMarshalAsDocument(boolean bl) {
        this._asDocument = bl;
        if (this._serializer != null) {
            OutputFormat outputFormat = Configuration.getOutputFormat();
            outputFormat.setOmitXMLDeclaration(!bl);
            this._serializer.setOutputFormat(outputFormat);
            try {
                this._handler = this._serializer.asDocumentHandler();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setMapping(Mapping mapping) throws MappingException {
        if (this._cdResolver == null) {
            this._cdResolver = new ClassDescriptorResolverImpl();
        }
        this._cdResolver.setMappingLoader((XMLMappingLoader)mapping.getResolver(Mapping.XML));
    }

    public void setNamespaceMapping(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            String string3 = "namespace URI must not be null.";
            throw new IllegalArgumentException(string3);
        }
        if (string == null || string.length() == 0) {
            this._defaultNamespace = string2;
            return;
        }
        this._namespaces.addNamespace(string, string2);
    }

    public void setRootElement(String string) {
        this._rootElement = string;
    }

    public String getRootElement() {
        return this._rootElement;
    }

    public void setNSPrefixAtRoot(boolean bl) {
        this._nsPrefixAtRoot = bl;
    }

    public boolean getNSPrefixAtRoot() {
        return this._nsPrefixAtRoot;
    }

    public void setResolver(ClassDescriptorResolver classDescriptorResolver) {
        if (classDescriptorResolver != null) {
            this._cdResolver = classDescriptorResolver;
        }
    }

    public void setValidation(boolean bl) {
        this._validate = bl;
    }

    public void setMarshalExtendedType(boolean bl) {
        this._marshalExtendedType = bl;
    }

    public boolean getMarshalExtendedType() {
        return this._marshalExtendedType;
    }

    public static void marshal(Object object, Writer writer) throws MarshalException, ValidationException {
        if (object == null) {
            throw new MarshalException("object must not be null");
        }
        if (enableDebug) {
            System.out.print("- Marshaller called using ");
            System.out.println("*static* marshal(Object, Writer)");
        }
        try {
            Marshaller marshaller = new Marshaller(writer);
            marshaller.marshal(object);
        }
        catch (IOException iOException) {
            throw new MarshalException(iOException);
        }
    }

    public static void marshal(Object object, DocumentHandler documentHandler) throws MarshalException, ValidationException {
        if (object == null) {
            throw new MarshalException("object must not be null");
        }
        if (enableDebug) {
            System.out.print("- Marshaller called using ");
            System.out.println("*static* marshal(Object, DocumentHandler)");
        }
        Marshaller marshaller = new Marshaller(documentHandler);
        marshaller.marshal(object);
    }

    public static void marshal(Object object, Node node) throws MarshalException, ValidationException {
        if (object == null) {
            throw new MarshalException("object must not be null");
        }
        if (enableDebug) {
            System.out.print("- Marshaller called using ");
            System.out.println("*static* marshal(Object, Node)");
        }
        Marshaller marshaller = new Marshaller(node);
        marshaller.marshal(object);
    }

    public void marshal(Object object) throws MarshalException, ValidationException {
        if (object == null) {
            throw new MarshalException("object must not be null");
        }
        if (this._debug) {
            System.out.println("Marshalling " + object.getClass().getName());
        }
        if (object instanceof AnyNode) {
            try {
                AnyNode2SAX.fireEvents((AnyNode)object, this._handler);
            }
            catch (SAXException sAXException) {
                throw new MarshalException(sAXException);
            }
        } else {
            this.validate(object);
            if (this._asDocument) {
                try {
                    this._handler.startDocument();
                    this.marshal(object, null, this._handler);
                    this._handler.endDocument();
                }
                catch (SAXException sAXException) {
                    throw new MarshalException(sAXException);
                }
            } else {
                this.marshal(object, null, this._handler);
            }
        }
    }

    private void marshal(Object object, XMLFieldDescriptor xMLFieldDescriptor, DocumentHandler documentHandler) throws MarshalException, ValidationException {
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String string;
        Object object6;
        Object object7;
        Object object8;
        if (object == null) {
            String string2 = "Marshaller#marshal: null parameter: 'object'";
            throw new MarshalException(string2);
        }
        if (xMLFieldDescriptor != null && xMLFieldDescriptor.isTransient()) {
            return;
        }
        if (object instanceof AnyNode) {
            try {
                AnyNode2SAX.fireEvents((AnyNode)object, documentHandler);
            }
            catch (SAXException sAXException) {
                throw new MarshalException(sAXException);
            }
            return;
        }
        boolean bl = false;
        if (xMLFieldDescriptor != null && xMLFieldDescriptor.isContainer()) {
            bl = true;
        }
        if (this._parents.search(object) >= 0) {
            return;
        }
        this._parents.push(object);
        Class clazz = object.getClass();
        boolean bl2 = false;
        if (clazz.isArray()) {
            bl2 = clazz.getComponentType() == Byte.TYPE;
        }
        boolean bl3 = false;
        if (xMLFieldDescriptor == null) {
            xMLFieldDescriptor = new XMLFieldDescriptorImpl(clazz, "root", null, null);
            bl3 = true;
        }
        Object object9 = xMLFieldDescriptor.getXMLName();
        if (bl3 && this._rootElement != null) {
            object9 = this._rootElement;
        }
        if (object9 == null) {
            object9 = clazz.getName();
            int n = ((String)object9).lastIndexOf(46);
            if (n >= 0) {
                object9 = ((String)object9).substring(n + 1);
            }
            object9 = this._naming.toXMLName((String)object9);
        }
        XMLClassDescriptor xMLClassDescriptor = null;
        boolean bl4 = false;
        if (clazz == xMLFieldDescriptor.getFieldType()) {
            xMLClassDescriptor = (XMLClassDescriptor)xMLFieldDescriptor.getClassDescriptor();
        }
        if (xMLClassDescriptor == null) {
            if (MarshalFramework.isPrimitive(clazz) || bl2) {
                xMLClassDescriptor = _StringClassDescriptor;
                if (clazz != xMLFieldDescriptor.getFieldType()) {
                    bl4 = !xMLFieldDescriptor.getFieldType().isPrimitive();
                }
            } else {
                object8 = clazz.getName();
                int n = ((String)object8).lastIndexOf(".");
                if (n > 0 && !this._packages.contains(object7 = ((String)object8).substring(0, n + 1))) {
                    this._packages.add(object7);
                }
                if (this._marshalExtendedType) {
                    xMLClassDescriptor = this.getClassDescriptor(clazz);
                    bl4 = clazz != xMLFieldDescriptor.getFieldType();
                } else {
                    clazz = xMLFieldDescriptor.getFieldType();
                    xMLClassDescriptor = this.getClassDescriptor(clazz);
                }
                if (bl3 && this._rootElement != null) {
                    object9 = this._rootElement;
                } else if (xMLFieldDescriptor.getXMLName() == null) {
                    object9 = xMLClassDescriptor.getXMLName();
                }
            }
            if (xMLClassDescriptor == null) {
                if (clazz == (class$java$lang$Void == null ? (class$java$lang$Void = Marshaller.class$("java.lang.Void")) : class$java$lang$Void) || clazz == (class$java$lang$Object == null ? (class$java$lang$Object = Marshaller.class$("java.lang.Object")) : class$java$lang$Object) || clazz == (class$java$lang$Class == null ? (class$java$lang$Class = Marshaller.class$("java.lang.Class")) : class$java$lang$Class)) {
                    throw new MarshalException("The marshaller cannot marshal/unmarshal types of Void.class, Class.class or Object.class");
                }
                this._parents.pop();
                return;
            }
        }
        if (bl4 && xMLFieldDescriptor.getHandler() instanceof DateFieldHandler) {
            bl4 = false;
        }
        if (bl4) {
            object8 = xMLClassDescriptor.getXMLName();
            XMLClassDescriptor xMLClassDescriptor2 = this._cdResolver.resolveByXMLName((String)object8, null, null);
            if (xMLClassDescriptor2 != null && !Introspector.introspected(xMLClassDescriptor2)) {
                object7 = xMLFieldDescriptor.getFieldType();
                object6 = xMLClassDescriptor2.getExtends();
                while (object6 != null && object6.getJavaClass() != object7) {
                    object6 = object6.getExtends();
                }
                if (((Class)object7).isAssignableFrom(xMLClassDescriptor2.getJavaClass()) && (xMLClassDescriptor2.getJavaClass() == object7 || object6 != null && object6.getJavaClass() == object7)) {
                    bl4 = false;
                    object9 = object8;
                }
            }
            if (object8 == null && xMLFieldDescriptor.getContainingClassDescriptor() != null && !Introspector.introspected(xMLClassDescriptor2 = (XMLClassDescriptor)xMLFieldDescriptor.getContainingClassDescriptor())) {
                bl4 = false;
            }
        }
        object8 = new AttributeListImpl();
        XMLFieldDescriptor[] xMLFieldDescriptorArray = xMLClassDescriptor.getAttributeDescriptors();
        int n = 0;
        while (n < xMLFieldDescriptorArray.length) {
            block85: {
                Object object10;
                block87: {
                    block88: {
                        if (xMLFieldDescriptorArray[n] == null) break block85;
                        object6 = xMLFieldDescriptorArray[n];
                        string = object6.getXMLName();
                        object10 = null;
                        try {
                            object10 = object6.getHandler().getValue(object);
                        }
                        catch (IllegalStateException illegalStateException) {
                            break block85;
                        }
                        if (!object6.isReference() || object10 == null) break block87;
                        if (!object6.isMultivalued()) break block88;
                        object5 = (Object[])object10;
                        if (((Object[])object5).length == 0) break block85;
                        StringBuffer stringBuffer = new StringBuffer();
                        int n2 = 0;
                        while (n2 < ((Object[])object5).length) {
                            if (n2 > 0) {
                                stringBuffer.append(' ');
                            }
                            stringBuffer.append(this.getObjectID(object5[n2]).toString());
                            ++n2;
                        }
                        object10 = stringBuffer;
                        break block87;
                    }
                    object10 = this.getObjectID(object10);
                }
                if (object10 != null) {
                    object5 = object6.getSchemaType();
                    if (object5 != null && object5.equals(QNAME_NAME)) {
                        object10 = this.resolveQName(object10, (XMLFieldDescriptor)object6, (AttributeListImpl)object8);
                    }
                    ((AttributeListImpl)object8).addAttribute(string, CDATA, object10.toString());
                }
            }
            ++n;
        }
        if (bl4) {
            bl4 = this.declareNamespace(XSI_PREFIX, XSI_NAMESPACE, (AttributeListImpl)object8);
            ((AttributeListImpl)object8).addAttribute(XSI_TYPE, CDATA, "java:" + clazz.getName());
        }
        if ((object6 = xMLFieldDescriptor.getNameSpacePrefix()) == null) {
            object6 = xMLClassDescriptor.getNameSpacePrefix();
        }
        if ((string = xMLFieldDescriptor.getNameSpaceURI()) == null) {
            string = xMLClassDescriptor.getNameSpaceURI();
        }
        if (string == null && object6 != null) {
            string = this._namespaces.getNamespaceURI((String)object6);
        } else if (object6 == null && string != null) {
            object6 = this._namespaces.getNamespacePrefix(string);
        }
        boolean bl5 = false;
        if (!(string == null || this._nsPrefixAtRoot && object6 != null)) {
            bl5 = this.declareNamespace((String)object6, string, (AttributeListImpl)object8);
        }
        if (this._nsPrefixAtRoot && bl3) {
            this._namespaces.declareAsAttributes((AttributeListImpl)object8);
        }
        object5 = null;
        if (object6 != null) {
            int n3 = ((String)object6).length();
            if (n3 > 0) {
                StringBuffer stringBuffer = new StringBuffer(n3 + ((String)object9).length() + 1);
                stringBuffer.append((String)object6);
                stringBuffer.append(':');
                stringBuffer.append((String)object9);
                object5 = stringBuffer.toString();
            } else {
                object5 = object9;
            }
        } else {
            object5 = object9;
        }
        String string3 = xMLFieldDescriptor.getSchemaType();
        if (string3 != null && string3.equals(QNAME_NAME)) {
            object = this.resolveQName(object, xMLFieldDescriptor, (AttributeListImpl)object8);
        }
        try {
            if (!bl) {
                documentHandler.startElement((String)object5, (AttributeList)object8);
            }
        }
        catch (SAXException sAXException) {
            throw new MarshalException(sAXException);
        }
        XMLFieldDescriptor xMLFieldDescriptor2 = xMLClassDescriptor.getContentDescriptor();
        if (xMLFieldDescriptor2 != null) {
            object4 = null;
            try {
                object4 = xMLFieldDescriptor2.getHandler().getValue(object);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (object4 != null && (object3 = object4.toString()) != null && ((String)object3).length() > 0) {
                object2 = ((String)object3).toCharArray();
                try {
                    documentHandler.characters((char[])object2, 0, ((char[])object2).length);
                }
                catch (SAXException sAXException) {
                    throw new MarshalException(sAXException);
                }
            }
        } else {
            if (bl2) {
                object4 = new MimeBase64Encoder();
                ((MimeBase64Encoder)object4).translate((byte[])object);
                object3 = ((MimeBase64Encoder)object4).getCharArray();
                try {
                    documentHandler.characters((char[])object3, 0, ((Object)object3).length);
                }
                catch (SAXException sAXException) {
                    throw new MarshalException(sAXException);
                }
            }
            if (MarshalFramework.isPrimitive(clazz)) {
                object4 = object.toString().toCharArray();
                try {
                    documentHandler.characters((char[])object4, 0, ((Object)object4).length);
                }
                catch (SAXException sAXException) {
                    throw new MarshalException(sAXException);
                }
            }
        }
        xMLFieldDescriptorArray = xMLClassDescriptor.getElementDescriptors();
        ++this.depth;
        int n4 = 0;
        while (n4 < xMLFieldDescriptorArray.length) {
            block86: {
                object3 = xMLFieldDescriptorArray[n4];
                object2 = null;
                try {
                    object2 = object3.getHandler().getValue(object);
                }
                catch (IllegalStateException illegalStateException) {
                    break block86;
                }
                if (object2 != null) {
                    Class<?> clazz2 = object2.getClass();
                    if (clazz2.isArray()) {
                        if (clazz2.getComponentType() == Byte.TYPE) {
                            this.marshal(object2, (XMLFieldDescriptor)object3, documentHandler);
                        } else {
                            int n5 = Array.getLength(object2);
                            int n6 = 0;
                            while (n6 < n5) {
                                Object object11 = Array.get(object2, n6);
                                if (object11 != null) {
                                    this.marshal(object11, (XMLFieldDescriptor)object3, documentHandler);
                                }
                                ++n6;
                            }
                        }
                    } else if (object2 instanceof Enumeration) {
                        Enumeration enumeration = (Enumeration)object2;
                        while (enumeration.hasMoreElements()) {
                            Object e = enumeration.nextElement();
                            if (e == null) continue;
                            this.marshal(e, (XMLFieldDescriptor)object3, documentHandler);
                        }
                    } else {
                        this.marshal(object2, (XMLFieldDescriptor)object3, documentHandler);
                    }
                }
            }
            ++n4;
        }
        try {
            if (!bl) {
                documentHandler.endElement((String)object5);
            }
        }
        catch (SAXException sAXException) {
            throw new MarshalException(sAXException);
        }
        --this.depth;
        this._parents.pop();
        if (bl5) {
            this._nsScope.remove(string);
        }
        if (bl4) {
            this._nsScope.remove(XSI_NAMESPACE);
        }
    }

    private Object getObjectID(Object object) throws MarshalException {
        Object object2;
        if (object == null) {
            return null;
        }
        Object object3 = null;
        XMLClassDescriptor xMLClassDescriptor = this.getClassDescriptor(object.getClass());
        String string = null;
        if (xMLClassDescriptor != null) {
            object2 = (XMLFieldDescriptor)xMLClassDescriptor.getIdentity();
            if (object2 != null) {
                FieldHandler fieldHandler = object2.getHandler();
                if (fieldHandler != null) {
                    try {
                        object3 = fieldHandler.getValue(object);
                    }
                    catch (IllegalStateException illegalStateException) {
                        string = illegalStateException.toString();
                    }
                } else {
                    string = "FieldHandler for Identity descriptor is null.";
                }
            } else {
                string = "No identity descriptor available";
            }
        } else {
            string = "Unable to resolve ClassDescriptor.";
        }
        if (string != null) {
            object2 = "Unable to resolve ID for instance of class '";
            object2 = (String)object2 + object.getClass().getName();
            object2 = (String)object2 + "' due to the following error: ";
            throw new MarshalException((String)object2 + string);
        }
        return object3;
    }

    private boolean declareNamespace(String string, String string2, AttributeListImpl attributeListImpl) {
        boolean bl = false;
        if (string2 != null && string2.length() != 0 && !this._nsScope.contains(string2)) {
            int n;
            String string3 = XMLNS;
            if (string != null && (n = string.length()) > 0) {
                StringBuffer stringBuffer = new StringBuffer(6 + n);
                stringBuffer.append(XMLNS);
                stringBuffer.append(':');
                stringBuffer.append(string);
                string3 = stringBuffer.toString();
            }
            this._nsScope.add(string2);
            attributeListImpl.addAttribute(string3, CDATA, string2);
            bl = true;
        }
        return bl;
    }

    public void setDebug(boolean bl) {
        this._debug = bl;
    }

    public void setLogWriter(PrintWriter printWriter) {
        this._logWriter = printWriter;
    }

    private XMLClassDescriptor getClassDescriptor(Class clazz) throws MarshalException {
        XMLClassDescriptor xMLClassDescriptor = null;
        if (!MarshalFramework.isPrimitive(clazz)) {
            xMLClassDescriptor = this._cdResolver.resolve(clazz);
        }
        if (this._cdResolver.error()) {
            throw new MarshalException(this._cdResolver.getErrorMessage());
        }
        return xMLClassDescriptor;
    }

    private XMLClassDescriptor getClassDescriptor(String string, ClassLoader classLoader) throws MarshalException {
        XMLClassDescriptor xMLClassDescriptor = this._cdResolver.resolve(string, classLoader);
        if (this._cdResolver.error()) {
            throw new MarshalException(this._cdResolver.getErrorMessage());
        }
        return xMLClassDescriptor;
    }

    private void processContainerAttributes(Object object, XMLClassDescriptor xMLClassDescriptor, AttributeListImpl attributeListImpl) throws MarshalException {
        XMLFieldDescriptor[] xMLFieldDescriptorArray = xMLClassDescriptor.getElementDescriptors();
        int n = 0;
        while (n < xMLFieldDescriptorArray.length) {
            XMLClassDescriptor xMLClassDescriptor2;
            XMLFieldDescriptor xMLFieldDescriptor;
            Object object2;
            if (xMLFieldDescriptorArray[n] != null && xMLFieldDescriptorArray[n].isContainer() && (object2 = (xMLFieldDescriptor = xMLFieldDescriptorArray[n]).getHandler().getValue(object)) != null && ((xMLClassDescriptor2 = (XMLClassDescriptor)xMLFieldDescriptor.getClassDescriptor()) != null || (xMLClassDescriptor2 = this.getClassDescriptor(xMLFieldDescriptor.getFieldType())) != null)) {
                XMLFieldDescriptor[] xMLFieldDescriptorArray2 = xMLClassDescriptor2.getAttributeDescriptors();
                int n2 = 0;
                while (n2 < xMLFieldDescriptorArray2.length) {
                    block7: {
                        if (xMLFieldDescriptorArray2[n2] != null) {
                            String string = xMLFieldDescriptorArray2[n2].getXMLName();
                            Object object3 = null;
                            try {
                                object3 = xMLFieldDescriptorArray2[n2].getHandler().getValue(object2);
                            }
                            catch (IllegalStateException illegalStateException) {
                                break block7;
                            }
                            if (object3 != null) {
                                attributeListImpl.addAttribute(string, CDATA, object3.toString());
                            }
                        }
                    }
                    ++n2;
                }
                this.processContainerAttributes(object2, xMLClassDescriptor2, attributeListImpl);
            }
            ++n;
        }
    }

    private Object resolveQName(Object object, XMLFieldDescriptor xMLFieldDescriptor, AttributeListImpl attributeListImpl) {
        if (object == null || !(object instanceof String)) {
            return object;
        }
        if (!(xMLFieldDescriptor instanceof XMLFieldDescriptorImpl)) {
            return object;
        }
        String string = (String)object;
        if (string.indexOf(125) <= 0) {
            String string2 = "Bad QName value :'" + string + "', it should follow the pattern '{URI}value'";
            throw new IllegalArgumentException(string2);
        }
        int n = string.indexOf(125);
        if (n <= 0) {
            String string3 = "Bad QName value :'" + string + "', it should follow the pattern '{URI}value'";
            throw new IllegalArgumentException(string3);
        }
        String string4 = string.substring(1, n);
        String string5 = ((XMLFieldDescriptorImpl)xMLFieldDescriptor).getQNamePrefix();
        if (string5 == null) {
            string5 = this._namespaces.getNamespacePrefix(string4);
        }
        if (string5 == null) {
            string5 = DEFAULT_PREFIX + ++NAMESPACE_COUNTER;
        }
        string = string5.length() != 0 ? string5 + ":" + string.substring(n + 1) : string.substring(n + 1);
        this.declareNamespace(string5, string4, attributeListImpl);
        return string;
    }

    private void validate(Object object) throws ValidationException {
        if (this._validate) {
            Validator validator = new Validator();
            validator.validate(object, this._cdResolver);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

