/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.util.Enumeration;
import org.exolab.castor.builder.SourceGenerator;
import org.exolab.castor.builder.types.XSPatternBase;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JType;

public final class XSDouble
extends XSPatternBase {
    Double maxInclusive = null;
    Double maxExclusive = null;
    Double minInclusive = null;
    Double minExclusive = null;
    private static JType jType = JType.Double;

    public XSDouble() {
        this(SourceGenerator.usePrimitiveWrapper());
    }

    public XSDouble(boolean bl) {
        super((short)15);
        jType = bl ? new JClass("java.lang.Double") : JType.Double;
    }

    public JType getJType() {
        return jType;
    }

    public Double getMaxExclusive() {
        return this.maxExclusive;
    }

    public Double getMaxInclusive() {
        return this.maxInclusive;
    }

    public Double getMinExclusive() {
        return this.minExclusive;
    }

    public Double getMinInclusive() {
        return this.minInclusive;
    }

    public boolean hasMaximum() {
        return this.maxInclusive != null || this.maxExclusive != null;
    }

    public boolean hasMinimum() {
        return this.minInclusive != null || this.minExclusive != null;
    }

    public void setMaxExclusive(double d) {
        this.maxExclusive = new Double(d);
    }

    public void setMaxExclusive(Double d) {
        this.maxExclusive = d;
    }

    public void setMaxInclusive(double d) {
        this.maxInclusive = new Double(d);
    }

    public void setMaxInclusive(Double d) {
        this.maxInclusive = d;
    }

    public void setMinExclusive(double d) {
        this.minExclusive = new Double(d);
    }

    public void setMinExclusive(Double d) {
        this.minExclusive = d;
    }

    public void setMinInclusive(double d) {
        this.minInclusive = new Double(d);
    }

    public void setMinInclusive(Double d) {
        this.minInclusive = d;
    }

    public void setFacets(SimpleType simpleType) {
        Enumeration enumeration = XSType.getFacets(simpleType);
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String string = facet.getName();
            if ("maxExclusive".equals(string)) {
                this.setMaxExclusive(facet.toDouble());
                continue;
            }
            if ("maxInclusive".equals(string)) {
                this.setMaxInclusive(facet.toDouble());
                continue;
            }
            if ("minExclusive".equals(string)) {
                this.setMinExclusive(facet.toDouble());
                continue;
            }
            if ("minInclusive".equals(string)) {
                this.setMinInclusive(facet.toDouble());
                continue;
            }
            if (!"pattern".equals(string)) continue;
            this.setPattern(facet.getValue());
        }
    }

    public String createToJavaObjectCode(String string) {
        if (SourceGenerator.usePrimitiveWrapper()) {
            return super.createToJavaObjectCode(string);
        }
        StringBuffer stringBuffer = new StringBuffer("new Double(");
        stringBuffer.append(string);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String createFromJavaObjectCode(String string) {
        StringBuffer stringBuffer = new StringBuffer("((Double)");
        stringBuffer.append(string);
        stringBuffer.append(").doubleValue()");
        return stringBuffer.toString();
    }
}

