/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.util.Enumeration;
import org.exolab.castor.builder.SourceGenerator;
import org.exolab.castor.builder.types.XSPatternBase;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JType;

public final class XSByte
extends XSPatternBase {
    Byte maxInclusive = null;
    Byte maxExclusive = null;
    Byte minInclusive = null;
    Byte minExclusive = null;
    private static JType jType = JType.Byte;

    public XSByte() {
        this(SourceGenerator.usePrimitiveWrapper());
    }

    public XSByte(boolean bl) {
        super((short)38);
        jType = bl ? new JClass("java.lang.Byte") : JType.Byte;
    }

    public JType getJType() {
        return jType;
    }

    public Byte getMaxExclusive() {
        return this.maxExclusive;
    }

    public Byte getMaxInclusive() {
        return this.maxInclusive;
    }

    public Byte getMinExclusive() {
        return this.minExclusive;
    }

    public Byte getMinInclusive() {
        return this.minInclusive;
    }

    public boolean hasMaximum() {
        return this.maxInclusive != null || this.maxExclusive != null;
    }

    public boolean hasMinimum() {
        return this.minInclusive != null || this.minExclusive != null;
    }

    public void setMaxExclusive(byte by) {
        this.maxExclusive = new Byte(by);
        this.maxInclusive = null;
    }

    public void setMaxExclusive(Byte by) {
        this.maxExclusive = by;
        this.maxInclusive = null;
    }

    public void setMaxInclusive(byte by) {
        this.maxInclusive = new Byte(by);
        this.maxExclusive = null;
    }

    public void setMaxInclusive(Byte by) {
        this.maxInclusive = by;
        this.maxExclusive = null;
    }

    public void setMinExclusive(byte by) {
        this.minExclusive = new Byte(by);
        this.minInclusive = null;
    }

    public void setMinExclusive(Byte by) {
        this.minExclusive = by;
        this.minInclusive = null;
    }

    public void setMinInclusive(byte by) {
        this.minInclusive = new Byte(by);
        this.minExclusive = null;
    }

    public void setMinInclusive(Byte by) {
        this.minInclusive = by;
        this.minExclusive = null;
    }

    public void setFacets(SimpleType simpleType) {
        Enumeration enumeration = XSType.getFacets(simpleType);
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String string = facet.getName();
            if ("maxExclusive".equals(string)) {
                this.setMaxExclusive(facet.toByte());
                continue;
            }
            if ("maxInclusive".equals(string)) {
                this.setMaxInclusive(facet.toByte());
                continue;
            }
            if ("minExclusive".equals(string)) {
                this.setMinExclusive(facet.toByte());
                continue;
            }
            if ("minInclusive".equals(string)) {
                this.setMinInclusive(facet.toByte());
                continue;
            }
            if (!"pattern".equals(string)) continue;
            this.setPattern(facet.getValue());
        }
    }

    public String createToJavaObjectCode(String string) {
        if (SourceGenerator.usePrimitiveWrapper()) {
            return super.createToJavaObjectCode(string);
        }
        StringBuffer stringBuffer = new StringBuffer("new Byte(");
        stringBuffer.append(string);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String createFromJavaObjectCode(String string) {
        StringBuffer stringBuffer = new StringBuffer("((Byte)");
        stringBuffer.append(string);
        stringBuffer.append(").byteValue()");
        return stringBuffer.toString();
    }
}

