/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi;

import com.sun.xml.registry.uddi.RegistryServiceImpl;
import com.sun.xml.registry.uddi.UDDIObjectCache;
import com.sun.xml.registry.uddi.infomodel.RegistryObjectImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.RegistryObject;

public class UDDIObjectManager
implements Serializable {
    UDDIObjectCache uddiCache;
    Collection registryServices;
    private static UDDIObjectManager instance;

    public UDDIObjectManager(RegistryServiceImpl registryServiceImpl) {
        if (this.registryServices == null) {
            this.registryServices = new ArrayList();
        }
        this.addToRegistryServices(registryServiceImpl);
        this.uddiCache = new UDDIObjectCache(this);
    }

    void addObjectsToCache(Collection collection, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        this.addToRegistryServices(registryServiceImpl);
        this.uddiCache.addObjectsToCache(collection, registryServiceImpl.getServiceId());
    }

    void addObjectToCache(RegistryObjectImpl registryObjectImpl, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        this.addToRegistryServices(registryServiceImpl);
        this.uddiCache.addObjectToCache(registryObjectImpl, registryServiceImpl.getServiceId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegistryServiceImpl getService(String string) {
        Collection collection = this.registryServices;
        synchronized (collection) {
            Iterator iterator = this.registryServices.iterator();
            while (iterator.hasNext()) {
                RegistryServiceImpl registryServiceImpl = (RegistryServiceImpl)iterator.next();
                if (!registryServiceImpl.getServiceId().equals(string)) continue;
                return registryServiceImpl;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToRegistryServices(RegistryServiceImpl registryServiceImpl) {
        Collection collection = this.registryServices;
        synchronized (collection) {
            if (!this.registryServices.contains(registryServiceImpl)) {
                this.registryServices.add(registryServiceImpl);
            }
        }
    }

    public static UDDIObjectManager getInstance(RegistryService registryService) {
        if (instance == null) {
            instance = new UDDIObjectManager((RegistryServiceImpl)registryService);
        }
        return instance;
    }

    public static UDDIObjectManager getInstance() throws JAXRException {
        if (instance == null) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIObjectManager:Has_not_been_Initialized"));
        }
        return instance;
    }

    public void fetchObject(RegistryObjectImpl registryObjectImpl, String string) throws JAXRException {
        this.uddiCache.fetchObject(registryObjectImpl, string);
    }

    public void fetchAssociations(RegistryObjectImpl registryObjectImpl, String string) throws JAXRException {
        this.uddiCache.fetchAssociations(registryObjectImpl, string);
    }

    RegistryObject fetchObjectFromCache(String string) throws JAXRException {
        return this.uddiCache.fetchObjectFromCache(string);
    }

    void removeObjectFromCache(String string) throws JAXRException {
        this.uddiCache.removeObjectFromCache(string);
    }
}

