/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.soap.dom4j;

import com.sun.xml.messaging.saaj.soap.Envelope;
import com.sun.xml.messaging.saaj.soap.dom4j.BodyImpl;
import com.sun.xml.messaging.saaj.soap.dom4j.ElementImpl;
import com.sun.xml.messaging.saaj.soap.dom4j.HeaderImpl;
import com.sun.xml.messaging.saaj.soap.dom4j.NameImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.transform.Source;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class EnvelopeImpl
extends ElementImpl
implements Envelope {
    HeaderImpl header;
    BodyImpl body;

    public EnvelopeImpl() throws SOAPException {
        super(NameImpl.createEnvelopeName());
    }

    EnvelopeImpl(boolean bl, boolean bl2) throws SOAPException {
        this();
        if (bl) {
            this.addHeader();
        }
        if (bl2) {
            this.addBody();
        }
    }

    public SOAPHeader addHeader() throws SOAPException {
        NameImpl nameImpl = NameImpl.createHeaderName();
        HeaderImpl headerImpl = (HeaderImpl)this.element(nameImpl);
        if (headerImpl == null) {
            SOAPBody sOAPBody = this.getBody();
            if (sOAPBody != null) {
                sOAPBody.detachNode();
            }
            this.header = (HeaderImpl)this.addChildElement(nameImpl);
            if (sOAPBody != null) {
                this.add((Element)sOAPBody);
            }
        } else {
            throw new SOAPException("Can't add a header when one is already present.");
        }
        return this.header;
    }

    protected void initializeHeader() throws SOAPException {
        HeaderImpl headerImpl;
        NameImpl nameImpl = NameImpl.createHeaderName();
        this.header = headerImpl = (HeaderImpl)this.element(nameImpl);
    }

    public SOAPHeader getHeader() throws SOAPException {
        this.initializeHeader();
        return this.header;
    }

    protected void initializeBody() throws SOAPException {
        BodyImpl bodyImpl;
        NameImpl nameImpl = NameImpl.createBodyName();
        this.body = bodyImpl = (BodyImpl)this.element(nameImpl);
    }

    public SOAPBody addBody() throws SOAPException {
        NameImpl nameImpl = NameImpl.createBodyName();
        BodyImpl bodyImpl = (BodyImpl)this.element(nameImpl);
        if (bodyImpl != null) {
            throw new SOAPException("Can't add a body when one is already present.");
        }
        this.body = (BodyImpl)this.addChildElement(nameImpl);
        return this.body;
    }

    public SOAPBody getBody() throws SOAPException {
        this.initializeBody();
        return this.body;
    }

    void initDocument() {
        this.setDocument(this.getDocumentFactory().createDocument(this));
    }

    public Source getContent() {
        if (this.getDocument() == null) {
            this.initDocument();
        }
        return new DocumentSource(this.getDocument());
    }

    public Name createName(String string, String string2, String string3) throws SOAPException {
        return NameImpl.create(string, Namespace.get(string2, string3));
    }

    public Name createName(String string, String string2) throws SOAPException {
        Namespace namespace = this.getNamespaceForPrefix(string2);
        if (namespace == null) {
            throw new SOAPException("Unable to locate namespace for prefix " + string2);
        }
        return NameImpl.create(string, namespace);
    }

    public Name createName(String string) throws SOAPException {
        return NameImpl.create(string);
    }

    public void output(OutputStream outputStream) throws IOException {
        if (this.getDocument() == null) {
            this.initDocument();
        }
        OutputFormat outputFormat = new OutputFormat();
        XMLWriter xMLWriter = new XMLWriter(outputStream, outputFormat);
        xMLWriter.write(this.getDocument());
    }

    public void prettyPrint(OutputStream outputStream) throws IOException {
        if (this.getDocument() == null) {
            this.initDocument();
        }
        OutputFormat outputFormat = OutputFormat.createPrettyPrint();
        outputFormat.setIndentSize(2);
        outputFormat.setNewlines(true);
        outputFormat.setTrimText(true);
        outputFormat.setPadText(true);
        outputFormat.setExpandEmptyElements(false);
        XMLWriter xMLWriter = new XMLWriter(outputStream, outputFormat);
        xMLWriter.write(this.getDocument());
    }

    public void prettyPrint(Writer writer) throws IOException {
        if (this.getDocument() == null) {
            this.initDocument();
        }
        OutputFormat outputFormat = OutputFormat.createPrettyPrint();
        outputFormat.setIndentSize(2);
        outputFormat.setNewlines(true);
        outputFormat.setTrimText(true);
        outputFormat.setPadText(true);
        outputFormat.setExpandEmptyElements(false);
        XMLWriter xMLWriter = new XMLWriter(writer, outputFormat);
        xMLWriter.write(this.getDocument());
    }
}

