/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.soap.dom4j;

import com.sun.xml.messaging.saaj.soap.dom4j.NameImpl;
import com.sun.xml.messaging.saaj.util.JaxmURI;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.Text;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.tree.DefaultElement;
import org.dom4j.tree.FilterIterator;

public class ElementImpl
extends DefaultElement
implements SOAPElement {
    static final String cdataUC = "<![CDATA[";
    static final String cdataLC = "<![cdata[";
    Name encodingStyleAttName = NameImpl.create("encodingStyle", NameImpl.soapNamespace);

    public ElementImpl(String string) {
        super(string);
    }

    public ElementImpl(NameImpl nameImpl) {
        super(nameImpl);
    }

    public SOAPElement addChildElement(Name name) throws SOAPException {
        NameImpl nameImpl = (NameImpl)name;
        return (SOAPElement)this.addElement(nameImpl);
    }

    public SOAPElement addChildElement(String string) throws SOAPException {
        return this.addChildElement(NameImpl.create(string));
    }

    public SOAPElement addChildElement(String string, String string2) throws SOAPException {
        Namespace namespace = this.getNamespaceForPrefix(string2);
        if (namespace == null) {
            throw new SOAPException("Unable to locate namespace for prefix " + string2);
        }
        return this.addChildElement(NameImpl.create(string, namespace));
    }

    public SOAPElement addChildElement(SOAPElement sOAPElement) throws SOAPException {
        if (sOAPElement.getElementName().getURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            throw new SOAPException("Can not add fragments which contain elements which are in the SOAP namespace");
        }
        SOAPElement sOAPElement2 = this.addChildElement(sOAPElement.getElementName());
        try {
            String string;
            String string2 = sOAPElement.getEncodingStyle();
            if (string2 != null) {
                sOAPElement2.setEncodingStyle(string2);
            }
            Iterator iterator = sOAPElement.getNamespacePrefixes();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                sOAPElement2.addNamespaceDeclaration(string, sOAPElement.getNamespaceURI(string));
            }
            iterator = sOAPElement.getAllAttributes();
            while (iterator.hasNext()) {
                string = (Name)iterator.next();
                sOAPElement2.addAttribute((Name)string, sOAPElement.getAttributeValue((Name)string));
            }
            iterator = sOAPElement.getChildElements();
            while (iterator.hasNext()) {
                string = (Node)iterator.next();
                if (string instanceof Text) {
                    sOAPElement2.addTextNode(string.getValue());
                    continue;
                }
                if (string instanceof SOAPElement) {
                    sOAPElement2.addChildElement((SOAPElement)string);
                    continue;
                }
                throw new SOAPException("Invalid element type: " + sOAPElement.getElementName().getQualifiedName());
            }
        }
        catch (SOAPException sOAPException) {
            sOAPElement2.detachNode();
            throw sOAPException;
        }
        return sOAPElement2;
    }

    public SOAPElement addChildElement(String string, String string2, String string3) throws SOAPException {
        return this.addChildElement(NameImpl.create(string, Namespace.get(string2, string3)));
    }

    public SOAPElement addTextNode(String string) throws SOAPException {
        if (string.startsWith(cdataUC) || string.startsWith(cdataLC)) {
            return (SOAPElement)this.addCDATA(string);
        }
        return (SOAPElement)this.addText(string);
    }

    public SOAPElement addAttribute(Name name, String string) throws SOAPException {
        this.addAttribute((QName)name, string);
        return this;
    }

    public SOAPElement addNamespaceDeclaration(String string, String string2) throws SOAPException {
        this.addNamespace(string, string2);
        return this;
    }

    public String getAttributeValue(Name name) {
        return this.attributeValue((QName)name);
    }

    public Iterator getAllAttributes() {
        return new Iterator(){
            Iterator orig;
            {
                this.orig = ElementImpl.this.attributes().listIterator();
            }

            public boolean hasNext() {
                return this.orig.hasNext();
            }

            public Object next() {
                Attribute attribute = (Attribute)this.orig.next();
                return attribute.getQName();
            }

            public void remove() {
                this.orig.remove();
            }
        };
    }

    public String getNamespaceURI(String string) {
        Namespace namespace = this.getNamespaceForPrefix(string);
        if (namespace != null) {
            return namespace.getURI();
        }
        return null;
    }

    public Iterator getNamespacePrefixes() {
        return new Iterator(){
            Iterator namespaces;
            {
                this.namespaces = ElementImpl.this.additionalNamespaces().listIterator();
            }

            public boolean hasNext() {
                return this.namespaces.hasNext();
            }

            public Object next() {
                Namespace namespace = (Namespace)this.namespaces.next();
                return namespace.getPrefix();
            }

            public void remove() {
                this.namespaces.remove();
            }
        };
    }

    public Name getElementName() {
        return (Name)this.getQName();
    }

    public boolean removeAttribute(Name name) {
        Attribute attribute = this.attribute((QName)name);
        if (attribute != null) {
            return this.remove(attribute);
        }
        return false;
    }

    public boolean removeNamespaceDeclaration(String string) {
        Namespace namespace = this.getNamespaceForPrefix(string);
        if (namespace != null) {
            return this.remove(namespace);
        }
        return false;
    }

    public Iterator getChildElements() {
        return new FilterIterator(this.nodeIterator()){

            protected boolean matches(Object object) {
                return object instanceof SOAPElement || object instanceof Text;
            }
        };
    }

    public Iterator getChildElements(Name name) {
        return this.elementIterator((QName)name);
    }

    public void setEncodingStyle(String string) throws SOAPException {
        try {
            JaxmURI jaxmURI = new JaxmURI(string);
        }
        catch (JaxmURI.MalformedURIException malformedURIException) {
            throw new IllegalArgumentException("Encoding style (" + string + ") should be a valid URI");
        }
        this.removeAttribute(this.encodingStyleAttName);
        this.addAttribute(this.encodingStyleAttName, string);
    }

    public String getEncodingStyle() {
        return this.getAttributeValue(this.encodingStyleAttName);
    }

    public String getValue() {
        String string = this.getText();
        if (string.equals("")) {
            return null;
        }
        return string;
    }

    public void setParentElement(SOAPElement sOAPElement) {
        if (sOAPElement == null) {
            throw new IllegalArgumentException("Null argument to setParentElement");
        }
        this.setParent((Element)sOAPElement);
    }

    public SOAPElement getParentElement() {
        return (SOAPElement)this.getParent();
    }

    public void detachNode() {
        super.detach();
    }

    public void recycleNode() {
        this.detachNode();
    }
}

