/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.soap.dom4j;

import com.sun.xml.messaging.saaj.soap.dom4j.BodyImpl;
import com.sun.xml.messaging.saaj.soap.dom4j.CDATAImpl;
import com.sun.xml.messaging.saaj.soap.dom4j.ElementImpl;
import com.sun.xml.messaging.saaj.soap.dom4j.EnvelopeImpl;
import com.sun.xml.messaging.saaj.soap.dom4j.HeaderImpl;
import com.sun.xml.messaging.saaj.soap.dom4j.NameCache;
import com.sun.xml.messaging.saaj.soap.dom4j.NameImpl;
import com.sun.xml.messaging.saaj.soap.dom4j.TextImpl;
import com.sun.xml.messaging.saaj.soap.dom4j.TreeException;
import com.sun.xml.messaging.util.StringManager;
import java.util.Map;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.CDATA;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.Namespace;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;
import org.dom4j.Text;

public class ElementFactory
extends DocumentFactory {
    static ElementFactory singleton = new ElementFactory();
    static Log logger = LogFactory.getLog((String)"javax.enterprise.system.webservices.saaj");
    static StringManager localStrings = StringManager.getManager("com.sun.xml.messaging");

    public static DocumentFactory getInstance() {
        return singleton;
    }

    ElementFactory() {
        this.cache = new NameCache(this);
    }

    public Element createElement(QName qName) {
        try {
            if (qName.getName().equalsIgnoreCase("Envelope") && NameImpl.soapNamespace.getURI().equals(qName.getNamespace().getURI())) {
                return new EnvelopeImpl();
            }
            if (qName.getName().equalsIgnoreCase("Body") && NameImpl.soapNamespace.getURI().equals(qName.getNamespace().getURI())) {
                return new BodyImpl();
            }
            if (qName.getName().equalsIgnoreCase("Header") && NameImpl.soapNamespace.getURI().equals(qName.getNamespace().getURI())) {
                return new HeaderImpl();
            }
        }
        catch (SOAPException sOAPException) {
            String string = localStrings.getString("saaj.exception.create_error");
            logger.error((Object)(string + " " + qName), (Throwable)sOAPException);
            this.invalidCreate(string + " " + qName);
        }
        return new ElementImpl((NameImpl)qName);
    }

    public Text createText(String string) {
        return new TextImpl(string);
    }

    public CDATA createCDATA(String string) {
        return new CDATAImpl(string);
    }

    public Entity createEntity(String string, String string2) {
        String string3 = localStrings.getString("saaj.exception.entities_illegal_soap");
        this.invalidCreate(string3);
        return null;
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) {
        String string3 = localStrings.getString("saaj.exception.pi_illegal_soap");
        this.invalidCreate(string3);
        return null;
    }

    public ProcessingInstruction createProcessingInstruction(String string, Map map) {
        String string2 = localStrings.getString("saaj.exception.pi_illegal_soap");
        this.invalidCreate(string2);
        return null;
    }

    public QName createQName(String string, Namespace namespace) {
        return this.cache.get(string, namespace);
    }

    public QName createQName(String string) {
        return this.cache.get(string);
    }

    public QName createQName(String string, String string2) {
        return this.cache.get(string, string2);
    }

    protected void invalidCreate(String string) {
        throw new TreeException(string);
    }
}

