/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.soap;

import com.sun.xml.messaging.saaj.soap.AttachmentPartImpl;
import com.sun.xml.messaging.saaj.soap.Envelope;
import com.sun.xml.messaging.saaj.soap.EnvelopeFactory;
import com.sun.xml.messaging.saaj.util.ByteInputStream;
import com.sun.xml.messaging.saaj.util.ByteOutputStream;
import com.sun.xml.messaging.saaj.util.JAXMStreamSource;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.internet.MimeBodyPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class SOAPPartImpl
extends SOAPPart {
    static EnvelopeFactory envFactory = null;
    MimeHeaders headers = new MimeHeaders();
    Envelope envelope;
    Source source;

    public SOAPPartImpl() {
        this.headers.setHeader("Content-Type", "text/xml");
        if (envFactory == null) {
            envFactory = EnvelopeFactory.getInstance();
        }
    }

    public SOAPEnvelope getEnvelope() throws SOAPException {
        if (this.envelope != null) {
            if (this.source == null) {
                return this.envelope;
            }
            this.envelope = envFactory.createEnvelope(this.source);
            this.source = null;
            return this.envelope;
        }
        if (this.source != null) {
            this.envelope = envFactory.createEnvelope(this.source);
            this.source = null;
            return this.envelope;
        }
        this.envelope = envFactory.createEnvelope();
        return this.envelope;
    }

    public void removeAllMimeHeaders() {
        this.headers.removeAllHeaders();
    }

    public void removeMimeHeader(String string) {
        this.headers.removeHeader(string);
    }

    public String[] getMimeHeader(String string) {
        return this.headers.getHeader(string);
    }

    public void setMimeHeader(String string, String string2) {
        this.headers.setHeader(string, string2);
    }

    public void addMimeHeader(String string, String string2) {
        this.headers.addHeader(string, string2);
    }

    public Iterator getAllMimeHeaders() {
        return this.headers.getAllHeaders();
    }

    public Iterator getMatchingMimeHeaders(String[] stringArray) {
        return this.headers.getMatchingHeaders(stringArray);
    }

    public Iterator getNonMatchingMimeHeaders(String[] stringArray) {
        return this.headers.getNonMatchingHeaders(stringArray);
    }

    public Source getContent() throws SOAPException {
        if (this.source != null) {
            return this.source;
        }
        return ((Envelope)this.getEnvelope()).getContent();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setContent(Source source) throws SOAPException {
        try {
            if (source instanceof StreamSource) {
                InputStream inputStream = ((StreamSource)source).getInputStream();
                Reader reader = ((StreamSource)source).getReader();
                if (inputStream != null) {
                    this.source = new JAXMStreamSource(inputStream);
                    return;
                } else {
                    if (reader == null) throw new SOAPException("Source does not have a valid Reader or InputStream");
                    this.source = new JAXMStreamSource(reader);
                }
                return;
            } else {
                this.source = source;
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SOAPException("Error setting the source for SOAPPart: " + exception.getMessage());
        }
    }

    public ByteInputStream getContentAsStream() throws IOException {
        Closeable closeable;
        if (this.source != null && this.source instanceof StreamSource && (closeable = ((StreamSource)this.source).getInputStream()) != null) {
            if (!(closeable instanceof ByteInputStream)) {
                throw new IOException("Internal error: stream not of the right type");
            }
            return (ByteInputStream)closeable;
        }
        closeable = new ByteOutputStream();
        Envelope envelope = null;
        try {
            envelope = (Envelope)this.getEnvelope();
            envelope.output((OutputStream)closeable);
        }
        catch (SOAPException sOAPException) {
            throw new IOException("SOAP exception while trying to externalize: " + sOAPException.getMessage());
        }
        return new ByteInputStream(((ByteOutputStream)closeable).getBytes(), ((ByteOutputStream)closeable).getCount());
    }

    MimeBodyPart getMimePart() throws SOAPException {
        try {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setDataHandler(this.getDataHandler());
            AttachmentPartImpl.copyMimeHeaders(this.headers, mimeBodyPart);
            return mimeBodyPart;
        }
        catch (SOAPException sOAPException) {
            throw sOAPException;
        }
        catch (Exception exception) {
            throw new SOAPException("Unable to externalize header", (Throwable)exception);
        }
    }

    MimeHeaders getMimeHeaders() {
        return this.headers;
    }

    DataHandler getDataHandler() {
        DataSource dataSource = new DataSource(){

            public OutputStream getOutputStream() throws IOException {
                throw new IOException("Illegal Operation");
            }

            public String getContentType() {
                return "text/xml";
            }

            public String getName() {
                return SOAPPartImpl.this.getContentId();
            }

            public InputStream getInputStream() throws IOException {
                return SOAPPartImpl.this.getContentAsStream();
            }
        };
        return new DataHandler(dataSource);
    }
}

