/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.soap;

import com.sun.xml.messaging.saaj.soap.AttachmentPartImpl;
import com.sun.xml.messaging.saaj.soap.SOAPPartImpl;
import com.sun.xml.messaging.saaj.util.ByteInputStream;
import com.sun.xml.messaging.saaj.util.ByteOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParameterList;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class MessageImpl
extends SOAPMessage {
    private MimeHeaders headers;
    private SOAPPartImpl soapPart;
    private Vector attachments;
    private boolean saved = false;
    private byte[] messageBytes;
    private int messageByteCount;
    private static final Iterator nullIter = new Iterator(){

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        public void remove() {
            throw new IllegalStateException();
        }
    };

    public MessageImpl() {
        this.headers = new MimeHeaders();
    }

    public MessageImpl(SOAPMessage sOAPMessage) {
        if (!(sOAPMessage instanceof MessageImpl)) {
            // empty if block
        }
        MessageImpl messageImpl = (MessageImpl)sOAPMessage;
        this.headers = messageImpl.headers;
        this.soapPart = messageImpl.soapPart;
        this.attachments = messageImpl.attachments;
        this.saved = messageImpl.saved;
        this.messageBytes = messageImpl.messageBytes;
        this.messageByteCount = messageImpl.messageByteCount;
    }

    public MessageImpl(MimeHeaders mimeHeaders, final InputStream inputStream) throws IOException, SOAPException {
        this.headers = mimeHeaders;
        final String string = this.getContentType();
        if (string == null) {
            throw new SOAPException("Absent Content-Type");
        }
        try {
            ContentType contentType = new ContentType(string);
            int n = this.verify(contentType);
            if (n == 1) {
                this.getSOAPPart().setContent((Source)new StreamSource(inputStream));
            } else {
                DataSource dataSource = new DataSource(){

                    public InputStream getInputStream() {
                        return inputStream;
                    }

                    public OutputStream getOutputStream() {
                        return null;
                    }

                    public String getContentType() {
                        return string;
                    }

                    public String getName() {
                        return "";
                    }
                };
                MimeMultipart mimeMultipart = new MimeMultipart(dataSource);
                MimeBodyPart mimeBodyPart = (MimeBodyPart)mimeMultipart.getBodyPart(0);
                this.getSOAPPart().setContent((Source)new StreamSource(mimeBodyPart.getInputStream()));
                for (int i = 1; i < mimeMultipart.getCount(); ++i) {
                    MimeBodyPart mimeBodyPart2 = (MimeBodyPart)mimeMultipart.getBodyPart(i);
                    AttachmentPartImpl attachmentPartImpl = new AttachmentPartImpl();
                    DataHandler dataHandler = mimeBodyPart2.getDataHandler();
                    attachmentPartImpl.setDataHandler(dataHandler);
                    AttachmentPartImpl.copyMimeHeaders(mimeBodyPart2, attachmentPartImpl);
                    this.addAttachmentPart(attachmentPartImpl);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new SOAPException("Unable to internalize message", throwable);
        }
        this.needsSave();
    }

    private int verify(ContentType contentType) throws SOAPException {
        String string = contentType.getPrimaryType();
        String string2 = contentType.getSubType();
        if (!string.equalsIgnoreCase("multipart")) {
            if (string.equalsIgnoreCase("text") && string2.equalsIgnoreCase("xml")) {
                return 1;
            }
            throw new SOAPException("Invalid Content-Type:" + string + "/" + string2);
        }
        if (string2.equalsIgnoreCase("related")) {
            String string3 = contentType.getParameter("type").toLowerCase();
            if (string3.startsWith("text/xml")) {
                return 2;
            }
            throw new SOAPException("Content-Type needs to be Multipart/Related and with \"type=text/xml\"");
        }
        throw new SOAPException("Invalid Content-Type: " + string + "/" + string2);
    }

    public MimeHeaders getMimeHeaders() {
        return this.headers;
    }

    final String getContentType() {
        String[] stringArray = this.headers.getHeader("Content-Type");
        if (stringArray == null) {
            return null;
        }
        return stringArray[0];
    }

    private final void needsSave() {
        this.saved = false;
    }

    public synchronized boolean saveRequired() {
        return !this.saved;
    }

    public String getContentDescription() {
        String[] stringArray = this.headers.getHeader("Content-Description");
        if (stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    public void setContentDescription(String string) {
        this.headers.setHeader("Content-Description", string);
        this.needsSave();
    }

    public SOAPPart getSOAPPart() {
        if (this.soapPart == null) {
            this.soapPart = new SOAPPartImpl();
        }
        return this.soapPart;
    }

    public void removeAllAttachments() {
        if (this.attachments != null) {
            this.attachments.removeAllElements();
            this.needsSave();
        }
    }

    public int countAttachments() {
        if (this.attachments != null) {
            return this.attachments.size();
        }
        return 0;
    }

    public void addAttachmentPart(AttachmentPart attachmentPart) {
        if (this.attachments == null) {
            this.attachments = new Vector();
        }
        this.attachments.addElement(attachmentPart);
        this.needsSave();
    }

    public Iterator getAttachments() {
        if (this.attachments == null) {
            return nullIter;
        }
        return this.attachments.iterator();
    }

    public Iterator getAttachments(MimeHeaders mimeHeaders) {
        if (this.attachments == null) {
            return nullIter;
        }
        return new MimeMatchingIterator(mimeHeaders);
    }

    public AttachmentPart createAttachmentPart() {
        return new AttachmentPartImpl();
    }

    private final ByteInputStream getHeaderBytes() throws SOAPException, IOException {
        SOAPPartImpl sOAPPartImpl = (SOAPPartImpl)this.getSOAPPart();
        return sOAPPartImpl.getContentAsStream();
    }

    private MimeMultipart getMimeMessage() throws SOAPException {
        try {
            MimeMultipart mimeMultipart = new MimeMultipart();
            SOAPPartImpl sOAPPartImpl = (SOAPPartImpl)this.getSOAPPart();
            mimeMultipart.addBodyPart((BodyPart)sOAPPartImpl.getMimePart());
            Iterator iterator = this.getAttachments();
            while (iterator.hasNext()) {
                mimeMultipart.addBodyPart((BodyPart)((AttachmentPartImpl)((Object)iterator.next())).getMimePart());
            }
            iterator = new ContentType(mimeMultipart.getContentType());
            ParameterList parameterList = new ParameterList();
            parameterList.set("type", "text/xml");
            parameterList.set("boundary", iterator.getParameter("boundary"));
            ContentType contentType = new ContentType("multipart", "related", parameterList);
            this.headers.setHeader("Content-Type", contentType.toString());
            return mimeMultipart;
        }
        catch (SOAPException sOAPException) {
            throw sOAPException;
        }
        catch (Throwable throwable) {
            throw new SOAPException("Unable to convert SOAP message into a MimeMultipart object", throwable);
        }
    }

    public synchronized void saveChanges() throws SOAPException {
        Closeable closeable;
        if (this.countAttachments() == 0) {
            closeable = null;
            try {
                closeable = this.getHeaderBytes();
            }
            catch (IOException iOException) {
                throw new SOAPException("Unable to get header stream in saveChanges: " + iOException.getMessage());
            }
            this.messageBytes = ((ByteInputStream)closeable).getBytes();
            this.messageByteCount = ((ByteInputStream)closeable).getCount();
            this.headers.setHeader("Content-Type", "text/xml; charset=\"utf-8\"");
            this.headers.setHeader("Content-Length", Integer.toString(this.messageByteCount));
        } else {
            closeable = new ByteOutputStream();
            try {
                this.getMimeMessage().writeTo((OutputStream)closeable);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw new SOAPException("Error during saving a multipart message", throwable);
            }
            this.messageBytes = ((ByteOutputStream)closeable).getBytes();
            this.messageByteCount = ((ByteOutputStream)closeable).getCount();
            this.headers.setHeader("Content-Length", Integer.toString(this.messageByteCount));
        }
        closeable = this.headers.getHeader("SOAPAction");
        if (closeable == null || ((Closeable)closeable).length == 0) {
            this.headers.setHeader("SOAPAction", "\"\"");
        }
        this.saved = true;
    }

    public void writeTo(OutputStream outputStream) throws SOAPException, IOException {
        if (this.saveRequired()) {
            this.saveChanges();
        }
        outputStream.write(this.messageBytes, 0, this.messageByteCount);
        this.messageBytes = null;
        this.needsSave();
    }

    private class MimeMatchingIterator
    implements Iterator {
        private Iterator iter;
        private MimeHeaders headers;
        private Object nextAttachment;

        public MimeMatchingIterator(MimeHeaders mimeHeaders) {
            this.headers = mimeHeaders;
            this.iter = MessageImpl.this.attachments.iterator();
        }

        public boolean hasNext() {
            if (this.nextAttachment == null) {
                this.nextAttachment = this.nextMatch();
            }
            return this.nextAttachment != null;
        }

        public Object next() {
            if (this.nextAttachment != null) {
                Object object = this.nextAttachment;
                this.nextAttachment = null;
                return object;
            }
            if (this.hasNext()) {
                return this.nextAttachment;
            }
            return null;
        }

        Object nextMatch() {
            while (this.iter.hasNext()) {
                AttachmentPartImpl attachmentPartImpl = (AttachmentPartImpl)((Object)this.iter.next());
                if (!attachmentPartImpl.hasAllHeaders(this.headers)) continue;
                return attachmentPartImpl;
            }
            return null;
        }

        public void remove() {
            this.iter.remove();
        }
    }
}

