/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.client.p2p;

import com.sun.xml.messaging.saaj.client.p2p.http.handler.HttpURLConnection;
import com.sun.xml.messaging.saaj.util.Base64;
import com.sun.xml.messaging.saaj.util.ByteInputStream;
import com.sun.xml.messaging.saaj.util.JaxmURI;
import com.sun.xml.messaging.saaj.util.ParseUtil;
import com.sun.xml.messaging.util.StringManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.util.StringTokenizer;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpSOAPConnection
extends SOAPConnection {
    static Log logger = LogFactory.getLog((String)"javax.enterprise.system.webservices.saaj");
    static StringManager localStrings = StringManager.getManager("com.sun.xml.messaging");
    public static String defaultProxyHost = null;
    public static int defaultProxyPort = -1;
    MessageFactory messageFactory = null;
    boolean closed = false;
    private String proxyHost = defaultProxyHost;
    private int proxyPort = defaultProxyPort;
    private static String SSL_PKG = "com.sun.net.ssl.internal.www.protocol";
    private static String SSL_PROVIDER = "com.sun.net.ssl.internal.ssl.Provider";
    private static final int dL = 0;
    private static final boolean _overrideDefaultHttpHandler;

    public HttpSOAPConnection() throws SOAPException {
        try {
            this.messageFactory = MessageFactory.newInstance();
        }
        catch (Exception exception) {
            String string = localStrings.getString("saaj.error.msg_factory");
            logger.error((Object)string, (Throwable)exception);
            throw new SOAPException(string, (Throwable)exception);
        }
    }

    public void close() throws SOAPException {
        if (this.closed) {
            String string = localStrings.getString("saaj.exception.conn_already_closed");
            throw new SOAPException(string);
        }
        this.messageFactory = null;
        this.closed = true;
    }

    public SOAPMessage call(SOAPMessage sOAPMessage, Object object) throws SOAPException {
        Object object2;
        Object object3;
        if (this.closed) {
            String string = localStrings.getString("saaj.exception.conn_closed");
            throw new SOAPException(string);
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName("javax.xml.messaging.URLEndpoint");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz != null && clazz.isInstance(object)) {
            object3 = null;
            try {
                object2 = clazz.getMethod("getURL", null);
                object3 = (String)((Method)object2).invoke(object, null);
            }
            catch (Exception exception) {
                String string = localStrings.getString("saaj.exception.internal_err");
                throw new SOAPException(string + exception.getMessage());
            }
            try {
                object = new URL((String)object3);
            }
            catch (MalformedURLException malformedURLException) {
                String string = localStrings.getString("saaj.exception.bad_url");
                throw new SOAPException(string + malformedURLException.getMessage());
            }
        }
        if (object instanceof String) {
            try {
                object = new URL((String)object);
            }
            catch (MalformedURLException malformedURLException) {
                object2 = localStrings.getString("saaj.exception.bad_url");
                throw new SOAPException((String)object2 + malformedURLException.getMessage());
            }
        }
        if (object instanceof URL) {
            try {
                object3 = new PriviledgedPost(this, sOAPMessage, (URL)object);
                object2 = (SOAPMessage)AccessController.doPrivileged(object3);
                return object2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new SOAPException((Throwable)exception);
            }
        }
        object3 = localStrings.getString("saaj.exception.bad_endpoint");
        throw new SOAPException((String)object3 + object);
    }

    public void setProxy(String string, int n) {
        this.proxyHost = string;
        this.proxyPort = n;
        System.setProperty("http.proxyHost", this.proxyHost);
        System.setProperty("http.proxyPort", new Integer(this.proxyPort).toString());
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    SOAPMessage post(SOAPMessage sOAPMessage, URL uRL) throws SOAPException {
        Object[] objectArray;
        Object object;
        int n;
        Object object2;
        Object object3;
        String string;
        JaxmURI jaxmURI;
        int n2;
        java.net.HttpURLConnection httpURLConnection;
        boolean bl;
        block26: {
            bl = false;
            URL uRL2 = null;
            httpURLConnection = null;
            n2 = 0;
            try {
                if (uRL.getProtocol().equals("https")) {
                    this.initHttps();
                }
                jaxmURI = new JaxmURI(uRL.toString());
                string = jaxmURI.getUserinfo();
                uRL2 = new URL(jaxmURI.getScheme(), jaxmURI.getHost(), jaxmURI.getPort(), jaxmURI.getPath());
                if (logger.isDebugEnabled()) {
                    this.d("uri: " + string + " " + uRL2 + " " + jaxmURI);
                }
                if (!uRL2.getProtocol().equalsIgnoreCase("http") && !uRL2.getProtocol().equalsIgnoreCase("https")) {
                    throw new IllegalArgumentException("Protocol " + uRL2.getProtocol() + " not supported in URL " + uRL2);
                }
                httpURLConnection = this.createConnection(uRL2);
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setDoInput(true);
                httpURLConnection.setUseCaches(false);
                java.net.HttpURLConnection.setFollowRedirects(true);
                if (sOAPMessage.saveRequired()) {
                    sOAPMessage.saveChanges();
                }
                object3 = sOAPMessage.getMimeHeaders();
                object2 = object3.getAllHeaders();
                n = 0;
                while (object2.hasNext()) {
                    object = (MimeHeader)object2.next();
                    objectArray = object3.getHeader(object.getName());
                    if (objectArray.length == 1) {
                        httpURLConnection.setRequestProperty(object.getName(), object.getValue());
                    } else {
                        StringBuffer stringBuffer = new StringBuffer();
                        for (int i = 0; i < objectArray.length; ++i) {
                            if (i != 0) {
                                stringBuffer.append(',');
                            }
                            stringBuffer.append(objectArray[i]);
                        }
                        httpURLConnection.setRequestProperty(object.getName(), stringBuffer.toString());
                    }
                    if (!"Authorization".equals(object.getName())) continue;
                    n = 1;
                }
                if (n == 0 && string != null) {
                    this.initAuthUserInfo(httpURLConnection, string);
                }
                object = httpURLConnection.getOutputStream();
                sOAPMessage.writeTo((OutputStream)object);
                ((OutputStream)object).flush();
                ((OutputStream)object).close();
                httpURLConnection.connect();
                try {
                    n2 = httpURLConnection.getResponseCode();
                    if (n2 == 500) {
                        bl = true;
                    } else if (n2 / 100 != 2) {
                        throw new SOAPException("Bad response: (" + n2 + httpURLConnection.getResponseMessage());
                    }
                }
                catch (IOException iOException) {
                    n2 = httpURLConnection.getResponseCode();
                    if (n2 == 500) {
                        bl = true;
                        break block26;
                    }
                    throw iOException;
                }
            }
            catch (SOAPException sOAPException) {
                sOAPException.printStackTrace();
                throw sOAPException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                String string2 = localStrings.getString("saaj.exception.msg_send_failed");
                throw new SOAPException(string2, (Throwable)exception);
            }
        }
        jaxmURI = null;
        if (n2 == 200 || bl) {
            try {
                string = new MimeHeaders();
                n = 1;
                while (true) {
                    object3 = httpURLConnection.getHeaderFieldKey(n);
                    object2 = httpURLConnection.getHeaderField(n);
                    if (object3 == null && object2 == null) break;
                    if (object3 != null) {
                        object = new StringTokenizer((String)object2, ",");
                        while (((StringTokenizer)object).hasMoreTokens()) {
                            string.addHeader((String)object3, ((StringTokenizer)object).nextToken().trim());
                        }
                    }
                    ++n;
                }
                object = bl ? httpURLConnection.getErrorStream() : httpURLConnection.getInputStream();
                objectArray = this.readFully((InputStream)object);
                int n3 = httpURLConnection.getContentLength() == -1 ? objectArray.length : httpURLConnection.getContentLength();
                ByteInputStream byteInputStream = new ByteInputStream((byte[])objectArray, n3);
                jaxmURI = this.messageFactory.createMessage((MimeHeaders)string, (InputStream)byteInputStream);
                ((InputStream)object).close();
                httpURLConnection.disconnect();
            }
            catch (SOAPException sOAPException) {
                sOAPException.printStackTrace();
                throw sOAPException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                object3 = localStrings.getString("saaj.exception.cannot_read_resp");
                throw new SOAPException((String)object3 + exception.getMessage());
            }
        }
        return jaxmURI;
    }

    private byte[] readFully(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        return byArray2;
    }

    private void initHttps() {
        Object object;
        String string = System.getProperty("java.protocol.handler.pkgs");
        if (logger.isDebugEnabled()) {
            object = localStrings.getString("saaj.debug.providers");
            logger.debug((Object)((String)object + " " + string));
        }
        if (string == null || string.indexOf(SSL_PKG) < 0) {
            string = string == null ? SSL_PKG : SSL_PKG + "|" + string;
            System.setProperty("java.protocol.handler.pkgs", string);
            if (logger.isDebugEnabled()) {
                object = localStrings.getString("saaj.debug.set_providers");
                logger.debug((Object)((String)object + " " + string));
            }
            try {
                object = Class.forName(SSL_PROVIDER);
                Class<?> clazz = Class.forName(SSL_PKG + ".https.Handler");
                Provider provider = (Provider)((Class)object).newInstance();
                Security.addProvider(provider);
                if (logger.isDebugEnabled()) {
                    String string2 = localStrings.getString("saaj.debug.add_sslprovider");
                    logger.debug((Object)(string2 + " " + SSL_PROVIDER));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void initAuthUserInfo(java.net.HttpURLConnection httpURLConnection, String string) {
        if (string != null) {
            String string2;
            String string3;
            int n = string.indexOf(58);
            if (n == -1) {
                string3 = ParseUtil.decode(string);
                string2 = null;
            } else {
                string3 = ParseUtil.decode(string.substring(0, n++));
                string2 = ParseUtil.decode(string.substring(n));
            }
            String string4 = string3 + ":";
            byte[] byArray = string4.getBytes();
            byte[] byArray2 = string2.getBytes();
            byte[] byArray3 = new byte[byArray.length + byArray2.length];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
            String string5 = "Basic " + new String(Base64.encode(byArray3));
            httpURLConnection.setRequestProperty("Authorization", string5);
            if (logger.isDebugEnabled()) {
                this.d("Adding auth " + string5);
            }
        }
    }

    private void d(String string) {
        String string2 = localStrings.getString("saaj.error.http_soap_conn");
        logger.debug((Object)(string2 + " " + string));
    }

    private java.net.HttpURLConnection createConnection(URL uRL) throws IOException {
        if (_overrideDefaultHttpHandler) {
            return new HttpURLConnection(uRL, null, 80);
        }
        return (java.net.HttpURLConnection)uRL.openConnection();
    }

    static {
        String string = System.getProperty("java.specification.version");
        String string2 = System.getProperty("java.vm.version");
        boolean bl = false;
        if (string.equals("1.3") && string2.startsWith("1.3") && !string2.startsWith("1.3.1_")) {
            bl = true;
        }
        _overrideDefaultHttpHandler = bl;
    }

    static class PriviledgedPost
    implements PrivilegedExceptionAction {
        HttpSOAPConnection c;
        SOAPMessage message;
        URL endPoint;

        PriviledgedPost(HttpSOAPConnection httpSOAPConnection, SOAPMessage sOAPMessage, URL uRL) {
            this.c = httpSOAPConnection;
            this.message = sOAPMessage;
            this.endPoint = uRL;
        }

        public Object run() throws Exception {
            return this.c.post(this.message, this.endPoint);
        }
    }
}

