/*
 * Decompiled with CFR 0.152.
 */
package com.sun.activation.registries;

import com.sun.activation.registries.MailcapEntry;
import com.sun.activation.registries.MailcapParseException;
import com.sun.activation.registries.MailcapTokenizer;
import com.sun.mail.util.i18n.StringManager;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MailcapFile {
    private static Log _logger = LogFactory.getLog((String)"javax.enterprise.system.activation");
    private static StringManager localStrings = StringManager.getManager((String)"com.sun.activation");
    private Hashtable type_hash = null;
    private static boolean debug = false;

    public MailcapFile(String string) throws IOException {
        Object object;
        if (debug && _logger.isDebugEnabled()) {
            object = localStrings.getString("jaf.new_mailcap_file");
            _logger.debug((Object)((String)object + " " + string));
        }
        object = null;
        object = new FileReader(string);
        this.type_hash = this.createMailcapHash((Reader)object);
    }

    public MailcapFile(InputStream inputStream) throws IOException {
        if (debug && _logger.isDebugEnabled()) {
            String string = localStrings.getString("jaf.new_mailcap_inputstream");
            _logger.debug((Object)string);
        }
        this.type_hash = this.createMailcapHash(new InputStreamReader(inputStream, "iso-8859-1"));
    }

    public MailcapFile() {
        if (debug) {
            this.type_hash = new Hashtable();
        }
    }

    public MailcapEntry getMailcapEntry(String string) {
        MailcapEntry mailcapEntry = null;
        Object var3_3 = null;
        return mailcapEntry;
    }

    public Hashtable getMailcapList(String string) {
        Hashtable hashtable = null;
        Hashtable hashtable2 = null;
        hashtable = (Hashtable)this.type_hash.get(string);
        int n = string.indexOf(47);
        String string2 = string.substring(0, n + 1) + "*";
        hashtable2 = (Hashtable)this.type_hash.get(string2);
        if (hashtable2 != null) {
            hashtable = hashtable != null ? this.mergeResults(hashtable, hashtable2) : hashtable2;
        }
        return hashtable;
    }

    private Hashtable mergeResults(Hashtable hashtable, Hashtable hashtable2) {
        Enumeration enumeration = hashtable2.keys();
        Hashtable hashtable3 = (Hashtable)hashtable.clone();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector = (Vector)hashtable3.get(string);
            if (vector == null) {
                hashtable3.put(string, hashtable2.get(string));
                continue;
            }
            Vector vector2 = (Vector)hashtable2.get(string);
            Enumeration enumeration2 = vector2.elements();
            vector = (Vector)vector.clone();
            hashtable3.put(string, vector);
            while (enumeration2.hasMoreElements()) {
                vector.addElement(enumeration2.nextElement());
            }
        }
        return hashtable3;
    }

    public void appendToMailcap(String string) {
        if (debug && _logger.isDebugEnabled()) {
            String string2 = localStrings.getString("jaf.append_to_mailcap");
            _logger.debug((Object)(string2 + " " + string));
        }
        try {
            this.parse(new StringReader(string), this.type_hash);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Hashtable createMailcapHash(Reader reader) throws IOException {
        Hashtable hashtable = new Hashtable();
        this.parse(reader, hashtable);
        return hashtable;
    }

    private void parse(Reader reader, Hashtable hashtable) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string = null;
        String string2 = null;
        while ((string = bufferedReader.readLine()) != null) {
            string = string.trim();
            try {
                if (string.charAt(0) == '#') continue;
                if (string.charAt(string.length() - 1) == '\\') {
                    if (string2 != null) {
                        string2 = string2 + string.substring(0, string.length() - 1);
                        continue;
                    }
                    string2 = string.substring(0, string.length() - 1);
                    continue;
                }
                if (string2 != null) {
                    string2 = string2 + string;
                    try {
                        MailcapFile.parseLine(string2, hashtable);
                    }
                    catch (MailcapParseException mailcapParseException) {
                        // empty catch block
                    }
                    string2 = null;
                    continue;
                }
                try {
                    MailcapFile.parseLine(string, hashtable);
                }
                catch (MailcapParseException mailcapParseException) {
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        }
    }

    protected static void parseLine(String string, Hashtable hashtable) throws MailcapParseException, IOException {
        Hashtable<String, Vector<String>> hashtable2;
        MailcapTokenizer mailcapTokenizer = new MailcapTokenizer(string);
        mailcapTokenizer.setIsAutoquoting(false);
        String string2 = "";
        String string3 = "*";
        String string4 = "";
        if (debug && _logger.isDebugEnabled()) {
            String string5 = localStrings.getString("jaf.parse");
            _logger.debug((Object)(string5 + " " + string));
        }
        int n = mailcapTokenizer.nextToken();
        string4 = string4.concat(mailcapTokenizer.getCurrentTokenValue());
        if (n != 2) {
            MailcapFile.reportParseError(2, n, mailcapTokenizer.getCurrentTokenValue());
        }
        string2 = mailcapTokenizer.getCurrentTokenValue().toLowerCase();
        n = mailcapTokenizer.nextToken();
        string4 = string4.concat(mailcapTokenizer.getCurrentTokenValue());
        if (n != 47 && n != 59) {
            MailcapFile.reportParseError(47, 59, n, mailcapTokenizer.getCurrentTokenValue());
        }
        if (n == 47) {
            n = mailcapTokenizer.nextToken();
            string4 = string4.concat(mailcapTokenizer.getCurrentTokenValue());
            if (n != 2) {
                MailcapFile.reportParseError(2, n, mailcapTokenizer.getCurrentTokenValue());
            }
            string3 = mailcapTokenizer.getCurrentTokenValue().toLowerCase();
            n = mailcapTokenizer.nextToken();
            string4 = string4.concat(mailcapTokenizer.getCurrentTokenValue());
        }
        if (debug && _logger.isDebugEnabled()) {
            hashtable2 = localStrings.getString("jaf.type");
            _logger.debug((Object)((String)((Object)hashtable2) + " " + string2 + "/" + string3));
        }
        if ((hashtable2 = (Hashtable)hashtable.get(string2 + "/" + string3)) == null) {
            hashtable2 = new Hashtable<String, Vector<String>>();
            hashtable.put(string2 + "/" + string3, hashtable2);
        }
        if (n != 59) {
            MailcapFile.reportParseError(59, n, mailcapTokenizer.getCurrentTokenValue());
        }
        mailcapTokenizer.setIsAutoquoting(true);
        n = mailcapTokenizer.nextToken();
        mailcapTokenizer.setIsAutoquoting(false);
        string4 = string4.concat(mailcapTokenizer.getCurrentTokenValue());
        if (n != 2 && n != 59) {
            MailcapFile.reportParseError(2, 59, n, mailcapTokenizer.getCurrentTokenValue());
        }
        if (n != 59) {
            n = mailcapTokenizer.nextToken();
        }
        if (n == 59) {
            do {
                if ((n = mailcapTokenizer.nextToken()) != 2) {
                    MailcapFile.reportParseError(2, n, mailcapTokenizer.getCurrentTokenValue());
                }
                String string6 = mailcapTokenizer.getCurrentTokenValue().toLowerCase();
                n = mailcapTokenizer.nextToken();
                if (n != 61 && n != 59 && n != 5) {
                    MailcapFile.reportParseError(61, 59, 5, n, mailcapTokenizer.getCurrentTokenValue());
                }
                if (n != 61) continue;
                mailcapTokenizer.setIsAutoquoting(true);
                n = mailcapTokenizer.nextToken();
                mailcapTokenizer.setIsAutoquoting(false);
                if (n != 2) {
                    MailcapFile.reportParseError(2, n, mailcapTokenizer.getCurrentTokenValue());
                }
                String string7 = mailcapTokenizer.getCurrentTokenValue();
                if (string6.startsWith("x-java-")) {
                    Vector<String> vector;
                    String string8 = string6.substring(7);
                    if (debug && _logger.isDebugEnabled()) {
                        _logger.debug((Object)("Command: " + string8 + ", Class: " + string7));
                    }
                    if ((vector = (Vector<String>)hashtable2.get(string8)) == null) {
                        vector = new Vector<String>();
                        hashtable2.put(string8, vector);
                    }
                    vector.insertElementAt(string7, 0);
                }
                n = mailcapTokenizer.nextToken();
            } while (n == 59);
        } else if (n != 5) {
            MailcapFile.reportParseError(5, 59, n, mailcapTokenizer.getCurrentTokenValue());
        }
    }

    protected static void reportParseError(int n, int n2, String string) throws MailcapParseException {
        throw new MailcapParseException("Encountered a " + MailcapTokenizer.nameForToken(n2) + " token (" + string + ") while expecting a " + MailcapTokenizer.nameForToken(n) + " token.");
    }

    protected static void reportParseError(int n, int n2, int n3, String string) throws MailcapParseException {
        throw new MailcapParseException("Encountered a " + MailcapTokenizer.nameForToken(n3) + " token (" + string + ") while expecting a " + MailcapTokenizer.nameForToken(n) + " or a " + MailcapTokenizer.nameForToken(n2) + " token.");
    }

    protected static void reportParseError(int n, int n2, int n3, int n4, String string) throws MailcapParseException {
        if (debug && _logger.isDebugEnabled()) {
            _logger.debug((Object)("PARSE ERROR: Encountered a " + MailcapTokenizer.nameForToken(n4) + " token (" + string + ") while expecting a " + MailcapTokenizer.nameForToken(n) + ", a " + MailcapTokenizer.nameForToken(n2) + ", or a " + MailcapTokenizer.nameForToken(n3) + " token."));
        }
        throw new MailcapParseException("Encountered a " + MailcapTokenizer.nameForToken(n4) + " token (" + string + ") while expecting a " + MailcapTokenizer.nameForToken(n) + ", a " + MailcapTokenizer.nameForToken(n2) + ", or a " + MailcapTokenizer.nameForToken(n3) + " token.");
    }

    static {
        try {
            debug = Boolean.getBoolean("javax.activation.debug");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

