/*
 * Decompiled with CFR 0.152.
 */
package com.sun.activation.util.i18n;

import java.text.MessageFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StringManager {
    private static Log _logger = LogFactory.getLog((String)"javax.enterprise.resource.javamail");
    private ResourceBundle _resourceBundle = null;
    private static final String RES_BUNDLE_NM = ".LocalStrings";
    private static final String NO_DEFAULT = "No local string defined";
    private static Hashtable managers = new Hashtable();

    private StringManager(String string) {
        try {
            String string2 = string + RES_BUNDLE_NM;
            this._resourceBundle = ResourceBundle.getBundle(string2);
        }
        catch (Exception exception) {
            _logger.error((Object)"UTIL6550: Error in local string manager - resource bundle is probably missing.", (Throwable)exception);
        }
    }

    public static synchronized StringManager getManager(String string) {
        StringManager stringManager = (StringManager)managers.get(string);
        if (stringManager == null) {
            stringManager = new StringManager(string);
            try {
                managers.put(string, stringManager);
            }
            catch (Exception exception) {
                _logger.error((Object)"UTIL6551: Error while caching the local string manager - package name may be null.", (Throwable)exception);
            }
        }
        return stringManager;
    }

    public static synchronized StringManager getManager(Class clazz) {
        try {
            int n = clazz.getName().lastIndexOf(".");
            if (n != -1) {
                String string = clazz.getName().substring(0, n);
                return StringManager.getManager(string);
            }
            String string = clazz.getName();
            return StringManager.getManager(string);
        }
        catch (Exception exception) {
            _logger.error((Object)"UTIL6552: Error while constructing the local string manager object.", (Throwable)exception);
            return StringManager.getManager("");
        }
    }

    public String getString(String string) {
        return this.getStringWithDefault(string, NO_DEFAULT);
    }

    public String getStringWithDefault(String string, String string2) {
        String string3 = null;
        try {
            string3 = this._resourceBundle.getString(string);
        }
        catch (Exception exception) {
            _logger.debug((Object)("No local string for: " + string), (Throwable)exception);
        }
        if (string3 != null) {
            return string3;
        }
        return string2;
    }

    public String getStringWithDefault(String string, String string2, Object[] objectArray) {
        MessageFormat messageFormat = new MessageFormat(this.getStringWithDefault(string, string2));
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) {
                objectArray[i] = "null";
                continue;
            }
            if (objectArray[i] instanceof String || objectArray[i] instanceof Number || objectArray[i] instanceof Date) continue;
            objectArray[i] = objectArray[i].toString();
        }
        String string3 = null;
        try {
            string3 = messageFormat.format(objectArray);
        }
        catch (Exception exception) {
            _logger.warn((Object)"UTIL6553: Error while formating the local string.", (Throwable)exception);
            string3 = string2;
        }
        return string3;
    }

    public String getString(String string, Object object) {
        return this.getStringWithDefault(string, NO_DEFAULT, new Object[]{object});
    }

    public String getString(String string, Object object, Object object2) {
        return this.getStringWithDefault(string, NO_DEFAULT, new Object[]{object, object2});
    }

    public String getString(String string, Object object, Object object2, Object object3) {
        return this.getStringWithDefault(string, NO_DEFAULT, new Object[]{object, object2, object3});
    }

    public String getString(String string, Object object, Object object2, Object object3, Object object4) {
        return this.getStringWithDefault(string, NO_DEFAULT, new Object[]{object, object2, object3, object4});
    }
}

