/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.dom;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NamespaceNode
implements Node {
    public static final short NAMESPACE_NODE = 13;
    private Node parent;
    private String name;
    private String value;

    public NamespaceNode(Node parent, String name, String value) {
        this.parent = parent;
        this.name = name;
        this.value = value;
    }

    NamespaceNode(Node parent, Node attribute) {
        String name = attribute.getNodeName();
        this.name = name.equals("xmlns") ? "" : name.substring(6);
        this.parent = parent;
        this.value = attribute.getNodeValue();
    }

    public Node appendChild(Node newChild) throws DOMException {
        this.no_mods();
        return null;
    }

    public Node cloneNode(boolean deep) {
        return new NamespaceNode(this.parent, this.name, this.value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof NamespaceNode) {
            NamespaceNode ns = (NamespaceNode)o;
            return this.equals(this.parent, ns.getParentNode()) && this.equals(this.name, ns.getNodeName()) && this.equals(this.value, ns.getNodeValue());
        }
        return false;
    }

    private boolean equals(Object a, Object b) {
        return a == null && b == null || a != null && a.equals(b);
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public NodeList getChildNodes() {
        return new EmptyNodeList();
    }

    public Node getFirstChild() {
        return null;
    }

    public Node getLastChild() {
        return null;
    }

    public String getLocalName() {
        return this.name;
    }

    public String getNamespaceURI() {
        return null;
    }

    public Node getNextSibling() {
        return null;
    }

    public String getNodeName() {
        return this.name;
    }

    public short getNodeType() {
        return 13;
    }

    public String getNodeValue() {
        return this.value;
    }

    public Document getOwnerDocument() {
        return this.parent == null ? null : this.parent.getOwnerDocument();
    }

    public Node getParentNode() {
        return this.parent;
    }

    public String getPrefix() {
        return null;
    }

    public Node getPreviousSibling() {
        return null;
    }

    public boolean hasAttributes() {
        return false;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public int hashCode() {
        return this.hashCode(this.parent) + this.hashCode(this.name) + this.hashCode(this.value);
    }

    private int hashCode(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        this.no_mods();
        return null;
    }

    public boolean isSupported(String feature, String version) {
        return false;
    }

    private void no_mods() throws DOMException {
        throw new DOMException(7, "Namespace node may not be modified");
    }

    public void normalize() {
    }

    public Node removeChild(Node oldChild) throws DOMException {
        this.no_mods();
        return null;
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        this.no_mods();
        return null;
    }

    public void setNodeValue(String value) throws DOMException {
        this.no_mods();
    }

    public void setPrefix(String prefix) throws DOMException {
        this.no_mods();
    }

    class EmptyNodeList
    implements NodeList {
        EmptyNodeList() {
        }

        public int getLength() {
            return 0;
        }

        public Node item(int index) {
            return null;
        }
    }
}

