/*
 * Decompiled with CFR 0.152.
 */
package javax.ejb.deployment;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.Identity;
import javax.ejb.deployment.SerializableMethod;

public class AccessControlEntry
implements Serializable {
    private transient Method method = null;
    private Identity[] allowedIdentities = null;
    private SerializableMethod serializableMethod = null;

    public AccessControlEntry() {
    }

    public AccessControlEntry(Method method) {
        this.method = method;
    }

    public AccessControlEntry(Method method, Identity[] identities) {
        this.method = method;
        this.allowedIdentities = identities;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method value) {
        this.method = value;
    }

    public Identity[] getAllowedIdentities() {
        return this.allowedIdentities;
    }

    public void setAllowedIdentities(Identity[] values) {
        this.allowedIdentities = values;
    }

    public Identity getAllowedIdentities(int index) {
        return this.allowedIdentities[index];
    }

    public void setAllowedIdentities(int index, Identity value) {
        if (this.allowedIdentities == null || index >= this.allowedIdentities.length) {
            Identity[] newAllowedIdentities = new Identity[index + 1];
            if (this.allowedIdentities != null) {
                int i = 0;
                while (i < this.allowedIdentities.length) {
                    newAllowedIdentities[i] = this.allowedIdentities[i];
                    ++i;
                }
            }
            this.allowedIdentities = newAllowedIdentities;
        }
        this.allowedIdentities[index] = value;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.serializableMethod = new SerializableMethod(this.method);
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, NoSuchMethodException {
        in.defaultReadObject();
        this.method = this.serializableMethod.getMethod();
    }
}

