/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2ee.blueprints.smarticket.ejb.ticketsales;

import java.io.Serializable;

public class SeatingPlan
implements Serializable {
    public static final byte AISLE = 9;
    public static final byte AVAILABLE = 0;
    public static final byte UNAVAILABLE = 1;
    public static final byte BOOKED = 2;
    protected byte[] seats;
    protected int rows;
    protected int rowLength;

    public SeatingPlan() {
    }

    public SeatingPlan(int n, int n2) {
        this.rows = n;
        this.rowLength = n2;
        this.seats = new byte[this.rows * this.rowLength];
    }

    public SeatingPlan(byte[] byArray, int n, int n2) {
        if (n * n2 != byArray.length) {
            throw new IllegalArgumentException("rows * seats != length");
        }
        this.rows = n;
        this.rowLength = n2;
        this.seats = byArray;
    }

    public SeatingPlan(SeatingPlan seatingPlan) {
        this.rows = seatingPlan.rows;
        this.rowLength = seatingPlan.rowLength;
        this.seats = new byte[seatingPlan.seats.length];
        System.arraycopy(seatingPlan.seats, 0, this.seats, 0, seatingPlan.seats.length);
    }

    public int getRowCount() {
        return this.rows;
    }

    public int getRowLength() {
        return this.rowLength;
    }

    public byte[] getSeatData() {
        return this.seats;
    }

    public boolean isAisle(int n, int n2) {
        return this.getStatusOf(n, n2) == 9;
    }

    public boolean isAvailable(int n, int n2) {
        return this.getStatusOf(n, n2) == 0;
    }

    public boolean isBooked(int n, int n2) {
        return this.getStatusOf(n, n2) == 2;
    }

    public boolean isUnavailable(int n, int n2) {
        return this.getStatusOf(n, n2) == 1;
    }

    public byte getStatusOf(int n, int n2) {
        if (n2 > this.rowLength) {
            throw new IllegalArgumentException("Seat > rowLength");
        }
        return this.seats[this.seatIndex(n, n2)];
    }

    public void setStatusOf(int n, int n2, byte by) {
        if (n > this.rows || n2 > this.rowLength) {
            throw new IllegalArgumentException("row or seat too large");
        }
        this.seats[this.seatIndex((int)n, (int)n2)] = by;
    }

    private int seatIndex(int n, int n2) {
        if (n > this.rows || n2 > this.rowLength) {
            throw new IllegalArgumentException("row or seat too large");
        }
        return n * this.rowLength + n2;
    }

    public void setAvailable(int n, int n2) {
        this.seats[this.seatIndex((int)n, (int)n2)] = 0;
    }

    public void setBooked(int n, int n2) {
        this.seats[this.seatIndex((int)n, (int)n2)] = 2;
    }

    public void setUnavailable(int n, int n2) {
        this.seats[this.seatIndex((int)n, (int)n2)] = 1;
    }

    public boolean hasBooking(int n) {
        int n2;
        int n3 = n2 + this.rowLength;
        for (n2 = n * this.rowLength; n2 < n3; ++n2) {
            if (this.seats[n2] != 2) continue;
            return true;
        }
        return false;
    }

    public void setRow(int n, String string) {
        for (int i = 0; i < string.length(); ++i) {
            this.setStatusOf(n, i, Byte.parseByte(new Character(string.charAt(i)).toString()));
        }
    }

    public String getRow(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.getRowLength(); ++i) {
            stringBuffer.append(String.valueOf(new Byte(this.getStatusOf(n, i)).intValue()).charAt(0));
        }
        return stringBuffer.toString();
    }
}

