/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.ee.web.sessmgmt;

public class WebModuleStatistics {
    long _valveSaveLow = 0L;
    long _valveSaveHigh = 0L;
    long _valveSaveAverage = 0L;
    long _totalValveSaves = 0L;
    long _totalValveSaveTime = 0L;
    long _backgroundSaveLow = 0L;
    long _backgroundSaveHigh = 0L;
    long _backgroundSaveAverage = 0L;
    long _totalBackgroundSaves = 0L;
    long _totalBackgroundSaveTime = 0L;
    long _pipelineLow = 0L;
    long _pipelineHigh = 0L;
    long _pipelineAverage = 0L;
    long _totalPipelines = 0L;
    long _totalPipelineTime = 0L;
    long _sessionSizeLow = 0L;
    long _sessionSizeHigh = 0L;
    long _sessionSizeAverage = 0L;
    long _totalStoredSessions = 0L;
    long _totalSessionSize = 0L;
    long _cacheHits = 0L;
    long _cacheMisses = 0L;
    long _executeStatementLow = 0L;
    long _executeStatementHigh = 0L;
    long _executeStatementAverage = 0L;
    long _totalExecuteStatements = 0L;
    long _totalExecuteStatementTime = 0L;
    long _getConnectionLow = 0L;
    long _getConnectionHigh = 0L;
    long _getConnectionAverage = 0L;
    long _totalGetConnections = 0L;
    long _totalGetConnectionTime = 0L;
    long _statementPrepLow = 0L;
    long _statementPrepHigh = 0L;
    long _statementPrepAverage = 0L;
    long _totalStatementPreps = 0L;
    long _totalStatementPrepTime = 0L;

    synchronized void resetStats() {
        this.resetValveSaveStats();
        this.resetBackgroundSaveStats();
        this.resetPipelineStats();
        this.resetSessionSizeStats();
        this.resetCacheStats();
        this.resetExecuteStatementStats();
        this.resetGetConnectionStats();
        this.resetStatementPrepStats();
    }

    synchronized void processValveSave(long elapsedTime) {
        ++this._totalValveSaves;
        this._totalValveSaveTime += elapsedTime;
        this._valveSaveAverage = this._totalValveSaveTime / this._totalValveSaves;
        if (this._valveSaveLow == 0L | elapsedTime < this._valveSaveLow) {
            this._valveSaveLow = elapsedTime;
        }
        if (elapsedTime > this._valveSaveHigh) {
            this._valveSaveHigh = elapsedTime;
        }
    }

    void resetValveSaveStats() {
        this._totalValveSaves = 0L;
        this._totalValveSaveTime = 0L;
        this._valveSaveAverage = 0L;
        this._valveSaveLow = 0L;
        this._valveSaveHigh = 0L;
    }

    long getValveSaveLow() {
        return this._valveSaveLow;
    }

    long getValveSaveHigh() {
        return this._valveSaveHigh;
    }

    long getValveSaveAverage() {
        return this._valveSaveAverage;
    }

    synchronized void processBackgroundSave(long elapsedTime) {
        ++this._totalBackgroundSaves;
        this._totalBackgroundSaveTime += elapsedTime;
        this._backgroundSaveAverage = this._totalBackgroundSaveTime / this._totalBackgroundSaves;
        if (this._backgroundSaveLow == 0L | elapsedTime < this._backgroundSaveLow) {
            this._backgroundSaveLow = elapsedTime;
        }
        if (elapsedTime > this._backgroundSaveHigh) {
            this._backgroundSaveHigh = elapsedTime;
        }
    }

    void resetBackgroundSaveStats() {
        this._totalBackgroundSaves = 0L;
        this._totalBackgroundSaveTime = 0L;
        this._backgroundSaveAverage = 0L;
        this._backgroundSaveLow = 0L;
        this._backgroundSaveHigh = 0L;
    }

    long getBackgroundSaveLow() {
        return this._backgroundSaveLow;
    }

    long getBackgroundSaveHigh() {
        return this._backgroundSaveHigh;
    }

    long getBackgroundSaveAverage() {
        return this._backgroundSaveAverage;
    }

    public synchronized void processPipeline(long elapsedTime) {
        ++this._totalPipelines;
        this._totalPipelineTime += elapsedTime;
        this._pipelineAverage = this._totalPipelineTime / this._totalPipelines;
        if (this._pipelineLow == 0L | elapsedTime < this._pipelineLow) {
            this._pipelineLow = elapsedTime;
        }
        if (elapsedTime > this._pipelineHigh) {
            this._pipelineHigh = elapsedTime;
        }
    }

    void resetPipelineStats() {
        this._totalPipelines = 0L;
        this._totalPipelineTime = 0L;
        this._pipelineAverage = 0L;
        this._pipelineLow = 0L;
        this._pipelineHigh = 0L;
    }

    long getPipelineLow() {
        return this._pipelineLow;
    }

    long getPipelineHigh() {
        return this._pipelineHigh;
    }

    long getPipelineAverage() {
        return this._pipelineAverage;
    }

    synchronized void processSessionSize(long sessionSize) {
        ++this._totalStoredSessions;
        this._totalSessionSize += sessionSize;
        this._sessionSizeAverage = this._totalSessionSize / this._totalStoredSessions;
        if (this._sessionSizeLow == 0L | sessionSize < this._sessionSizeLow) {
            this._sessionSizeLow = sessionSize;
        }
        if (sessionSize > this._sessionSizeHigh) {
            this._sessionSizeHigh = sessionSize;
        }
    }

    void resetSessionSizeStats() {
        this._totalStoredSessions = 0L;
        this._totalSessionSize = 0L;
        this._sessionSizeAverage = 0L;
        this._sessionSizeLow = 0L;
        this._sessionSizeHigh = 0L;
    }

    long getSessionSizeLow() {
        return this._sessionSizeLow;
    }

    long getSessionSizeHigh() {
        return this._sessionSizeHigh;
    }

    long getSessionSizeAverage() {
        return this._sessionSizeAverage;
    }

    public synchronized void processCacheHit(boolean cacheWasHit) {
        if (cacheWasHit) {
            ++this._cacheHits;
        }
    }

    void resetCacheStats() {
        this._cacheHits = 0L;
        this._cacheMisses = 0L;
    }

    long getCacheHits() {
        return this._cacheHits;
    }

    long getCacheMisses() {
        return this._cacheMisses;
    }

    synchronized void processExecuteStatement(long elapsedTime) {
        ++this._totalExecuteStatements;
        this._totalExecuteStatementTime += elapsedTime;
        this._executeStatementAverage = this._totalExecuteStatementTime / this._totalExecuteStatements;
        if (this._executeStatementLow == 0L | elapsedTime < this._executeStatementLow) {
            this._executeStatementLow = elapsedTime;
        }
        if (elapsedTime > this._executeStatementHigh) {
            this._executeStatementHigh = elapsedTime;
        }
    }

    void resetExecuteStatementStats() {
        this._totalExecuteStatements = 0L;
        this._totalExecuteStatementTime = 0L;
        this._executeStatementLow = 0L;
        this._executeStatementHigh = 0L;
        this._executeStatementAverage = 0L;
    }

    long getExecuteStatementLow() {
        return this._executeStatementLow;
    }

    long getExecuteStatementHigh() {
        return this._executeStatementHigh;
    }

    long getExecuteStatementAverage() {
        return this._executeStatementAverage;
    }

    synchronized void processGetConnectionFromPool(long elapsedTime) {
        ++this._totalGetConnections;
        this._totalGetConnectionTime += elapsedTime;
        this._getConnectionAverage = this._totalGetConnectionTime / this._totalGetConnections;
        if (this._getConnectionLow == 0L | elapsedTime < this._getConnectionLow) {
            this._getConnectionLow = elapsedTime;
        }
        if (elapsedTime > this._getConnectionHigh) {
            this._getConnectionHigh = elapsedTime;
        }
    }

    void resetGetConnectionStats() {
        this._totalGetConnections = 0L;
        this._totalGetConnectionTime = 0L;
        this._getConnectionLow = 0L;
        this._getConnectionHigh = 0L;
        this._getConnectionAverage = 0L;
    }

    long getGetConnectionLow() {
        return this._getConnectionLow;
    }

    long getGetConnectionHigh() {
        return this._getConnectionHigh;
    }

    long getGetConnectionAverage() {
        return this._getConnectionAverage;
    }

    synchronized void processStatementPrepBlock(long elapsedTime) {
        ++this._totalStatementPreps;
        this._totalStatementPrepTime += elapsedTime;
        this._statementPrepAverage = this._totalStatementPrepTime / this._totalStatementPreps;
        if (this._statementPrepLow == 0L | elapsedTime < this._statementPrepLow) {
            this._statementPrepLow = elapsedTime;
        }
        if (elapsedTime > this._statementPrepHigh) {
            this._statementPrepHigh = elapsedTime;
        }
    }

    void resetStatementPrepStats() {
        this._totalStatementPreps = 0L;
        this._totalStatementPrepTime = 0L;
        this._statementPrepLow = 0L;
        this._statementPrepHigh = 0L;
        this._statementPrepAverage = 0L;
    }

    long getStatementPrepLow() {
        return this._statementPrepLow;
    }

    long getStatementPrepHigh() {
        return this._statementPrepHigh;
    }

    long getStatementPrepAverage() {
        return this._statementPrepAverage;
    }
}

