/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.ee.web.sessmgmt;

import com.sun.appserv.ee.util.concurrent.BoundedLinkedQueue;
import com.sun.appserv.ee.web.sessmgmt.HAFullSessionStoreFactory;
import com.sun.appserv.ee.web.sessmgmt.StoreFactory;
import com.sun.appserv.ee.web.sessmgmt.StorePoolElement;
import com.sun.logging.LogDomains;
import java.util.logging.Logger;

public class StorePool {
    public static final int DEFAULT_INITIAL_SIZE = 100;
    public static final int DEFAULT_UPPER_SIZE = -1;
    public static final int DEFAULT_POLL_TIME = 100;
    private static Logger _logger = null;
    private BoundedLinkedQueue _pool = null;
    private int _upperSize = -1;
    private int _currentUpperPermits = 0;
    private int _pollTime = 100;
    private StoreFactory _storeFactory = new HAFullSessionStoreFactory();

    public StorePool() {
        int poolSize = 100;
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
        }
        this.initializePool(poolSize);
    }

    public StorePool(int poolSize) {
        int thePoolSize = 100;
        if (poolSize > 1) {
            thePoolSize = poolSize;
        }
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
        }
        this.initializePool(thePoolSize);
    }

    public StorePool(int poolSize, int upperSize) {
        this(poolSize);
        this._upperSize = upperSize;
    }

    public StorePool(int poolSize, int upperSize, int pollTime) {
        this(poolSize, upperSize);
        this._pollTime = pollTime;
    }

    public StorePool(int poolSize, int upperSize, int pollTime, StoreFactory storeFactory) {
        int thePoolSize = 100;
        this._storeFactory = storeFactory;
        this._pollTime = pollTime;
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
        }
        if (poolSize > 1) {
            thePoolSize = poolSize;
        }
        this._upperSize = upperSize;
        this.initializePool(thePoolSize);
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
        }
    }

    private void initializePool(int poolSize) {
        this._pool = new BoundedLinkedQueue(poolSize);
        for (int i = 0; i < poolSize; ++i) {
            StorePoolElement nextStore = this._storeFactory.createHAStore();
            try {
                _logger.finest("initializePool-int  " + nextStore.getClass());
                this._pool.put(nextStore);
                continue;
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StorePoolElement take() throws InterruptedException {
        StorePoolElement haStore = null;
        _logger.finest("IN TAKE -- POLL_TIME=" + this._pollTime);
        haStore = (StorePoolElement)this._pool.poll(this._pollTime);
        if (haStore != null) {
            _logger.finest("IN TAKE -- GOT FROM MAIN POOL" + haStore.getClass());
            return haStore;
        }
        StorePool storePool = this;
        synchronized (storePool) {
            if (this._currentUpperPermits < this._upperSize | this._upperSize < 0) {
                _logger.finest("IN TAKE -- GOT FROM UPPER POOL");
                haStore = this._storeFactory.createHAStore();
                _logger.finest("haStore CLASS " + haStore.getClass() + "   " + this._storeFactory.getClass());
                ++this._currentUpperPermits;
            }
        }
        return haStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(StorePoolElement haStore) throws InterruptedException {
        StorePool storePool = this;
        synchronized (storePool) {
            if (this._currentUpperPermits > 0) {
                haStore.cleanup();
                --this._currentUpperPermits;
                _logger.finest("IN PUT -- PUTTING BACK INTO UPPER POOL");
                return;
            }
        }
        _logger.finest("IN PUT -- PUTTING BACK INTO LOWER POOL");
        this._pool.put(haStore);
    }
}

