/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.ee.web.sessmgmt;

import com.iplanet.ias.web.ServerConfigLookup;
import com.sun.appserv.ee.web.authenticator.HASingleSignOn;
import com.sun.appserv.ee.web.initialization.ServerConfigReader;
import com.sun.appserv.ee.web.sessmgmt.ConnectionUtil;
import com.sun.appserv.ee.web.sessmgmt.HADBConnectionGroup;
import com.sun.appserv.ee.web.sessmgmt.HAErrorManager;
import com.sun.appserv.ee.web.sessmgmt.HAManagerBase;
import com.sun.appserv.ee.web.sessmgmt.HASession;
import com.sun.appserv.ee.web.sessmgmt.HAStorePoolElement;
import com.sun.appserv.ee.web.sessmgmt.HATimeoutException;
import com.sun.appserv.ee.web.sessmgmt.IntHolder;
import com.sun.appserv.ee.web.sessmgmt.WebModuleStatistics;
import com.sun.appserv.util.cache.BaseCache;
import com.sun.ejb.EJBUtils;
import com.sun.hadb.jdbc.LOBDescr;
import com.sun.hadb.jdbc.LobConnection;
import com.sun.logging.LogDomains;
import com.sun.web.security.RealmAdapter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.authenticator.SingleSignOnEntry;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.session.StoreBase;

public class HAStore
extends StoreBase
implements HAStorePoolElement {
    private static int _maxBaseCacheSize = 4096;
    protected static float _loadFactor = 0.75f;
    protected BaseCache sessions = new BaseCache();
    protected String pkexErrorCode = "HADB-E-11939";
    private static Logger _logger = null;
    protected int _debug = 0;
    protected Level _logLevel = null;
    protected String blobSessionTable = "blobsessions";
    protected String driverName = "com.sun.hadb.jdbc.Driver";
    protected String timeoutSecs = new Long(300L).toString();
    protected Connection conn = null;
    private LOBDescr lob = new LOBDescr();
    private LOBDescr updateLob = new LOBDescr();
    protected HAErrorManager haErr = null;
    protected ConnectionUtil connectionUtil = null;
    private PreparedStatement preparedKeysSql = null;
    private PreparedStatement preparedExpiredKeysSql = null;
    private PreparedStatement preparedSizeSql = null;
    private PreparedStatement preparedDualSql = null;
    private PreparedStatement preparedLoadSql = null;
    private PreparedStatement preparedInsertSql = null;
    private PreparedStatement preparedRemoveSql = null;
    private PreparedStatement preparedClearSql = null;
    private PreparedStatement preparedUpdateSql = null;
    private PreparedStatement preparedExistsSql = null;
    private PreparedStatement preparedUpdateNoSessionSql = null;
    protected String clusterId = null;
    protected String applicationId = null;
    protected String shortApplicationId = null;
    long timeout = new Long(this.timeoutSecs);

    public BaseCache getSessions() {
        return this.sessions;
    }

    public void setSessions(BaseCache sesstable) {
        this.sessions = sesstable;
    }

    protected void setLogLevel() {
        Level level;
        this._logLevel = level = _logger.getLevel();
        this._debug = level.equals(Level.FINE) ? 1 : (level.equals(Level.FINER) ? 2 : (level.equals(Level.FINEST) ? 5 : 0));
    }

    protected static boolean checkSessionCacheProperties() {
        boolean result = false;
        try {
            String loadFactor;
            Properties props = System.getProperties();
            String cacheSize = props.getProperty("HTTP_SESSION_CACHE_MAX_BASE_CACHE_SIZE");
            if (null != cacheSize) {
                _maxBaseCacheSize = new Integer(cacheSize);
            }
            if (null != (loadFactor = props.getProperty("HTTP_SESSION_CACHE_MAX_BASE_LOAD_FACTOR"))) {
                _loadFactor = new Float(loadFactor).floatValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected String getClusterIdFromConfig() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        return lookup.getClusterIdFromConfig();
    }

    protected String getClusterId() {
        if (this.clusterId == null) {
            this.clusterId = this.getClusterIdFromConfig();
        }
        return this.clusterId;
    }

    protected ConnectionUtil getConnectionUtil() {
        if (this.connectionUtil == null) {
            this.connectionUtil = new ConnectionUtil(this.getManager().getContainer(), this.getManager());
        }
        return this.connectionUtil;
    }

    public String getApplicationId() {
        if (this.applicationId != null) {
            return this.applicationId;
        }
        StringBuffer sb = new StringBuffer(50);
        sb.append(this.getClusterId());
        ArrayList<String> list = new ArrayList<String>();
        for (Container container = this.manager.getContainer(); container != null; container = container.getParent()) {
            if (container.getName() == null) continue;
            list.add(":" + container.getName());
        }
        for (int i = list.size() - 1; i > -1; --i) {
            String nextString = (String)list.get(i);
            sb.append(nextString);
        }
        this.applicationId = sb.toString();
        return this.applicationId;
    }

    public String getShortApplicationId() {
        if (this.shortApplicationId != null) {
            return this.shortApplicationId;
        }
        Container container = this.manager.getContainer();
        StringBuffer sb = new StringBuffer(50);
        sb.append(this.getClusterId());
        sb.append(":");
        if (container != null && container.getName() != null) {
            sb.append(container.getName());
        }
        container = container.getParent();
        this.shortApplicationId = sb.toString();
        return this.shortApplicationId;
    }

    public String extractShortApplicationIdFromApplicationId(String appid) {
        StringTokenizer st = new StringTokenizer(appid, ":");
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken();
            list.add(nextToken);
        }
        StringBuffer sb = new StringBuffer();
        if (list.size() > 2) {
            sb.append(list.get(0));
            sb.append(":");
            sb.append(list.get(2));
        }
        return sb.toString();
    }

    public void setTimeoutSecs(String timeoutSecs) {
        this.debug("in setTimeoutSecs");
        String oldTimeoutSecs = this.timeoutSecs;
        this.timeoutSecs = timeoutSecs;
        this.support.firePropertyChange("timeoutSecs", oldTimeoutSecs, this.timeoutSecs);
    }

    public String getTimeoutSecs() {
        this.debug("in getTimeoutSecs");
        return this.timeoutSecs;
    }

    protected void debug(String message) {
        this.log(message);
    }

    public HAStore() {
        info = "S1AS7.0EE HAStore/1.0";
        this.threadName = "HAStore";
        storeName = "HAStore";
        this.lob.setTableName(this.blobSessionTable);
        this.lob.addKey("id", 1);
        this.lob.setLOBColumn("sessdata", 2);
        this.updateLob.setTableName(this.blobSessionTable);
        this.updateLob.addKey("id", 8);
        this.updateLob.setLOBColumn("sessdata", 1);
        this.haErr = new HAErrorManager(this.timeout, this.threadName);
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
        }
        this.setLogLevel();
        if (this.sessions == null) {
            this.sessions = new BaseCache();
        }
        this.sessions.init(_maxBaseCacheSize, _loadFactor, null);
    }

    public int getSize() throws IOException {
        return this.getSize(this.blobSessionTable);
    }

    public int getSize(String sessionTable) throws IOException {
        int size = 0;
        String sizeSql = "SELECT COUNT(id) FROM " + sessionTable + " WHERE appid = '" + this.getApplicationId() + "'";
        Connection conn = this.getConnection(false);
        ResultSet rst = null;
        HAErrorManager haErr = new HAErrorManager(this.timeout, this.threadName);
        try {
            haErr.txStart();
            while (!haErr.isTxCompleted()) {
                try {
                    if (this.preparedSizeSql == null) {
                        this.preparedSizeSql = conn.prepareStatement(sizeSql);
                    }
                    if ((rst = this.preparedSizeSql.executeQuery()).next()) {
                        size = rst.getInt(1);
                    }
                    conn.commit();
                    haErr.txEnd();
                }
                catch (SQLException e) {
                    haErr.checkError(e, conn);
                    if (this._debug <= 0) continue;
                    this.debug("Got a retryable exception from HA Store: " + e.getMessage());
                }
            }
        }
        catch (SQLException e) {
            try {
                conn.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            IOException ex1 = (IOException)new IOException("Error from HA Store: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException e) {
            IOException ex1 = (IOException)new IOException("Timeout from HA Store").initCause(e);
            throw ex1;
        }
        finally {
            this.closeResultSet(rst);
        }
        return size;
    }

    public String[] keys() throws IOException {
        return this.keys(this.blobSessionTable);
    }

    protected void processExpires() {
        long timeNow = System.currentTimeMillis();
        String[] keys = null;
        try {
            keys = this.expiredKeys();
        }
        catch (IOException e) {
            this.log(e.toString());
            e.printStackTrace();
            return;
        }
        for (int i = 0; i < keys.length; ++i) {
            try {
                this.remove(keys[i]);
                continue;
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] keys(String sessionTable) throws IOException {
        String[] result = new String[]{};
        String keysSql = "SELECT id FROM " + sessionTable + " WHERE appid = '" + this.getApplicationId() + "'";
        try {
            Connection conn = this.getConnectionValidated(false);
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (this.conn == null) {
            return result;
        }
        ResultSet rst = null;
        String[] keys = null;
        HAErrorManager haErr = new HAErrorManager(this.timeout, this.threadName);
        try {
            haErr.txStart();
            while (!haErr.isTxCompleted()) {
                try {
                    if (this.preparedKeysSql == null) {
                        this.preparedKeysSql = this.conn.prepareStatement(keysSql);
                    }
                    if ((rst = this.preparedKeysSql.executeQuery()) == null) {
                        if (this._debug > 0) {
                            this.debug("keys(): No rows returned, returning an empty array");
                        }
                        String[] stringArray = new String[]{};
                        this.closeResultSet(rst);
                        return stringArray;
                    }
                    ArrayList<String> keysArray = new ArrayList<String>();
                    int i = 0;
                    while (rst.next()) {
                        if (this._debug > 0) {
                            this.debug("in keys, id is " + rst.getString(1));
                        }
                        keysArray.add(rst.getString(1));
                        ++i;
                    }
                    keys = keysArray.toArray(new String[0]);
                    this.conn.commit();
                    haErr.txEnd();
                }
                catch (SQLException e) {
                    haErr.checkError(e, this.conn);
                    if (this._debug <= 0) continue;
                    this.debug("Got a retryable exception from HA Store: " + e.getMessage());
                }
            }
            this.closeResultSet(rst);
            return keys;
        }
        catch (SQLException e) {
            try {
                try {
                    this.conn.rollback();
                }
                catch (SQLException ee) {
                    // empty catch block
                }
                IOException ex1 = (IOException)new IOException("Error from HA Store: " + e.getMessage()).initCause(e);
                throw ex1;
                catch (HATimeoutException e2) {
                    ex1 = (IOException)new IOException("Timeout from HA Store").initCause(e2);
                    throw ex1;
                }
            }
            catch (Throwable throwable) {
                this.closeResultSet(rst);
                throw throwable;
            }
        }
    }

    public String[] expiredKeys() throws IOException {
        return this.expiredKeys(this.blobSessionTable);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] expiredKeys(String sessionTable) throws IOException {
        String[] result = new String[]{};
        long timeNow = System.currentTimeMillis();
        Manager mgr = this.getManager();
        long maxInactiveIntervalMillis = mgr.getMaxInactiveInterval() * 1000;
        long relevantTime = timeNow - maxInactiveIntervalMillis;
        String expiredKeysSql = "SELECT id FROM " + sessionTable + " WHERE appid = '" + this.getApplicationId() + "'" + " AND (lastaccess < ? OR valid = '0')";
        try {
            Connection conn = this.getConnectionValidated(false);
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (this.conn == null) {
            return result;
        }
        ResultSet rst = null;
        String[] keys = null;
        HAErrorManager haErr = new HAErrorManager(this.timeout, this.threadName);
        try {
            haErr.txStart();
            while (!haErr.isTxCompleted()) {
                try {
                    if (this.preparedExpiredKeysSql == null) {
                        this.preparedExpiredKeysSql = this.conn.prepareStatement(expiredKeysSql);
                    }
                    this.preparedExpiredKeysSql.setLong(1, relevantTime);
                    rst = this.preparedExpiredKeysSql.executeQuery();
                    if (rst == null) {
                        if (this._debug > 0) {
                            this.debug("expiredKeys(): No rows returned, returning an empty array");
                        }
                        String[] stringArray = new String[]{};
                        this.closeResultSet(rst);
                        return stringArray;
                    }
                    ArrayList<String> keysArray = new ArrayList<String>();
                    int i = 0;
                    while (rst.next()) {
                        if (this._debug > 0) {
                            this.debug("in expiredKeys, id is " + rst.getString(1));
                        }
                        keysArray.add(rst.getString(1));
                        ++i;
                    }
                    keys = keysArray.toArray(new String[0]);
                    this.conn.commit();
                    haErr.txEnd();
                }
                catch (SQLException e) {
                    haErr.checkError(e, this.conn);
                    if (this._debug <= 0) continue;
                    this.debug("Got a retryable exception from HA Store: " + e.getMessage());
                }
            }
            this.closeResultSet(rst);
            return keys;
        }
        catch (SQLException e) {
            try {
                try {
                    this.conn.rollback();
                }
                catch (SQLException ee) {
                    // empty catch block
                }
                IOException ex1 = (IOException)new IOException("Error from HA Store: " + e.getMessage()).initCause(e);
                throw ex1;
                catch (HATimeoutException e2) {
                    ex1 = (IOException)new IOException("Timeout from HA Store").initCause(e2);
                    throw ex1;
                }
            }
            catch (Throwable throwable) {
                this.closeResultSet(rst);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Session load(String id) throws ClassNotFoundException, IOException {
        block45: {
            block48: {
                block49: {
                    block41: {
                        block44: {
                            block39: {
                                block47: {
                                    block40: {
                                        HAStore._logger.finest("IN NEW LOAD METHOD");
                                        if (id == null) {
                                            if (this._debug > 0) {
                                                this.debug("in load, id is null, returning null");
                                            }
                                            Thread.dumpStack();
                                            return null;
                                        }
                                        session = (Session)this.sessions.get((Object)id);
                                        if (session != null) {
                                            if (this._debug <= 0) return session;
                                            this.debug("Session " + id + " loaded from cache");
                                            return session;
                                        }
                                        rst = null;
                                        connGroup = null;
                                        try {
                                            connGroup = this.getConnectionsFromPool();
                                        }
                                        catch (IOException ex) {
                                            // empty catch block
                                        }
                                        if (connGroup == null) {
                                            if (this._debug > 0) {
                                                this.debug("HAStore>>load: Failure to obtain connection from pool: returning null");
                                            }
                                            config = new ServerConfigLookup();
                                            connURL = config.getConnectionURLFromConfig();
                                            HAStore._logger.warning("ConnectionUtil>>getConnectionsFromPool failed using connection URL: " + connURL + " -- returning null. Check connection pool configuration.");
                                            return null;
                                        }
                                        internalConn = connGroup._internalConn;
                                        externalConn = connGroup._externalConn;
                                        conn = (LobConnection)internalConn;
                                        shortAppId = null;
                                        loadSql = "SELECT id, sessdata, username , ssoid, appid FROM " + this.blobSessionTable + " WHERE id = ?";
                                        haErr = new HAErrorManager(this.timeout, this.threadName);
                                        try {
                                            try {
                                                block46: {
                                                    haErr.txStart();
lbl35:
                                                    // 4 sources

                                                    while (!haErr.isTxCompleted()) {
                                                        try {
                                                            this.preparedLoadSql = conn.prepareLobStatement(loadSql, this.lob);
                                                            this.preparedLoadSql.setString(1, id);
                                                            rst = this.preparedLoadSql.executeQuery();
                                                            if (rst == null || !rst.next()) {
                                                                if (this._debug > 0) {
                                                                    this.debug("No persisted data found for session " + id);
                                                                }
                                                                var11_14 = null;
                                                            }
                                                            ** GOTO lbl-1000
                                                        }
                                                        catch (SQLException e) {
                                                            haErr.checkError(e, (Connection)conn);
                                                            if (this._debug <= 0) continue;
                                                            this.debug("Got a retryable exception from HA Store: " + e.getMessage());
                                                        }
                                                        var14_19 = null;
                                                        this.closeResultSet(rst);
                                                        if (this.preparedLoadSql == null) break block39;
                                                        break block40;
                                                    }
                                                    break block46;
lbl56:
                                                    // 1 sources

                                                    return var11_14;
lbl-1000:
                                                    // 1 sources

                                                    {
                                                        session = this.getSession(rst);
                                                        appId = rst.getString(5);
                                                        shortAppId = this.extractShortApplicationIdFromApplicationId(appId);
                                                        ((Connection)conn).commit();
                                                        haErr.txEnd();
                                                    }
                                                    ** GOTO lbl35
                                                }
                                                this.preparedLoadSql.close();
                                                this.preparedLoadSql = null;
                                                try {
                                                    externalConn.close();
                                                }
                                                catch (SQLException ex) {
                                                    // empty catch block
                                                }
                                                externalConn = null;
                                                break block41;
                                            }
                                            catch (SQLException e) {
                                                try {
                                                    ((Connection)conn).rollback();
                                                }
                                                catch (SQLException ee) {
                                                    // empty catch block
                                                }
                                                e.printStackTrace();
                                                ex1 = (IOException)new IOException("Error from HA Store: " + e.getMessage()).initCause(e);
                                                throw ex1;
                                            }
                                            catch (HATimeoutException e) {
                                                ex1 = (IOException)new IOException("Timeout from HA Store").initCause(e);
                                                throw ex1;
                                            }
                                        }
                                        catch (Throwable var13_28) {
                                            var14_21 = null;
                                            this.closeResultSet(rst);
                                            if (this.preparedLoadSql != null) {
                                                try {
                                                    this.preparedLoadSql.close();
                                                }
                                                catch (SQLException e) {
                                                    // empty catch block
                                                }
                                                this.preparedLoadSql = null;
                                            }
                                            if (externalConn != null) {
                                                try {
                                                    externalConn.close();
                                                }
                                                catch (Exception ex) {
                                                    // empty catch block
                                                }
                                            }
                                            if ((stdSess = (StandardSession)session) == null || !stdSess.isForegroundLocked()) throw var13_28;
                                            HAStore._logger.finest("inHAStore>>load before unlockForeground:lock = " + stdSess.getSessionLock());
                                            stdSess.unlockForeground();
                                            HAStore._logger.finest("inHAStore>>load after unlockForeground:lock = " + stdSess.getSessionLock());
                                            throw var13_28;
                                        }
                                    }
                                    ** try [egrp 7[TRYBLOCK] [12 : 577->589)] { 
lbl112:
                                    // 1 sources

                                    this.preparedLoadSql.close();
                                    break block47;
lbl114:
                                    // 1 sources

                                    catch (SQLException e) {
                                        // empty catch block
                                    }
                                }
                                this.preparedLoadSql = null;
                            }
                            if (externalConn != null) {
                                ** try [egrp 8[TRYBLOCK] [13 : 601->611)] { 
lbl121:
                                // 1 sources

                                externalConn.close();
                                break block44;
lbl123:
                                // 1 sources

                                catch (Exception ex) {
                                    // empty catch block
                                }
                            }
                        }
                        if ((stdSess = (StandardSession)session) == null || !stdSess.isForegroundLocked()) ** GOTO lbl56
                        HAStore._logger.finest("inHAStore>>load before unlockForeground:lock = " + stdSess.getSessionLock());
                        stdSess.unlockForeground();
                        HAStore._logger.finest("inHAStore>>load after unlockForeground:lock = " + stdSess.getSessionLock());
                        return var11_14;
                    }
                    var14_20 = null;
                    this.closeResultSet(rst);
                    if (this.preparedLoadSql == null) break block48;
                    ** try [egrp 7[TRYBLOCK] [12 : 577->589)] { 
lbl136:
                    // 1 sources

                    this.preparedLoadSql.close();
                    break block49;
lbl138:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                }
                this.preparedLoadSql = null;
            }
            if (externalConn != null) {
                ** try [egrp 8[TRYBLOCK] [13 : 601->611)] { 
lbl145:
                // 1 sources

                externalConn.close();
                break block45;
lbl147:
                // 1 sources

                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        if ((stdSess = (StandardSession)session) != null && stdSess.isForegroundLocked()) {
            HAStore._logger.finest("inHAStore>>load before unlockForeground:lock = " + stdSess.getSessionLock());
            stdSess.unlockForeground();
            HAStore._logger.finest("inHAStore>>load after unlockForeground:lock = " + stdSess.getSessionLock());
        }
        if (!shortAppId.equals(this.getShortApplicationId())) {
            ((HAManagerBase)this.manager).removeSessionFromManagerCache(session);
            return null;
        }
        this.sessions.put((Object)session.getId(), (Object)session);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Session getSession(ResultSet rst) throws SQLException, IOException, ClassNotFoundException {
        String ssoId;
        Principal pal;
        Session _session;
        block14: {
            _session = null;
            BufferedInputStream bis = null;
            Loader loader = null;
            ClassLoader classLoader = null;
            ObjectInputStream ois = null;
            Container container = this.manager.getContainer();
            pal = null;
            ssoId = null;
            try {
                String id = rst.getString(1);
                Blob blob = rst.getBlob(2);
                String username = rst.getString(3);
                ssoId = rst.getString(4);
                if (username != null && !username.equals("")) {
                    if (this._debug > 0) {
                        this.debug("Username retrived from DB is " + username);
                    }
                    pal = ((RealmAdapter)container.getRealm()).createFailOveredPrincipal(username);
                    if (this._debug > 0) {
                        this.debug("principal created using username  " + pal);
                    }
                }
                bis = new BufferedInputStream(blob.getBinaryStream());
                _logger.finest("loaded seasion from hastore, length = " + blob.length());
                if (container != null) {
                    loader = container.getLoader();
                }
                if (loader != null) {
                    classLoader = loader.getClassLoader();
                }
                if ((ois = EJBUtils.getInputStream((InputStream)bis, (ClassLoader)classLoader, (boolean)true, (boolean)false)) == null) break block14;
                try {
                    _session = this.readSession(this.manager, ois);
                    Object var14_15 = null;
                    if (ois == null) break block14;
                }
                catch (Throwable throwable) {
                    Object var14_16 = null;
                    if (ois == null) throw throwable;
                    try {
                        ois.close();
                        bis = null;
                        throw throwable;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException e) {}
                ois.close();
                bis = null;
            }
            catch (ClassNotFoundException e) {
                System.err.println("getSession :" + e.getMessage());
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
        }
        _session.setPrincipal(pal);
        if (ssoId != null && !ssoId.equals("")) {
            this.associate(ssoId, _session);
        }
        if (this._debug <= 0) return _session;
        this.debug("getSession principal=" + pal + " was added to session=" + _session);
        return _session;
    }

    protected void associate(String ssoId, Session _session) {
        if (this._debug > 0) {
            this.debug("Inside associate() -- HAStore");
        }
        Container parent = this.manager.getContainer();
        SingleSignOn sso = null;
        while (sso == null && parent != null) {
            if (this._debug > 0) {
                this.debug("Inside associate()  while loop -- HAStore");
            }
            if (!(parent instanceof Pipeline)) {
                if (this._debug > 0) {
                    this.debug("Inside associate()  parent instanceof Pipeline -- HAStore");
                }
                parent = parent.getParent();
                continue;
            }
            Valve[] valves = ((Pipeline)parent).getValves();
            for (int i = 0; i < valves.length; ++i) {
                if (!(valves[i] instanceof SingleSignOn)) continue;
                if (this._debug > 0) {
                    this.debug("Inside associate()  valves[i] instanceof SingleSignOn -- HAStore");
                }
                sso = (SingleSignOn)valves[i];
                break;
            }
            if (sso != null) continue;
            parent = parent.getParent();
        }
        if (sso != null) {
            if (this._debug > 0) {
                this.debug("Inside associate() sso != null");
            }
            SingleSignOnEntry ssoEntry = ((HASingleSignOn)sso).lookup(ssoId);
            _logger.finest("Inside associate() ssoEntry = " + ssoEntry);
            if (ssoEntry != null) {
                ssoEntry.addSession(sso, _session);
            }
        }
    }

    /*
     * Loose catch block
     */
    public synchronized void remove(String id) throws IOException {
        block31: {
            LobConnection conn;
            Connection externalConn;
            block29: {
                if (this._debug > 0) {
                    this.debug("in remove");
                }
                if (id == null) {
                    if (this._debug > 0) {
                        this.debug("In remove, got a null id");
                    }
                    return;
                }
                HADBConnectionGroup connGroup = null;
                try {
                    connGroup = this.getConnectionsFromPool();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                if (connGroup == null) {
                    if (this._debug > 0) {
                        this.debug("HAStore>>remove: Failure to obtain connection from pool");
                    }
                    ServerConfigLookup config = new ServerConfigLookup();
                    String connURL = config.getConnectionURLFromConfig();
                    _logger.warning("ConnectionUtil>>getConnectionsFromPool failed using connection URL: " + connURL + " -- returning null. Check connection pool configuration.");
                    return;
                }
                Connection internalConn = connGroup._internalConn;
                externalConn = connGroup._externalConn;
                conn = (LobConnection)internalConn;
                this.sessions.remove((Object)id);
                String removeSql = "DELETE FROM " + this.blobSessionTable + " WHERE id = ?";
                HAErrorManager haErr = new HAErrorManager(this.timeout, this.threadName);
                haErr.txStart();
                while (!haErr.isTxCompleted()) {
                    try {
                        this.preparedRemoveSql = conn.prepareLobStatement(removeSql, this.lob);
                        this.preparedRemoveSql.setString(1, id);
                        this.preparedRemoveSql.executeUpdate();
                        ((Connection)conn).commit();
                        haErr.txEnd();
                    }
                    catch (SQLException e) {
                        haErr.checkError(e, (Connection)conn);
                        if (this._debug <= 0) continue;
                        this.debug("Got a retryable exception from HA Store: " + e.getMessage());
                    }
                }
                this.preparedRemoveSql.close();
                this.preparedRemoveSql = null;
                try {
                    externalConn.close();
                }
                catch (SQLException ex) {
                    // empty catch block
                }
                externalConn = null;
                Object var11_15 = null;
                if (this.preparedRemoveSql == null) break block29;
                try {
                    this.preparedRemoveSql.close();
                }
                catch (SQLException e) {
                    // empty catch block
                }
                this.preparedRemoveSql = null;
            }
            if (externalConn != null) {
                try {
                    externalConn.close();
                }
                catch (Exception ex) {}
            }
            break block31;
            {
                catch (SQLException e) {
                    try {
                        ((Connection)conn).rollback();
                    }
                    catch (SQLException ee) {
                        // empty catch block
                    }
                    IOException ex1 = (IOException)new IOException("Error from HA Store: " + e.getMessage()).initCause(e);
                    throw ex1;
                }
                catch (HATimeoutException e) {
                    IOException ex1 = (IOException)new IOException("Timeout from HA Store").initCause(e);
                    throw ex1;
                }
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                if (this.preparedRemoveSql != null) {
                    try {
                        this.preparedRemoveSql.close();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                    this.preparedRemoveSql = null;
                }
                if (externalConn != null) {
                    try {
                        externalConn.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        if (this._debug > 0) {
            this.debug("Removed session " + id + " from HA Store");
        }
    }

    public void clear() throws IOException {
        if (this._debug > 0) {
            this.debug("in clear");
        }
        this.sessions = new BaseCache();
        this.sessions.init(_maxBaseCacheSize, _loadFactor, null);
        String[] keys = this.keys();
        for (int i = 0; i < keys.length; ++i) {
            this.remove(keys[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Session session) throws IOException {
        _logger.finest("XXXXXXX In save, id is " + session.getId());
        boolean isMonitoringEnabled = ServerConfigReader.isMonitoringEnabled();
        long startTime = 0L;
        HAManagerBase mgr = (HAManagerBase)this.getManager();
        WebModuleStatistics stats = mgr.getWebModuleStatistics();
        if (isMonitoringEnabled) {
            startTime = System.currentTimeMillis();
        }
        HASession sess = (HASession)session;
        boolean previousDirtyFlag = sess.isDirty();
        if (this._debug > 0) {
            this.debug("in save");
        }
        Connection conn = this.getConnection(false);
        IntHolder length = new IntHolder();
        BufferedInputStream in = this.getInputStream(session, length);
        boolean pkex = false;
        for (int i = 0; i < 2; ++i) {
            block17: {
                pkex = false;
                try {
                    if (this.sessionInStore(session)) {
                        _logger.finest("Session is in store");
                        if (sess.isDirty()) {
                            _logger.finest("Session IS Dirty");
                            this.updateSessionBlob(session, in, length.value);
                        } else {
                            _logger.finest("Session is NOT Dirty");
                            this.updateSessionNoDataBlob(session, in, length.value);
                        }
                    } else {
                        this.insertSessionBlob(session, in, length.value);
                    }
                    sess.setDirty(false);
                    if (isMonitoringEnabled) {
                        long endTime = System.currentTimeMillis();
                        stats.processBackgroundSave(endTime - startTime);
                    }
                    _logger.finest("session class= " + sess.getClass().getName());
                    _logger.finest("after save: session dirty= " + sess.isDirty());
                }
                catch (IOException e) {
                    sess.setDirty(previousDirtyFlag);
                    if (e.getMessage().indexOf(this.pkexErrorCode) != -1) {
                        pkex = true;
                        _logger.info("Primary Key Constraint violation while saving session " + session.getId());
                        break block17;
                    }
                    e.printStackTrace();
                    throw e;
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            if (!pkex) break;
        }
        if (pkex) {
            return;
        }
        if (this._debug > 0) {
            this.debug("Saved session " + session.getId() + " into HA Store");
        }
        this.sessions.put((Object)session.getId(), (Object)session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void valveSave(Session session) throws IOException {
        _logger.finest("XXXXXXX In valveSave, id is " + session.getId());
        boolean isMonitoringEnabled = ServerConfigReader.isMonitoringEnabled();
        HASession sess = (HASession)session;
        boolean previousDirtyFlag = sess.isDirty();
        if (this._debug > 0) {
            this.debug("in valveSave");
        }
        HAManagerBase mgr = (HAManagerBase)this.getManager();
        WebModuleStatistics stats = mgr.getWebModuleStatistics();
        long getConnStartTime = 0L;
        if (isMonitoringEnabled) {
            getConnStartTime = System.currentTimeMillis();
        }
        HADBConnectionGroup connGroup = null;
        try {
            connGroup = this.getConnectionsFromPool();
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (isMonitoringEnabled) {
            long getConnEndTime = System.currentTimeMillis();
            stats.processGetConnectionFromPool(getConnEndTime - getConnStartTime);
        }
        if (connGroup == null) {
            return;
        }
        Connection internalConn = connGroup._internalConn;
        Connection conn = connGroup._externalConn;
        IntHolder length = new IntHolder();
        BufferedInputStream in = this.getInputStream(session, length);
        boolean pkex = false;
        for (int i = 0; i < 2; ++i) {
            block29: {
                Exception ex3222;
                Object var18_20;
                block27: {
                    pkex = false;
                    if (this.sessionInStore(session, internalConn)) {
                        if (sess.isDirty()) {
                            this.updateSessionNewBlob(session, in, length.value, internalConn);
                        } else {
                            this.updateSessionNoDataNewBlob(session, in, length.value, internalConn);
                        }
                    } else {
                        this.insertSessionNewBlob(session, in, length.value, internalConn);
                    }
                    sess.setDirty(false);
                    try {
                        conn.close();
                    }
                    catch (SQLException ex2) {
                        // empty catch block
                    }
                    conn = null;
                    var18_20 = null;
                    if (conn == null) break block27;
                    try {
                        conn.close();
                    }
                    catch (Exception ex3222) {
                        // empty catch block
                    }
                }
                if (in != null) {
                    in.close();
                }
                break block29;
                {
                    catch (IOException e) {
                        sess.setDirty(previousDirtyFlag);
                        if (e.getMessage().indexOf(this.pkexErrorCode) == -1) {
                            e.printStackTrace();
                            throw e;
                        }
                        pkex = true;
                        _logger.info("Primary Key Constraint violation while saving session " + session.getId());
                        var18_20 = null;
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (Exception ex3222) {
                                // empty catch block
                            }
                        }
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                catch (Throwable throwable) {
                    var18_20 = null;
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Exception ex3222) {
                            // empty catch block
                        }
                    }
                    if (in != null) {
                        in.close();
                    }
                    throw throwable;
                }
            }
            if (!pkex) break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void insertSessionNewBlob(Session session, BufferedInputStream in, int buflength, Connection connection) throws IOException {
        _logger.finest("IN insertSessionNewBlob");
        String insertSql = "INSERT INTO " + this.blobSessionTable + " (" + "id, sessdata, valid, maxinactive, lastaccess, appid, username, ssoid) " + "VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        LobConnection lobConn = (LobConnection)connection;
        HAErrorManager haErr = new HAErrorManager(this.timeout, this.threadName);
        try {
            try {
                haErr.txStart();
                while (!haErr.isTxCompleted()) {
                    try {
                        this.preparedInsertSql = lobConn.prepareLobStatement(insertSql, this.lob);
                        this.preparedInsertSql.setString(1, session.getId());
                        this.preparedInsertSql.setBinaryStream(2, (InputStream)in, buflength);
                        this.preparedInsertSql.setString(3, session.isValid() ? "1" : "0");
                        this.preparedInsertSql.setInt(4, session.getMaxInactiveInterval());
                        this.preparedInsertSql.setLong(5, session.getLastAccessedTime());
                        this.preparedInsertSql.setString(6, this.getApplicationId());
                        if (session.getPrincipal() != null) {
                            if (this._debug > 0) {
                                this.debug(" session.getPrincipal().getName() =" + session.getPrincipal().getName());
                            }
                            this.preparedInsertSql.setString(7, session.getPrincipal().getName());
                        } else {
                            this.preparedInsertSql.setString(7, "");
                            if (this._debug > 0) {
                                this.debug(" session.getPrincipal() =" + session.getPrincipal());
                            }
                        }
                        String ssoId = ((HASession)session).getSsoId();
                        if (ssoId == null) {
                            ssoId = "";
                        }
                        this.preparedInsertSql.setString(8, ssoId);
                        this.preparedInsertSql.executeUpdate();
                        ((Connection)lobConn).commit();
                        _logger.finest("inserted session, length = " + buflength);
                        haErr.txEnd();
                    }
                    catch (SQLException e) {
                        haErr.checkError(e, this.conn);
                        if (this._debug <= 0) continue;
                        this.debug("Got a retryable exception from HA Store: " + e.getMessage());
                    }
                }
                this.preparedInsertSql.close();
                this.preparedInsertSql = null;
            }
            catch (SQLException e) {
                try {
                    ((Connection)lobConn).rollback();
                }
                catch (SQLException ee) {
                    // empty catch block
                }
                IOException ex1 = (IOException)new IOException("Error from HA Store: " + e.getMessage()).initCause(e);
                throw ex1;
            }
            catch (HATimeoutException e) {
                IOException ex1 = (IOException)new IOException("Timeout from HA Store").initCause(e);
                throw ex1;
            }
            Object var11_12 = null;
            if (this.preparedInsertSql == null) return;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (this.preparedInsertSql == null) throw throwable;
            try {
                this.preparedInsertSql.close();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ex) {}
        this.preparedInsertSql.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateSessionNewBlob(Session session, BufferedInputStream in, int buflength, Connection connection) throws IOException {
        _logger.finest("IN updateSessionNewBlob");
        HAManagerBase mgr = (HAManagerBase)this.getManager();
        WebModuleStatistics stats = mgr.getWebModuleStatistics();
        boolean isMonitoringEnabled = ServerConfigReader.isMonitoringEnabled();
        String updateSql = "UPDATE " + this.blobSessionTable + " SET sessdata = ?, valid = ?, maxinactive = ?, lastaccess = ? , appid = ? , username = ?, ssoid=?" + "WHERE id = ?";
        LobConnection lobConn = (LobConnection)connection;
        long startPrepTime = 0L;
        HAErrorManager haErr = new HAErrorManager(this.timeout, this.threadName);
        try {
            try {
                if (isMonitoringEnabled) {
                    startPrepTime = System.currentTimeMillis();
                }
                haErr.txStart();
                while (!haErr.isTxCompleted()) {
                    try {
                        this.preparedUpdateSql = lobConn.prepareLobStatement(updateSql, this.updateLob);
                        this.preparedUpdateSql.setBinaryStream(1, (InputStream)in, buflength);
                        this.preparedUpdateSql.setString(2, session.isValid() ? "1" : "0");
                        this.preparedUpdateSql.setInt(3, session.getMaxInactiveInterval());
                        this.preparedUpdateSql.setLong(4, session.getLastAccessedTime());
                        this.preparedUpdateSql.setString(5, this.getApplicationId());
                        if (session.getPrincipal() != null) {
                            if (this._debug > 0) {
                                this.debug(" session.getPrincipal().getName() =" + session.getPrincipal().getName());
                            }
                            this.preparedUpdateSql.setString(6, session.getPrincipal().getName());
                        } else {
                            this.preparedUpdateSql.setString(6, "");
                            if (this._debug > 0) {
                                this.debug(" session.getPrincipal() =" + session.getPrincipal());
                            }
                        }
                        String ssoId = ((HASession)session).getSsoId();
                        if (ssoId == null) {
                            ssoId = "";
                        }
                        this.preparedUpdateSql.setString(7, ssoId);
                        this.preparedUpdateSql.setString(8, session.getId());
                        if (isMonitoringEnabled) {
                            long endPrepTime = System.currentTimeMillis();
                            stats.processStatementPrepBlock(endPrepTime - startPrepTime);
                        }
                        long startTime = 0L;
                        if (isMonitoringEnabled) {
                            startTime = System.currentTimeMillis();
                        }
                        this.preparedUpdateSql.executeUpdate();
                        if (isMonitoringEnabled) {
                            long endTime = System.currentTimeMillis();
                            stats.processExecuteStatement(endTime - startTime);
                        }
                        ((Connection)lobConn).commit();
                        _logger.finest("updated session, length = " + buflength);
                        haErr.txEnd();
                    }
                    catch (SQLException e) {
                        haErr.checkError(e, this.conn);
                        if (this._debug <= 0) continue;
                        this.debug("Got a retryable exception from HA Store: " + e.getMessage());
                    }
                }
                this.preparedUpdateSql.close();
                this.preparedUpdateSql = null;
            }
            catch (SQLException e) {
                try {
                    ((Connection)lobConn).rollback();
                }
                catch (SQLException ee) {
                    // empty catch block
                }
                IOException ex1 = (IOException)new IOException("Error from HA Store: " + e.getMessage()).initCause(e);
                throw ex1;
            }
            catch (HATimeoutException e) {
                IOException ex1 = (IOException)new IOException("Timeout from HA Store").initCause(e);
                throw ex1;
            }
            Object var19_21 = null;
            if (this.preparedUpdateSql == null) return;
        }
        catch (Throwable throwable) {
            Object var19_22 = null;
            if (this.preparedUpdateSql == null) throw throwable;
            try {
                this.preparedUpdateSql.close();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ex) {}
        this.preparedUpdateSql.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateSessionNoDataNewBlob(Session session, BufferedInputStream in, int buflength, Connection connection) throws IOException {
        String updateSql = "UPDATE " + this.blobSessionTable + " SET valid = ?, maxinactive = ?, lastaccess = ? , appid = ? ,username =?, ssoid=?" + "WHERE id = ?";
        HAErrorManager haErr = new HAErrorManager(this.timeout, this.threadName);
        try {
            try {
                haErr.txStart();
                while (!haErr.isTxCompleted()) {
                    try {
                        this.preparedUpdateNoSessionSql = connection.prepareStatement(updateSql);
                        this.preparedUpdateNoSessionSql.setString(1, session.isValid() ? "1" : "0");
                        this.preparedUpdateNoSessionSql.setInt(2, session.getMaxInactiveInterval());
                        this.preparedUpdateNoSessionSql.setLong(3, session.getLastAccessedTime());
                        this.preparedUpdateNoSessionSql.setString(4, this.getApplicationId());
                        if (session.getPrincipal() != null) {
                            if (this._debug > 0) {
                                this.debug(" session.getPrincipal().getName() =" + session.getPrincipal().getName());
                            }
                            this.preparedUpdateNoSessionSql.setString(5, session.getPrincipal().getName());
                        } else {
                            this.preparedUpdateNoSessionSql.setString(5, "");
                        }
                        String ssoId = ((HASession)session).getSsoId();
                        if (ssoId == null) {
                            ssoId = "";
                        }
                        this.preparedUpdateNoSessionSql.setString(6, ssoId);
                        this.preparedUpdateNoSessionSql.setString(7, session.getId());
                        this.preparedUpdateNoSessionSql.executeUpdate();
                        connection.commit();
                        haErr.txEnd();
                    }
                    catch (SQLException e) {
                        haErr.checkError(e, this.conn);
                        if (this._debug <= 0) continue;
                        this.debug("Got a retryable exception from HA Store: " + e.getMessage());
                    }
                }
                this.preparedUpdateNoSessionSql.close();
                this.preparedUpdateNoSessionSql = null;
            }
            catch (SQLException e) {
                try {
                    connection.rollback();
                }
                catch (Exception e1) {
                    // empty catch block
                }
                IOException ex1 = (IOException)new IOException("Error from HA Store: " + e.getMessage()).initCause(e);
                throw ex1;
            }
            catch (HATimeoutException e) {
                IOException ex1 = (IOException)new IOException("Timeout from HA Store").initCause(e);
                throw ex1;
            }
            Object var10_11 = null;
            if (this.preparedUpdateNoSessionSql == null) return;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (this.preparedUpdateNoSessionSql == null) throw throwable;
            try {
                this.preparedUpdateNoSessionSql.close();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ex) {}
        this.preparedUpdateNoSessionSql.close();
        return;
    }

    public boolean sessionInStore(Session session) throws IOException {
        return this.sessionInStore(session, this.blobSessionTable);
    }

    public boolean sessionInStore(Session session, String storeTable) throws IOException {
        Session sess = (Session)this.sessions.get((Object)session.getId());
        if (sess != null) {
            return true;
        }
        Connection conn = this.getConnection(false);
        String existsSql = "SELECT id FROM " + storeTable + " WHERE id = ?";
        ResultSet rs = null;
        boolean found = false;
        HAErrorManager haErr = new HAErrorManager(this.timeout, this.threadName);
        try {
            haErr.txStart();
            while (!haErr.isTxCompleted()) {
                try {
                    if (this.preparedExistsSql == null) {
                        this.preparedExistsSql = conn.prepareStatement(existsSql);
                    }
                    this.preparedExistsSql.setString(1, session.getId());
                    rs = this.preparedExistsSql.executeQuery();
                    found = rs != null && rs.next();
                    conn.commit();
                    haErr.txEnd();
                }
                catch (SQLException e) {
                    haErr.checkError(e, conn);
                    if (this._debug <= 0) continue;
                    this.debug("Got a retryable exception from HA Store: " + e.getMessage());
                }
            }
        }
        catch (SQLException e) {
            try {
                conn.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            IOException ex1 = (IOException)new IOException("Error from HA Store: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException e) {
            IOException ex1 = (IOException)new IOException("Timeout from HA Store").initCause(e);
            throw ex1;
        }
        finally {
            this.closeResultSet(rs);
        }
        return found;
    }

    public boolean sessionInStore(Session session, Connection conn) throws IOException {
        return this.sessionInStore(session, conn, this.blobSessionTable);
    }

    /*
     * Loose catch block
     */
    public boolean sessionInStore(Session session, Connection conn, String storeTable) throws IOException {
        boolean found;
        block15: {
            HAManagerBase mgr = (HAManagerBase)this.getManager();
            HAStore backgroundStore = (HAStore)mgr.getStore();
            BaseCache sesstbl = backgroundStore.getSessions();
            Session sess = (Session)sesstbl.get((Object)session.getId());
            if (sess != null) {
                return true;
            }
            String existsSql = "SELECT id FROM " + storeTable + " WHERE id = ?";
            ResultSet rs = null;
            found = false;
            HAErrorManager haErr = new HAErrorManager(this.timeout, this.threadName);
            haErr.txStart();
            while (!haErr.isTxCompleted()) {
                try {
                    this.preparedExistsSql = conn.prepareStatement(existsSql);
                    this.preparedExistsSql.setString(1, session.getId());
                    rs = this.preparedExistsSql.executeQuery();
                    found = rs != null && rs.next();
                    conn.commit();
                    haErr.txEnd();
                }
                catch (SQLException e) {
                    haErr.checkError(e, conn);
                    if (this._debug <= 0) continue;
                    this.debug("Got a retryable exception from HA Store: " + e.getMessage());
                }
            }
            this.preparedExistsSql.close();
            this.preparedExistsSql = null;
            Object var15_15 = null;
            this.closeResultSet(rs);
            if (this.preparedExistsSql == null) break block15;
            try {
                this.preparedExistsSql.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            this.preparedExistsSql = null;
            {
                break block15;
                catch (SQLException e) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException ee) {
                        // empty catch block
                    }
                    IOException ex1 = (IOException)new IOException("Error from HA Store: " + e.getMessage()).initCause(e);
                    throw ex1;
                }
                catch (HATimeoutException e) {
                    IOException ex1 = (IOException)new IOException("Timeout from HA Store").initCause(e);
                    throw ex1;
                }
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                this.closeResultSet(rs);
                if (this.preparedExistsSql != null) {
                    try {
                        this.preparedExistsSql.close();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                    this.preparedExistsSql = null;
                }
                throw throwable;
            }
        }
        return found;
    }

    private void insertSessionBlob(Session session, BufferedInputStream in, int buflength) throws IOException {
        String insertSql = "INSERT INTO " + this.blobSessionTable + " (" + "id, sessdata, valid, maxinactive, lastaccess, appid, username, ssoid) " + "VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        LobConnection lobConn = (LobConnection)this.conn;
        HAErrorManager haErr = new HAErrorManager(this.timeout, this.threadName);
        try {
            haErr.txStart();
            while (!haErr.isTxCompleted()) {
                try {
                    if (this.preparedInsertSql == null) {
                        this.preparedInsertSql = lobConn.prepareLobStatement(insertSql, this.lob);
                    }
                    this.preparedInsertSql.setString(1, session.getId());
                    this.preparedInsertSql.setBinaryStream(2, (InputStream)in, buflength);
                    this.preparedInsertSql.setString(3, session.isValid() ? "1" : "0");
                    this.preparedInsertSql.setInt(4, session.getMaxInactiveInterval());
                    this.preparedInsertSql.setLong(5, session.getLastAccessedTime());
                    this.preparedInsertSql.setString(6, this.getApplicationId());
                    if (session.getPrincipal() != null) {
                        if (this._debug > 0) {
                            this.debug(" session.getPrincipal().getName() =" + session.getPrincipal().getName());
                        }
                        this.preparedInsertSql.setString(7, session.getPrincipal().getName());
                    } else {
                        this.preparedInsertSql.setString(7, "");
                    }
                    String ssoId = ((HASession)session).getSsoId();
                    if (ssoId == null) {
                        ssoId = "";
                    }
                    this.preparedInsertSql.setString(8, ssoId);
                    this.preparedInsertSql.executeUpdate();
                    ((Connection)lobConn).commit();
                    haErr.txEnd();
                }
                catch (SQLException e) {
                    haErr.checkError(e, this.conn);
                    if (this._debug <= 0) continue;
                    this.debug("Got a retryable exception from HA Store: " + e.getMessage());
                }
            }
            _logger.finest("inserted session, length = " + buflength);
        }
        catch (SQLException e) {
            try {
                ((Connection)lobConn).rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            IOException ex1 = (IOException)new IOException("Error from HA Store: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException e) {
            IOException ex1 = (IOException)new IOException("Timeout from HA Store").initCause(e);
            throw ex1;
        }
    }

    private void updateSessionBlob(Session session, BufferedInputStream in, int buflength) throws IOException {
        String updateSql = "UPDATE " + this.blobSessionTable + " SET sessdata = ?, valid = ?, maxinactive = ?, lastaccess = ? , appid = ? , username=?, ssoid=?" + "WHERE id = ?";
        LobConnection lobConn = (LobConnection)this.conn;
        HAErrorManager haErr = new HAErrorManager(this.timeout, this.threadName);
        try {
            haErr.txStart();
            while (!haErr.isTxCompleted()) {
                try {
                    if (this.preparedUpdateSql == null) {
                        this.preparedUpdateSql = lobConn.prepareLobStatement(updateSql, this.updateLob);
                    }
                    this.preparedUpdateSql.setBinaryStream(1, (InputStream)in, buflength);
                    this.preparedUpdateSql.setString(2, session.isValid() ? "1" : "0");
                    this.preparedUpdateSql.setInt(3, session.getMaxInactiveInterval());
                    this.preparedUpdateSql.setLong(4, session.getLastAccessedTime());
                    this.preparedUpdateSql.setString(5, this.getApplicationId());
                    if (session.getPrincipal() != null) {
                        if (this._debug > 0) {
                            this.debug(" session.getPrincipal().getName() =" + session.getPrincipal().getName());
                        }
                        this.preparedUpdateSql.setString(6, session.getPrincipal().getName());
                    } else {
                        this.preparedUpdateSql.setString(6, "");
                    }
                    String ssoId = ((HASession)session).getSsoId();
                    if (ssoId == null) {
                        ssoId = "";
                    }
                    this.preparedUpdateSql.setString(7, ssoId);
                    this.preparedUpdateSql.setString(8, session.getId());
                    this.preparedUpdateSql.executeUpdate();
                    ((Connection)lobConn).commit();
                    _logger.finest("updated session, length = " + buflength);
                    haErr.txEnd();
                }
                catch (SQLException e) {
                    haErr.checkError(e, this.conn);
                    if (this._debug <= 0) continue;
                    this.debug("Got a retryable exception from HA Store: " + e.getMessage());
                }
            }
        }
        catch (SQLException e) {
            try {
                ((Connection)lobConn).rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            IOException ex1 = (IOException)new IOException("Error from HA Store: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException e) {
            IOException ex1 = (IOException)new IOException("Timeout from HA Store").initCause(e);
            throw ex1;
        }
    }

    private void updateSessionNoDataBlob(Session session, BufferedInputStream in, int buflength) throws IOException {
        _logger.finest("IN updateSessionNoDataBlob");
        String updateSql = "UPDATE " + this.blobSessionTable + " SET valid = ?, maxinactive = ?, lastaccess = ? , appid = ? ,username= ?, ssoid=?" + "WHERE id = ?";
        HAErrorManager haErr = new HAErrorManager(this.timeout, this.threadName);
        try {
            haErr.txStart();
            while (!haErr.isTxCompleted()) {
                try {
                    if (this.preparedUpdateNoSessionSql == null) {
                        this.preparedUpdateNoSessionSql = this.conn.prepareStatement(updateSql);
                    }
                    this.preparedUpdateNoSessionSql.setString(1, session.isValid() ? "1" : "0");
                    this.preparedUpdateNoSessionSql.setInt(2, session.getMaxInactiveInterval());
                    this.preparedUpdateNoSessionSql.setLong(3, session.getLastAccessedTime());
                    this.preparedUpdateNoSessionSql.setString(4, this.getApplicationId());
                    if (session.getPrincipal() != null) {
                        if (this._debug > 0) {
                            this.debug(" session.getPrincipal().getName() =" + session.getPrincipal().getName());
                        }
                        this.preparedUpdateNoSessionSql.setString(5, session.getPrincipal().getName());
                    } else {
                        this.preparedUpdateNoSessionSql.setString(5, "");
                    }
                    String ssoId = ((HASession)session).getSsoId();
                    if (ssoId == null) {
                        ssoId = "";
                    }
                    this.preparedUpdateNoSessionSql.setString(6, ssoId);
                    this.preparedUpdateNoSessionSql.setString(7, session.getId());
                    this.preparedUpdateNoSessionSql.executeUpdate();
                    this.conn.commit();
                    haErr.txEnd();
                }
                catch (SQLException e) {
                    haErr.checkError(e, this.conn);
                    if (this._debug <= 0) continue;
                    this.debug("Got a retryable exception from HA Store: " + e.getMessage());
                }
            }
        }
        catch (SQLException e) {
            try {
                this.conn.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            IOException ex1 = (IOException)new IOException("Error from HA Store: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException e) {
            IOException ex1 = (IOException)new IOException("Timeout from HA Store").initCause(e);
            throw ex1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedInputStream getInputStream(Session session, IntHolder length) throws IOException {
        BufferedInputStream in;
        ByteArrayInputStream bis;
        block6: {
            ByteArrayOutputStream bos = null;
            bis = null;
            ObjectOutputStream oos = null;
            in = null;
            try {
                bos = new ByteArrayOutputStream();
                oos = EJBUtils.getOutputStream((OutputStream)new BufferedOutputStream(bos), (boolean)true);
                this.writeSession(session, oos);
                oos.close();
                oos = null;
                byte[] obs = bos.toByteArray();
                boolean isMonitoringEnabled = ServerConfigReader.isMonitoringEnabled();
                if (isMonitoringEnabled) {
                    _logger.finest("IN HAStore>>getInputStream for monitoring");
                    HAManagerBase mgr = (HAManagerBase)this.getManager();
                    WebModuleStatistics stats = mgr.getWebModuleStatistics();
                    stats.processSessionSize(obs.length);
                }
                bis = new ByteArrayInputStream(obs, 0, obs.length);
                in = new BufferedInputStream(bis, obs.length);
                length.value = obs.length;
                Object var12_11 = null;
                if (oos == null) break block6;
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                if (oos != null) {
                    oos.close();
                }
                if (bis != null) {
                    bis.close();
                }
                throw throwable;
            }
            oos.close();
        }
        if (bis != null) {
            bis.close();
        }
        return in;
    }

    protected ResultSet executeStatement(PreparedStatement stmt, boolean isQuery) throws IOException {
        ResultSet rst = null;
        try {
            this.haErr.txStart();
            while (!this.haErr.isTxCompleted()) {
                try {
                    if (isQuery) {
                        rst = stmt.executeQuery();
                    } else {
                        stmt.executeUpdate();
                    }
                    this.haErr.txEnd();
                }
                catch (SQLException e) {
                    this.haErr.checkError(e, this.conn);
                    if (this._debug <= 0) continue;
                    this.debug("Got a retryable exception from HA Store: " + e.getMessage());
                }
            }
        }
        catch (SQLException e) {
            IOException ex1 = (IOException)new IOException("Error from HA Store: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException e) {
            IOException ex1 = (IOException)new IOException("Timeout from HA Store").initCause(e);
            throw ex1;
        }
        return rst;
    }

    protected void closeResultSet(ResultSet rst) {
        try {
            if (rst != null) {
                rst.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void cleanup() {
        this.closeStatements();
        this.closeConnection();
        this.setSessions(new BaseCache());
        this.sessions.init(_maxBaseCacheSize, _loadFactor, null);
    }

    protected void closeConnection() {
        try {
            if (this.conn != null && !this.conn.isClosed()) {
                this.conn.close();
                this.conn = null;
            }
        }
        catch (SQLException ex) {
            // empty catch block
        }
        this.conn = null;
        ConnectionUtil util = this.getConnectionUtil();
        if (util != null) {
            util.clearCachedConnection();
        }
    }

    protected void closeStatements() {
        PreparedStatement[] statements = new PreparedStatement[]{this.preparedKeysSql, this.preparedExpiredKeysSql, this.preparedSizeSql, this.preparedDualSql, this.preparedLoadSql, this.preparedInsertSql, this.preparedRemoveSql, this.preparedClearSql, this.preparedUpdateSql, this.preparedExistsSql, this.preparedUpdateNoSessionSql};
        for (int i = 0; i < statements.length; ++i) {
            PreparedStatement nextStatement = statements[i];
            this.closeStatement(nextStatement);
        }
        this.clearStatementReferences();
    }

    protected void clearStatementReferences() {
        this.preparedKeysSql = null;
        this.preparedExpiredKeysSql = null;
        this.preparedSizeSql = null;
        this.preparedDualSql = null;
        this.preparedLoadSql = null;
        this.preparedInsertSql = null;
        this.preparedRemoveSql = null;
        this.preparedClearSql = null;
        this.preparedUpdateSql = null;
        this.preparedExistsSql = null;
        this.preparedUpdateNoSessionSql = null;
    }

    protected void closeStatement(PreparedStatement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void privateForTestSetConnection(Connection connection) {
        this.conn = connection;
    }

    public Connection privateGetConnection(boolean autocommit) throws IOException {
        return this.getConnection(autocommit);
    }

    protected HADBConnectionGroup getConnectionsFromPool() throws IOException {
        ConnectionUtil util = this.getConnectionUtil();
        return util.getConnectionsFromPool();
    }

    protected Connection getConnectionValidated(boolean autoCommit) throws IOException {
        Connection connection = null;
        boolean keepTrying = true;
        int numRetries = 3;
        int count = 1;
        while (keepTrying) {
            connection = this.getConnection(autoCommit);
            boolean connectionValid = this.validateConnection(connection);
            if (connectionValid) {
                keepTrying = false;
            } else {
                try {
                    this.cleanupConnectionCaches();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.conn = null;
                this.threadSleep(100L);
            }
            if (++count != numRetries) continue;
            keepTrying = false;
        }
        if (this.conn == null) {
            throw new IOException("Could not obtain viable connection");
        }
        try {
            this.conn.setAutoCommit(autoCommit);
        }
        catch (SQLException ex) {
            // empty catch block
        }
        return this.conn;
    }

    protected void cleanupConnectionCaches() {
        this.closeConnection();
        this.clearStatementReferences();
        this.conn = null;
    }

    protected boolean validateConnection(Connection connection) {
        boolean result = true;
        try {
            this.testQueryForConnValidation(connection);
        }
        catch (IOException ex) {
            result = false;
        }
        catch (NullPointerException ex1) {
            result = false;
        }
        return result;
    }

    public int getSizeForConnValidation(Connection connection) throws IOException {
        if (this._debug > 0) {
            this.debug("in getSizeForConnValidation");
        }
        int size = 0;
        String sizeSql = "SELECT COUNT(id) FROM " + this.blobSessionTable + " WHERE appid = '" + this.getApplicationId() + "'";
        ResultSet rst = null;
        HAErrorManager haErr = new HAErrorManager(this.timeout, this.threadName);
        try {
            haErr.txStart();
            while (!haErr.isTxCompleted()) {
                try {
                    if (this.preparedSizeSql == null) {
                        this.preparedSizeSql = connection.prepareStatement(sizeSql);
                    }
                    if ((rst = this.preparedSizeSql.executeQuery()).next()) {
                        size = rst.getInt(1);
                    }
                    connection.commit();
                    haErr.txEnd();
                }
                catch (SQLException e) {
                    haErr.checkError(e, this.conn);
                    if (this._debug <= 0) continue;
                    this.debug("Got a retryable exception from HA Store: " + e.getMessage());
                }
            }
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            IOException ex1 = (IOException)new IOException("Error from HA Store: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException e) {
            IOException ex1 = (IOException)new IOException("Timeout from HA Store").initCause(e);
            throw ex1;
        }
        finally {
            this.closeResultSet(rst);
        }
        return size;
    }

    public int testQueryForConnValidationPrevious(Connection connection) throws IOException {
        if (this._debug > 0) {
            this.debug("in testQueryForConnValidation");
        }
        int size = 0;
        String testSql = "SELECT COUNT(*) FROM SYSROOT.DUAL";
        ResultSet rst = null;
        HAErrorManager haErr = new HAErrorManager(this.timeout, this.threadName);
        try {
            haErr.txStart();
            while (!haErr.isTxCompleted()) {
                try {
                    if (this.preparedDualSql == null) {
                        this.preparedDualSql = connection.prepareStatement(testSql);
                    }
                    if ((rst = this.preparedDualSql.executeQuery()).next()) {
                        size = rst.getInt(1);
                    }
                    connection.commit();
                    haErr.txEnd();
                }
                catch (SQLException e) {
                    haErr.checkError(e, this.conn);
                    if (this._debug <= 0) continue;
                    this.debug("Got a retryable exception from HA Store: " + e.getMessage());
                }
            }
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            IOException ex1 = (IOException)new IOException("Error from HA Store: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException e) {
            IOException ex1 = (IOException)new IOException("Timeout from HA Store").initCause(e);
            throw ex1;
        }
        finally {
            this.closeResultSet(rst);
        }
        return size;
    }

    public int testQueryForConnValidation(Connection connection) throws IOException {
        try {
            connection.getMetaData();
            return 1;
        }
        catch (SQLException ex) {
            IOException ex1 = (IOException)new IOException("Error from HA Store Connection Validation: " + ex.getMessage()).initCause(ex);
            throw ex1;
        }
    }

    protected void threadSleep(long sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected Connection getConnection() throws IOException {
        return this.getConnection(true);
    }

    protected Connection getConnection(boolean autoCommit) throws IOException {
        ConnectionUtil util = this.getConnectionUtil();
        this.conn = util.getConnection(autoCommit);
        return this.conn;
    }

    public void privateCloseCachedConnection() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        HAStore.checkSessionCacheProperties();
    }
}

