/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.ee.web.sessmgmt;

import com.iplanet.ias.web.ShutdownCleanupCapable;
import com.sun.appserv.ee.web.initialization.ServerConfigReader;
import com.sun.appserv.ee.web.sessmgmt.HAStore;
import com.sun.appserv.ee.web.sessmgmt.SessionFactory;
import com.sun.appserv.ee.web.sessmgmt.WebModuleStatistics;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.session.PersistentManagerBase;

public abstract class HAManagerBase
extends PersistentManagerBase
implements ShutdownCleanupCapable {
    protected SessionFactory _sessionFactory = null;
    protected WebModuleStatistics _statistics = new WebModuleStatistics();
    private Map _connectionsMap = Collections.synchronizedMap(new WeakHashMap(50));

    protected Session createNewSession() {
        Session sess = this.getSessionFactory().createSession((Manager)this);
        return sess;
    }

    protected void insureValidConnection() throws IOException {
        HAStore store = (HAStore)this.getStore();
        store.getConnectionValidated(false);
    }

    protected void processExpires() {
        try {
            this.insureValidConnection();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.processExpires();
    }

    public void processPersistenceChecks() {
        try {
            this.insureValidConnection();
        }
        catch (IOException ex) {
            // empty catch block
        }
        this.processMaxIdleSwaps();
        try {
            this.insureValidConnection();
        }
        catch (IOException ex) {
            // empty catch block
        }
        this.processMaxActiveSwaps();
        try {
            this.insureValidConnection();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.processMaxIdleBackups();
    }

    public Session findSession(String id) throws IOException {
        WebModuleStatistics stats = this.getWebModuleStatistics();
        Session session = this.findSessionFromCacheOnly(id);
        if (session != null) {
            if (this.isMonitoringEnabled()) {
                stats.processCacheHit(true);
            }
            return session;
        }
        if (this.isMonitoringEnabled()) {
            stats.processCacheHit(false);
        }
        session = this.swapIn(id);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session findSessionFromCacheOnly(String id) throws IOException {
        if (id == null) {
            return null;
        }
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            Session session = (Session)this.sessions.get(id);
            return session;
        }
    }

    protected boolean isMonitoringEnabled() {
        return ServerConfigReader.isMonitoringEnabled();
    }

    public String getMonitorAttributeValues() {
        return "testing..1..2..3";
    }

    public int doShutdownCleanup() {
        return this.closeAllConnections();
    }

    public int closeAllConnections() {
        int count = 0;
        int iterations = 0;
        Set connections = this._connectionsMap.keySet();
        Iterator it = connections.iterator();
        while (it.hasNext()) {
            ++iterations;
            Connection nextConn = (Connection)it.next();
            if (nextConn == null) continue;
            try {
                nextConn.close();
                ++count;
            }
            catch (SQLException ex) {
                break;
            }
        }
        return count;
    }

    public void doCloseCachedConnection() {
        HAStore theStore = (HAStore)this.getStore();
        theStore.closeConnection();
    }

    SessionFactory getSessionFactory() {
        return this._sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this._sessionFactory = sessionFactory;
    }

    public WebModuleStatistics getWebModuleStatistics() {
        return this._statistics;
    }

    public void setWebModuleStatistics(WebModuleStatistics statistics) {
        this._statistics = statistics;
    }

    public Map getConnectionsMap() {
        return this._connectionsMap;
    }

    public synchronized void putConnection(Connection conn) {
        this._connectionsMap.put(conn, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionFromManagerCache(Session session) {
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            this.sessions.remove(session.getId());
        }
    }
}

