/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.ee.web.sessmgmt;

import com.sun.appserv.ee.web.sessmgmt.HATimeoutException;
import com.sun.logging.LogDomains;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.logging.Logger;

public class HAErrorManager {
    protected static Hashtable retryables = new Hashtable();
    private static Logger _logger = null;
    private long timeoutMsecs = 300000L;
    private long txStartTime;
    private long txDuration = 0L;
    protected String id;
    private static final int TX_IDLE = 1;
    private static final int TX_STARTED = 2;
    private static final int TX_COMPLETED = 3;
    private int txState = 1;

    public HAErrorManager(long timeoutSecs, String id) {
        this.timeoutMsecs = timeoutSecs * 1000L;
        this.id = id;
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
        }
    }

    private boolean isRetryable(SQLException e) {
        String msgnum = new Integer(e.getErrorCode()).toString();
        String err = (String)retryables.get(msgnum);
        return err != null;
    }

    public void printRetryableMessage(SQLException e) {
        String msgnum = new Integer(e.getErrorCode()).toString();
        String err = (String)retryables.get(msgnum);
        _logger.finest("  " + err);
    }

    public void checkError(SQLException e, Connection con) throws SQLException, HATimeoutException {
        int nativeCode = e.getErrorCode();
        if (!this.isRetryable(e)) {
            throw e;
        }
        this.checkTimeouts();
        try {
            if (con != null) {
                con.rollback();
            }
        }
        catch (SQLException abortE) {
            // empty catch block
        }
    }

    protected void checkTimeouts() throws HATimeoutException {
        if (this.getElapsedTime() > this.timeoutMsecs) {
            throw new HATimeoutException("Unable to complete a transaction after " + this.timeoutMsecs / 60000L + " minutes.");
        }
    }

    public void txStart() {
        if (this.txState != 2) {
            this.txState = 2;
            this.txStartTime = System.currentTimeMillis();
            this.txDuration = 0L;
        }
    }

    public void txEnd() {
        this.txState = 3;
        this.txDuration = System.currentTimeMillis() - this.txStartTime;
    }

    public boolean isTxCompleted() {
        return this.txState == 3;
    }

    public long getElapsedTime() {
        if (this.txState == 2) {
            return System.currentTimeMillis() - this.txStartTime;
        }
        if (this.txState == 3) {
            return this.txDuration;
        }
        return 0L;
    }

    public long getTimeoutMsecs() {
        return this.timeoutMsecs;
    }

    static {
        retryables.put("208", "208 - Transaction Aborted");
        retryables.put("216", "216 - Abort Requested By Slave");
        retryables.put("224", "225 - Operation Timed Out");
        retryables.put("1552", "1552 - Too Many Transactions");
        retryables.put("2080", "2080 - Out of Locks");
        retryables.put("2097", "2097 - Upgrade From Shared to Exclusive Lock Failed");
        retryables.put("2168", "2168 - Execution Terminated at Slave Involved in Takeover");
        retryables.put("2320", "2320 - TCON Does Not Accept Clients");
        retryables.put("3104", "3104 - Bad Slave");
        retryables.put("3504", "3504 - Node Failed");
        retryables.put("4192", "4192 - Reply Lost");
        retryables.put("4576", "4576 - Client Held Transaction Open Too Long");
        retryables.put("4624", "4624 - Cursor Failure");
        retryables.put("25018", "25018 - Lost Connection");
        retryables.put("25017", "25017 - No Connection");
        retryables.put("25012", "25012 - RPC Connection failed");
        retryables.put("25005", "25005 - RPC is closed");
        retryables.put("2304", "2304 - Session Disconnected");
        retryables.put("20001", "20001 - Internal Error");
        retryables.put("20004", "20004 - Connection closed");
        retryables.put("20005", "20005 - RPC closed");
        retryables.put("25013", "25013 - RPC Execute failed");
        retryables.put("12522", "12522 - no connection is created");
        retryables.put("1040", "1040 - No such file in file directory");
        retryables.put("1680", "1680");
        retryables.put("2078", "2078");
        retryables.put("1986", "1986");
    }
}

