/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.ee.web.sessmgmt;

import com.sun.appserv.ee.web.sessmgmt.HAWebEventPersistentManager;
import com.sun.logging.LogDomains;
import java.util.logging.Logger;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Session;

public class HAContainerListener
implements ContainerListener {
    private static Logger _logger = null;

    public HAContainerListener() {
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
        }
    }

    public void containerEvent(ContainerEvent event) {
        if (event.getType().equals("sessionSetAttributeCalledForAdd")) {
            this.processAttributeAddEvent(event);
        } else if (event.getType().equals("sessionSetAttributeCalledForReplace")) {
            this.processAttributeUpdateEvent(event);
        } else if (event.getType().equals("sessionRemoveAttributeCalled")) {
            this.processAttributeRemoveEvent(event);
        }
    }

    private void processAttributeAddEvent(ContainerEvent event) {
        _logger.finest("IN CONTAINER_EVENT for sessionSetAttributeCalledForAdd");
        this.processSessionAttributeEvent(event);
    }

    private void processAttributeUpdateEvent(ContainerEvent event) {
        _logger.finest("IN CONTAINER_EVENT for sessionSetAttributeCalledForReplace");
        this.processSessionAttributeEvent(event);
    }

    private void processAttributeRemoveEvent(ContainerEvent event) {
        _logger.finest("IN CONTAINER_EVENT for sessionRemoveAttributeCalled");
        this.processSessionAttributeEvent(event);
    }

    private void processSessionAttributeEvent(ContainerEvent event) {
        Context context = (Context)event.getContainer();
        HttpSessionBindingEvent hsbe = (HttpSessionBindingEvent)event.getData();
        String name = hsbe.getName();
        Object value = hsbe.getValue();
        HttpSession sess = hsbe.getSession();
        String sessId = null;
        if (sess != null) {
            sessId = sess.getId();
        }
        _logger.finest("ATTRIBUTE_NAME = " + name + ": SESSION_ID = " + sessId);
        if (sess != null) {
            Session session = (Session)sess;
            HAWebEventPersistentManager pMgr = (HAWebEventPersistentManager)session.getManager();
            pMgr.doValveSave(session);
        }
    }
}

