/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.ee.web.sessmgmt;

import com.iplanet.ias.web.ServerConfigLookup;
import com.iplanet.ias.web.ShutdownCleanupCapable;
import com.sun.appserv.ee.web.sessmgmt.HADBConnectionGroup;
import com.sun.appserv.ee.web.sessmgmt.HAErrorManager;
import com.sun.appserv.ee.web.sessmgmt.HATimeoutException;
import com.sun.ejb.spi.SFSBStoreManager;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.resource.JDBCConnectionHelper;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.catalina.Container;
import org.apache.catalina.Manager;
import org.apache.catalina.Valve;

public class ConnectionUtil {
    private static DataSource _dataSource = null;
    private static Logger _logger = null;
    protected HAErrorManager haErr = null;
    protected String driverName = "com.sun.hadb.jdbc.Driver";
    protected String timeoutSecs = new Long(300L).toString();
    protected Object container = null;
    protected Object manager = null;
    protected Valve valve = null;
    protected Connection conn = null;
    protected String threadName = "ConnectionUtil";
    protected String user = null;
    protected String password = null;
    protected String connString = null;
    protected String dataSourceString = null;
    protected DataSource dataSource = null;

    public ConnectionUtil(Container cont) {
        this.container = cont;
        this.threadName = "ConnectionUtil";
        long timeout = new Long(this.timeoutSecs);
        this.haErr = new HAErrorManager(timeout, this.threadName);
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web.ee");
        }
    }

    public ConnectionUtil(Object cont, SFSBStoreManager mgr) {
        this.container = cont;
        this.threadName = "ConnectionUtil";
        long timeout = new Long(this.timeoutSecs);
        this.haErr = new HAErrorManager(timeout, this.threadName);
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web.ee");
        }
        this.manager = mgr;
    }

    public ConnectionUtil(Container cont, Manager mgr) {
        this(cont);
        this.manager = mgr;
    }

    public ConnectionUtil(Container cont, Valve aValve) {
        this(cont);
        this.valve = aValve;
    }

    protected String getConnUser() {
        if (this.user == null) {
            ServerConfigLookup lookup = new ServerConfigLookup();
            this.user = lookup.getConnectionUserFromConfig();
        }
        return this.user;
    }

    protected String getConnPassword() {
        if (this.password == null) {
            ServerConfigLookup lookup = new ServerConfigLookup();
            this.password = lookup.getConnectionPasswordFromConfig();
        }
        return this.password;
    }

    protected String getConnString() {
        if (this.connString == null) {
            ServerConfigLookup lookup = new ServerConfigLookup();
            this.connString = lookup.getConnectionURLFromConfig();
        }
        return this.connString;
    }

    protected String getDataSourceNameFromConfig() {
        if (this.dataSourceString == null) {
            ServerConfigLookup configLookup = new ServerConfigLookup();
            this.dataSourceString = configLookup.getHaStorePoolJndiNameFromConfig();
        }
        return this.dataSourceString;
    }

    protected DataSource getDataSource() throws NamingException {
        DataSource ds;
        if (this.dataSource != null) {
            return this.dataSource;
        }
        if (_dataSource != null) {
            this.dataSource = _dataSource;
            return _dataSource;
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
                return null;
            }
        });
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
        }
        catch (Exception e) {
            try {
                _logger.finest("ERROR CREATING INITCTX+++++++++");
                e.printStackTrace();
                throw new NamingException(e.getMessage());
            }
            catch (Throwable throwable) {
                AccessController.doPrivileged(new PrivilegedAction(contextClassLoader){
                    private final /* synthetic */ ClassLoader val$contextClassLoader;
                    {
                        this.val$contextClassLoader = val$contextClassLoader;
                    }

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(this.val$contextClassLoader);
                        return null;
                    }
                });
                throw throwable;
            }
        }
        AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        String dsName = this.getDataSourceNameFromConfig();
        this.dataSource = ds = (DataSource)ctx.lookup(dsName);
        ConnectionUtil.setDataSource(ds);
        return ds;
    }

    private static synchronized void setDataSource(DataSource ds) {
        _dataSource = ds;
    }

    protected Connection getConnectionFromPool() throws IOException {
        Connection conn = null;
        InvocationManager invmgr = null;
        ComponentInvocation ci = null;
        try {
            invmgr = Switch.getSwitch().getInvocationManager();
            ci = new ComponentInvocation((Object)this, this.container);
            invmgr.preInvoke(ci);
            DataSource ds = this.getDataSource();
            conn = this.getConnectionRetry(ds);
        }
        catch (Exception ex) {
            try {
                IOException ex1 = (IOException)new IOException("Unable to obtain connection from pool").initCause(ex);
                throw ex1;
            }
            catch (Throwable throwable) {
                invmgr.postInvoke(ci);
                throw throwable;
            }
        }
        invmgr.postInvoke(ci);
        return conn;
    }

    private Connection getConnectionRetry(DataSource ds) throws IOException {
        Connection resultConn = null;
        long timeout = new Long(this.timeoutSecs);
        HAErrorManager haErr = new HAErrorManager(timeout, this.threadName);
        try {
            haErr.txStart();
            while (!haErr.isTxCompleted()) {
                try {
                    resultConn = ds.getConnection();
                    resultConn.setAutoCommit(false);
                    haErr.txEnd();
                }
                catch (SQLException e) {
                    haErr.checkError(e, null);
                    if (resultConn != null) {
                        try {
                            resultConn.close();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    _logger.finest("Got a retryable exception from ConnectionUtil: " + e.getMessage());
                }
            }
        }
        catch (SQLException e) {
            IOException ex1 = (IOException)new IOException("Error from ConnectionUtil: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException e) {
            IOException ex1 = (IOException)new IOException("Timeout from ConnectionUtil").initCause(e);
            throw ex1;
        }
        if (resultConn == null) {
            _logger.warning("ConnectionUtil>>getConnectionRetry failed: returning null");
        }
        return resultConn;
    }

    public HADBConnectionGroup getConnectionsFromPool() throws IOException {
        Connection conn = this.getConnectionFromPool();
        if (conn == null) {
            _logger.warning("ConnectionUtil>>getConnectionsFromPool failed: returning null");
            return null;
        }
        Connection internalConn = null;
        JDBCConnectionHelper helper = new JDBCConnectionHelper(conn);
        try {
            internalConn = helper.getInternalConnection();
        }
        catch (Exception ex) {
            IOException ex1 = (IOException)new IOException("Unable to obtain connection from pool").initCause(ex);
            throw ex1;
        }
        HADBConnectionGroup connections = new HADBConnectionGroup(internalConn, conn);
        this.putConnection(internalConn);
        return connections;
    }

    public Connection getConnection() throws IOException {
        return this.getConnection(true);
    }

    public Connection getConnection(boolean autoCommit) throws IOException {
        long timeout = new Long(this.timeoutSecs);
        HAErrorManager haErr = new HAErrorManager(timeout, this.threadName);
        haErr.txStart();
        while (!haErr.isTxCompleted()) {
            IOException ex1;
            try {
                if (this.conn != null && !this.conn.isClosed() && this.conn.getAutoCommit()) {
                    this.conn.setAutoCommit(autoCommit);
                }
                _logger.finest("VALUE-OF-CONN-STRING= " + this.getConnString());
            }
            catch (Exception e1) {
                this.conn = null;
            }
            if (this.conn != null) {
                _logger.finest("getConnection-near begin return conn from cache");
                haErr.txEnd();
                break;
            }
            try {
                try {
                    Class.forName(this.driverName);
                }
                catch (ClassNotFoundException ex) {
                    ex1 = (IOException)new IOException("Unable to find JDBC driver class " + this.driverName + ": " + ex.getMessage()).initCause(ex);
                    throw ex1;
                }
                try {
                    Properties props = new Properties();
                    String theUser = this.getConnUser();
                    String thePassword = this.getConnPassword();
                    props.setProperty("user", this.user);
                    props.setProperty("password", this.password);
                    this.conn = DriverManager.getConnection(this.getConnString(), props);
                    this.conn.setAutoCommit(autoCommit);
                    this.conn.setTransactionIsolation(4);
                    haErr.txEnd();
                    _logger.finest("getConnection at middle - return created conn: " + this.conn);
                }
                catch (SQLException ex) {
                    haErr.checkError(ex, this.conn);
                }
            }
            catch (SQLException e) {
                ex1 = (IOException)new IOException("Unable to open connection to HA Store: " + e.getMessage()).initCause(e);
                throw ex1;
            }
            catch (HATimeoutException e) {
                IOException ex2 = (IOException)new IOException("Timed out attempting to open connection to HA Store").initCause(e);
                throw ex2;
            }
        }
        _logger.finest("getConnection at end - return conn: " + this.conn);
        if (this.conn != null) {
            this.putConnection(this.conn);
        }
        return this.conn;
    }

    protected void putConnection(Connection conn) {
        if (this.manager instanceof ShutdownCleanupCapable) {
            ((ShutdownCleanupCapable)this.manager).putConnection(conn);
        }
        if (this.valve instanceof ShutdownCleanupCapable) {
            ((ShutdownCleanupCapable)this.valve).putConnection(conn);
        }
    }

    public void clearCachedConnection() {
        this.conn = null;
    }
}

