/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.ee.web.sessmgmt;

import com.sun.hadb.jdbc.LOBDescr;
import com.sun.hadb.jdbc.LobConnection;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class BlobAttributeSession {
    public static final String driver = "com.sun.hadb.jdbc.Driver";
    private static Connection con;
    private static String sessionHeaderTableName;
    private static String sessionAttributeTableName;
    private static PreparedStatement preparedInsertSesHdrSql;
    private static PreparedStatement preparedInsertSesAttrSql;
    private static LOBDescr lob;

    public BlobAttributeSession(String url) throws SQLException {
        con = DriverManager.getConnection(url);
    }

    public void createHeaderTable() throws SQLException {
        String query = "CREATE TABLE " + sessionHeaderTableName + " (id varchar(100) not null primary key," + "valid char(1) not null," + "maxinactive int not null," + "lastaccess double integer," + "appid varchar(100)," + "username varchar(100)," + "ssoid varchar(100))";
        Statement stmt = con.createStatement();
        stmt.executeUpdate(query);
    }

    public void createAttributeTable() throws SQLException {
        String query = "CREATE TABLE " + sessionAttributeTableName + " (rowid varchar(200) not null," + "sessattrdata integer," + "id varchar(100) not null," + "attributename varchar(100), constraint pk primary key(rowid))";
        Statement stmt = con.createStatement();
        stmt.executeUpdate(query);
        ((LobConnection)con).createLobTable(null, sessionAttributeTableName);
    }

    public void dropHeaderTable() {
        try {
            String query = "DROP TABLE " + sessionHeaderTableName;
            Statement stmt = con.createStatement();
            stmt.executeUpdate(query);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void dropAttributeTable() {
        try {
            String query = "DROP TABLE " + sessionAttributeTableName;
            Statement stmt = con.createStatement();
            stmt.executeUpdate(query);
            ((LobConnection)con).dropLobTable(null, sessionAttributeTableName);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void insertSessionHeader(String sessionId, Connection connection) throws IOException {
        String insertHdrSql = "INSERT into " + sessionHeaderTableName + "(" + "id, valid, maxinactive, lastaccess, appid, username ) " + "VALUES (?, ?, ?, ?, ?, ?)";
        try {
            if (preparedInsertSesHdrSql == null) {
                preparedInsertSesHdrSql = connection.prepareStatement(insertHdrSql);
            }
            preparedInsertSesHdrSql.setString(1, sessionId);
            preparedInsertSesHdrSql.setString(2, "1");
            preparedInsertSesHdrSql.setInt(3, 60);
            preparedInsertSesHdrSql.setLong(4, 1000L);
            preparedInsertSesHdrSql.setString(5, "cluster1:webapps");
            preparedInsertSesHdrSql.setString(6, "user1");
            preparedInsertSesHdrSql.executeUpdate();
            con.commit();
        }
        catch (SQLException e) {
            try {
                con.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            e.printStackTrace();
            throw new IOException("Error from HA Store: " + e.getMessage());
        }
    }

    public void insertAttribute(String sessionId, String attrName, String attrVal, Connection con) throws IOException {
        LobConnection lobConn = (LobConnection)con;
        lob.setTableName(sessionAttributeTableName);
        lob.addKey("rowid", 1);
        lob.setLOBColumn("sessattrdata", 2);
        String insertAttrSql = "INSERT INTO " + sessionAttributeTableName + " (" + "rowid, sessattrdata, id, attributename) " + "VALUES (?, ?, ?, ?)";
        try {
            if (preparedInsertSesAttrSql == null) {
                preparedInsertSesAttrSql = lobConn.prepareLobStatement(insertAttrSql, lob);
            }
            String attrData = attrVal;
            BufferedInputStream in = null;
            int buflength = 0;
            in = this.getInputStream(attrData, buflength);
            preparedInsertSesAttrSql.setString(1, sessionId + ":" + attrName);
            preparedInsertSesAttrSql.setBinaryStream(2, (InputStream)in, buflength);
            preparedInsertSesAttrSql.setString(3, sessionId);
            preparedInsertSesAttrSql.setString(4, attrName);
            preparedInsertSesAttrSql.executeUpdate();
            ((Connection)lobConn).commit();
        }
        catch (SQLException e) {
            try {
                ((Connection)lobConn).rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            throw new IOException("Error from HA Store: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedInputStream getInputStream(Object attribute, int length) throws IOException {
        BufferedInputStream in;
        ByteArrayInputStream bis;
        block5: {
            ByteArrayOutputStream bos = null;
            bis = null;
            ObjectOutputStream oos = null;
            in = null;
            try {
                bos = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(new BufferedOutputStream(bos));
                oos.writeObject(attribute);
                oos.close();
                oos = null;
                byte[] obs = bos.toByteArray();
                bis = new ByteArrayInputStream(obs, 0, obs.length);
                in = new BufferedInputStream(bis, obs.length);
                length = obs.length;
                Object var9_8 = null;
                if (oos == null) break block5;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (oos != null) {
                    oos.close();
                }
                if (bis != null) {
                    bis.close();
                }
                throw throwable;
            }
            oos.close();
        }
        if (bis != null) {
            bis.close();
        }
        return in;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("usage: java BlobSession url");
            System.exit(1);
        }
        try {
            Class.forName(driver);
            BlobAttributeSession bs = new BlobAttributeSession("jdbc:sun:hadb:system+super@" + args[0]);
            bs.dropAttributeTable();
            bs.dropHeaderTable();
            bs.createHeaderTable();
            bs.createAttributeTable();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        sessionHeaderTableName = "sessionheader";
        sessionAttributeTableName = "sessionattribute";
        preparedInsertSesHdrSql = null;
        preparedInsertSesAttrSql = null;
        lob = new LOBDescr();
    }
}

