/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.ee.web.initialization;

import com.iplanet.ias.config.ConfigBean;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.server.ApplicationServer;
import com.iplanet.ias.server.ServerContext;
import com.sun.logging.LogDomains;
import java.util.Properties;
import java.util.logging.Logger;

public class ServerConfigReader {
    private static final int DEFAULT_HASTORE_POOL_SIZE = 100;
    private static final int DEFAULT_HASTORE_POOL_UPPER_SIZE = -1;
    private static final int DEFAULT_HASTORE_POOL_POLL_TIME = 100;
    private static String HASTORE_POOL_SIZE_XPATH_STRING = "/server/availability-service/persistence-store/property[@name='ha-store-pool-size']";
    private static String HASTORE_POOL_UPPER_SIZE_XPATH_STRING = "/server/availability-service/persistence-store/property[@name='ha-store-upper-pool-size']";
    private static String HASTORE_POOL_POLL_TIME_XPATH_STRING = "/server/availability-service/persistence-store/property[@name='ha-store-poll-time']";
    protected static boolean _isMonitoringEnabled = false;
    private static Logger _logger;

    public ServerConfigReader() {
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
        }
    }

    public static boolean isMonitoringEnabled() {
        return _isMonitoringEnabled;
    }

    protected static boolean checkMonitoringEnabled() {
        boolean result = false;
        try {
            Properties props = System.getProperties();
            String str = props.getProperty("MONITOR_WEB_CONTAINER");
            if (null != str && str.equalsIgnoreCase("TRUE")) {
                result = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public int getServerConfigValue(String xpath, int defaultValue) {
        _logger.finest("in getServerConfigValue:xpath=" + xpath + " defaultValue= " + defaultValue);
        ServerContext serverCtx = ApplicationServer.getServerContext();
        ConfigContext configCtx = serverCtx.getConfigContext();
        ConfigBean configBean = null;
        String returnValueString = null;
        int returnValue = defaultValue;
        try {
            configBean = configCtx.exactLookup(xpath);
        }
        catch (ConfigException ex) {
            // empty catch block
        }
        if (configBean != null) {
            returnValueString = configBean.getAttributeValue("value");
        }
        if (returnValueString != null) {
            try {
                returnValue = Integer.valueOf(returnValueString);
            }
            catch (NumberFormatException ex) {
                _logger.finest("Using Default Value = " + defaultValue);
            }
        }
        _logger.finest("RETURNED CONFIG VALUE FOR XPATH:" + xpath + " = " + returnValue);
        return returnValue;
    }

    public int getHAStorePoolSizeFromConfig() {
        return this.getServerConfigValue(HASTORE_POOL_SIZE_XPATH_STRING, 100);
    }

    public int getHAStorePoolUpperSizeFromConfig() {
        return this.getServerConfigValue(HASTORE_POOL_UPPER_SIZE_XPATH_STRING, -1);
    }

    public int getHAStorePoolPollTimeFromConfig() {
        return this.getServerConfigValue(HASTORE_POOL_POLL_TIME_XPATH_STRING, 100);
    }

    static {
        _isMonitoringEnabled = ServerConfigReader.checkMonitoringEnabled();
        _logger = null;
    }
}

