/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.ee.web.authenticator;

import com.iplanet.ias.web.ShutdownCleanupCapable;
import com.sun.appserv.ee.web.authenticator.HASingleSignOnEntry;
import com.sun.appserv.ee.web.authenticator.SSOStorePoolElement;
import com.sun.appserv.ee.web.sessmgmt.HASession;
import com.sun.appserv.ee.web.sessmgmt.StorePool;
import com.sun.web.security.RealmAdapter;
import java.io.IOException;
import java.security.Principal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.authenticator.SingleSignOnEntry;
import org.apache.catalina.session.StandardSession;

public class HASingleSignOn
extends SingleSignOn
implements ShutdownCleanupCapable {
    protected StorePool _pool = null;
    private Thread thread = null;
    private boolean threadDone = false;
    private Map _connectionsMap = Collections.synchronizedMap(new WeakHashMap(50));

    public void setSSOStorePool(StorePool pool) {
        this._pool = pool;
    }

    public StorePool getSSOStorePool() {
        return this._pool;
    }

    public void doCloseCachedConnection() {
    }

    public int doShutdownCleanup() {
        return this.closeAllConnections();
    }

    public int closeAllConnections() {
        if (this.debug >= 1) {
            this.log("IN HASingleSignOn closeAllConnections");
        }
        int count = 0;
        Set connections = this._connectionsMap.keySet();
        Iterator it = connections.iterator();
        while (it.hasNext()) {
            Connection nextConn = (Connection)it.next();
            if (nextConn == null) continue;
            try {
                nextConn.close();
                ++count;
            }
            catch (SQLException ex) {}
        }
        if (this.debug >= 1) {
            this.log("HASingleSignOn closed " + count + " connections during shutdown");
        }
        return count;
    }

    public synchronized void putConnection(Connection conn) {
        this._connectionsMap.put(conn, null);
    }

    public int invoke(Request request, Response response) throws IOException, ServletException {
        SingleSignOnEntry entry;
        if (this.debug >= 1) {
            this.log("  IN invoke() : HASingleSignOn");
        }
        if (!(request instanceof HttpRequest) || !(response instanceof HttpResponse)) {
            return 1;
        }
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        request.removeNote("org.apache.catalina.request.SSOID");
        if (hreq.getUserPrincipal() != null) {
            if (this.debug >= 1) {
                this.log(" Principal '" + hreq.getUserPrincipal().getName() + "' has already been authenticated");
            }
            return 1;
        }
        if (this.debug >= 1) {
            this.log(" Checking for SSO cookie");
        }
        Cookie cookie = null;
        Cookie[] cookies = hreq.getCookies();
        if (cookies == null) {
            cookies = new Cookie[]{};
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!"JSESSIONIDSSO".equals(cookies[i].getName())) continue;
            cookie = cookies[i];
            break;
        }
        if (cookie == null) {
            if (this.debug >= 1) {
                this.log(" SSO cookie is not present");
            }
            return 1;
        }
        if (this.debug >= 1) {
            this.log(" Checking for cached principal for " + cookie.getValue());
        }
        if ((entry = this.lookup(cookie.getValue())) != null && entry.principal == null && entry.username != null) {
            if (this.debug >= 1) {
                this.log("class " + this.container.getClass() + " container=" + this.container + " realm : " + request.getContext().getRealm() + "    ");
            }
            entry.principal = ((RealmAdapter)request.getContext().getRealm()).createFailOveredPrincipal(entry.username);
        }
        if (this.debug >= 1) {
            this.log(" Cached SingleSignOnEntry : " + entry);
        }
        if (entry != null) {
            if (this.debug >= 1) {
                this.log(" Found cached principal '" + entry.principal.getName() + "' with auth type '" + entry.authType + "'");
            }
            request.setNote("org.apache.catalina.request.SSOID", (Object)cookie.getValue());
            ((HttpRequest)request).setAuthType(entry.authType);
            ((HttpRequest)request).setUserPrincipal(entry.principal);
            entry.lastAccessTime = System.currentTimeMillis();
            ((HASingleSignOnEntry)entry).dirty = true;
        } else {
            if (this.debug >= 1) {
                this.log(" No cached principal found, erasing SSO cookie");
            }
            cookie.setMaxAge(0);
            cookie.setPath("/");
            hres.addCookie(cookie);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public SingleSignOnEntry lookup(String ssoId) {
        SingleSignOnEntry ssoEntry;
        block22: {
            SSOStorePoolElement store;
            long startTime;
            block21: {
                block19: {
                    SingleSignOnEntry singleSignOnEntry;
                    block20: {
                        if (this.debug >= 1) {
                            this.log("in lookup for " + ssoId);
                        }
                        ssoEntry = null;
                        startTime = System.currentTimeMillis();
                        store = null;
                        store = (SSOStorePoolElement)this._pool.take();
                        store.setContainer(this.getContainer());
                        ssoEntry = super.lookup(ssoId);
                        if (ssoEntry == null) break block19;
                        singleSignOnEntry = ssoEntry;
                        Object var8_8 = null;
                        if (store == null) break block20;
                        try {
                            this._pool.put(store);
                            long endTime = System.currentTimeMillis();
                            if (this.debug >= 1) {
                                this.log("lookup_TIME MILLIS = " + (endTime - startTime));
                            }
                        }
                        catch (InterruptedException ex1) {
                            ex1.printStackTrace();
                        }
                    }
                    return singleSignOnEntry;
                }
                try {
                    ssoEntry = store.loadSSO(ssoId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (ssoEntry == null) break block21;
                if (this.debug >= 1) {
                    this.log("lookup before :- ssoID=" + ssoId + "   " + ssoEntry);
                    this.log("container= " + this.container + " realm= " + this.container.getRealm());
                    this.log("lookup after if :- ssoID=" + ssoId + "   " + ssoEntry);
                }
                this.registerInMemory(ssoId, ssoEntry);
            }
            Object var8_9 = null;
            if (store == null) break block22;
            try {
                this._pool.put(store);
                long endTime = System.currentTimeMillis();
                if (this.debug >= 1) {
                    this.log("lookup_TIME MILLIS = " + (endTime - startTime));
                }
                break block22;
            }
            catch (InterruptedException ex1) {
                ex1.printStackTrace();
            }
            break block22;
            {
                catch (InterruptedException iex) {
                    iex.printStackTrace();
                    Object var8_10 = null;
                    if (store == null) break block22;
                    try {
                        this._pool.put(store);
                        long endTime = System.currentTimeMillis();
                        if (this.debug >= 1) {
                            this.log("lookup_TIME MILLIS = " + (endTime - startTime));
                        }
                        break block22;
                    }
                    catch (InterruptedException ex1) {
                        ex1.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (store != null) {
                    try {
                        this._pool.put(store);
                        long endTime = System.currentTimeMillis();
                        if (this.debug >= 1) {
                            this.log("lookup_TIME MILLIS = " + (endTime - startTime));
                        }
                    }
                    catch (InterruptedException ex1) {
                        ex1.printStackTrace();
                    }
                }
                throw throwable;
            }
        }
        return ssoEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerInMemory(String ssoId, SingleSignOnEntry sso) {
        if (this.debug >= 1) {
            this.log("HASSO.registerInMemory");
        }
        HashMap hashMap = this.cache;
        synchronized (hashMap) {
            this.cache.put(ssoId, sso);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void register(String ssoId, Principal principal, String authType, String username, String password) {
        if (this.debug >= 1) {
            this.log("HASSO.register");
        }
        startTime = System.currentTimeMillis();
        store = null;
        try {
            block13: {
                store = (SSOStorePoolElement)this._pool.take();
                store.setContainer(this.getContainer());
                ssoEntry = new HASingleSignOnEntry(principal, authType, username, password);
                this.registerInMemory(ssoId, ssoEntry);
                if (authType.equals("FORM")) break block13;
                var12_10 = null;
                if (store == null) return;
                ** GOTO lbl51
            }
            try {
                store.save(ssoId, ssoEntry);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ** GOTO lbl60
        }
        catch (InterruptedException iex) {
            iex.printStackTrace();
            var12_12 = null;
            if (store == null) return;
            try {
                this._pool.put(store);
                endTime = System.currentTimeMillis();
                if (this.debug < 1) return;
                this.log("register_TIME MILLIS = " + (endTime - startTime));
                return;
            }
            catch (InterruptedException ex1) {
                ex1.printStackTrace();
                return;
            }
        }
        {
            catch (Throwable var11_23) {
                var12_13 = null;
                if (store == null) throw var11_23;
                ** try [egrp 3[TRYBLOCK] [7 : 134->186)] { 
lbl43:
                // 1 sources

                this._pool.put(store);
                endTime = System.currentTimeMillis();
                if (this.debug < 1) throw var11_23;
                this.log("register_TIME MILLIS = " + (endTime - startTime));
                throw var11_23;
lbl48:
                // 1 sources

                catch (InterruptedException ex1) {
                    ex1.printStackTrace();
                }
                throw var11_23;
            }
lbl51:
            // 1 sources

            ** try [egrp 3[TRYBLOCK] [7 : 134->186)] { 
lbl52:
            // 1 sources

            this._pool.put(store);
            endTime = System.currentTimeMillis();
            if (this.debug < 1) return;
            this.log("register_TIME MILLIS = " + (endTime - startTime));
            return;
lbl57:
            // 1 sources

            catch (InterruptedException ex1) {
                ex1.printStackTrace();
            }
            return;
lbl60:
            // 2 sources

            var12_11 = null;
            if (store == null) return;
            try {}
            catch (InterruptedException ex1) {}
            ex1.printStackTrace();
            return;
            this._pool.put(store);
            endTime = System.currentTimeMillis();
            if (this.debug < 1) return;
            this.log("register_TIME MILLIS = " + (endTime - startTime));
            return;
        }
    }

    protected void deregister(String ssoId) {
        this.deregister(ssoId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void deregister(String ssoId, boolean bgCall) {
        if (bgCall) {
            if (this.debug >= 1) {
                this.log("BackGround : Deregistering ssoId '" + ssoId + "'");
            }
        } else if (this.debug >= 1) {
            this.log("ForeGround : Deregistering ssoId '" + ssoId + "'");
        }
        sso = null;
        startTime = System.currentTimeMillis();
        store = null;
        try {
            block27: {
                store = (SSOStorePoolElement)this._pool.take();
                store.setContainer(this.getContainer());
                var7_6 = this.cache;
                synchronized (var7_6) {
                    sso = (SingleSignOnEntry)this.cache.remove(ssoId);
                }
                try {
                    if (!bgCall) {
                        store.remove(ssoId);
                    } else {
                        store.remove(ssoId, null);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (sso != null) break block27;
                var12_9 = null;
                if (store == null) return;
                ** GOTO lbl80
            }
            sessions = sso.findSessions();
            for (i = 0; i < sessions.length; ++i) {
                if (this.debug >= 1) {
                    this.log(" Invalidating session " + sessions[i]);
                }
                var9_23 = this.reverse;
                synchronized (var9_23) {
                    this.reverse.remove(sessions[i]);
                }
                sessions[i].expire();
            }
            try {
                block28: {
                    if (bgCall) break block28;
                    store.removeInActiveSessions(ssoId);
                    ** GOTO lbl89
                }
                store.removeInActiveSessions(ssoId, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ** GOTO lbl89
        }
        catch (InterruptedException iex) {
            iex.printStackTrace();
            var12_11 = null;
            if (store == null) return;
            try {
                this._pool.put(store);
                endTime = System.currentTimeMillis();
                if (this.debug < 1) return;
                this.log("deregister_TIME MILLIS = " + (endTime - startTime));
                return;
            }
            catch (InterruptedException ex1) {
                ex1.printStackTrace();
                return;
            }
        }
        {
            catch (Throwable var11_24) {
                var12_12 = null;
                if (store == null) throw var11_24;
                ** try [egrp 6[TRYBLOCK] [12 : 359->411)] { 
lbl72:
                // 1 sources

                this._pool.put(store);
                endTime = System.currentTimeMillis();
                if (this.debug < 1) throw var11_24;
                this.log("deregister_TIME MILLIS = " + (endTime - startTime));
                throw var11_24;
lbl77:
                // 1 sources

                catch (InterruptedException ex1) {
                    ex1.printStackTrace();
                }
                throw var11_24;
            }
lbl80:
            // 1 sources

            ** try [egrp 6[TRYBLOCK] [12 : 359->411)] { 
lbl81:
            // 1 sources

            this._pool.put(store);
            endTime = System.currentTimeMillis();
            if (this.debug < 1) return;
            this.log("deregister_TIME MILLIS = " + (endTime - startTime));
            return;
lbl86:
            // 1 sources

            catch (InterruptedException ex1) {
                ex1.printStackTrace();
            }
            return;
lbl89:
            // 3 sources

            var12_10 = null;
            if (store == null) return;
            try {}
            catch (InterruptedException ex1) {}
            ex1.printStackTrace();
            return;
            this._pool.put(store);
            endTime = System.currentTimeMillis();
            if (this.debug < 1) return;
            this.log("deregister_TIME MILLIS = " + (endTime - startTime));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void associate(String ssoId, Session session) {
        block21: {
            if (this.debug >= 1) {
                this.log("Associate sso id " + ssoId + " WITH session " + session);
            }
            long startTime = System.currentTimeMillis();
            SSOStorePoolElement store = null;
            store = (SSOStorePoolElement)this._pool.take();
            store.setContainer(this.getContainer());
            SingleSignOnEntry sso = this.lookup(ssoId);
            if (sso != null) {
                sso.addSession((SingleSignOn)this, session);
            }
            HashMap hashMap = this.reverse;
            synchronized (hashMap) {
                this.reverse.put(session, ssoId);
            }
            try {
                if (session != null && session instanceof HASession) {
                    ((HASession)session).setSsoId(ssoId);
                    store.associate((StandardSession)session, ssoId);
                }
            }
            catch (Exception e) {
                if (this.debug >= 1) {
                    this.log("IOException caught in HASingleSignOn : associate()");
                }
                e.printStackTrace();
            }
            Object var10_10 = null;
            if (store == null) break block21;
            try {
                this._pool.put(store);
                long endTime = System.currentTimeMillis();
                if (this.debug >= 1) {
                    this.log("associate_TIME MILLIS = " + (endTime - startTime));
                }
                break block21;
            }
            catch (InterruptedException ex1) {
                ex1.printStackTrace();
            }
            break block21;
            {
                catch (InterruptedException iex) {
                    iex.printStackTrace();
                    Object var10_11 = null;
                    if (store == null) break block21;
                    try {
                        this._pool.put(store);
                        long endTime = System.currentTimeMillis();
                        if (this.debug >= 1) {
                            this.log("associate_TIME MILLIS = " + (endTime - startTime));
                        }
                        break block21;
                    }
                    catch (InterruptedException ex1) {
                        ex1.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (store != null) {
                    try {
                        this._pool.put(store);
                        long endTime = System.currentTimeMillis();
                        if (this.debug >= 1) {
                            this.log("associate_TIME MILLIS = " + (endTime - startTime));
                        }
                    }
                    catch (InterruptedException ex1) {
                        ex1.printStackTrace();
                    }
                }
                throw throwable;
            }
        }
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("authenticator.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        this.threadStart();
        if (this.debug >= 1) {
            this.log("Started");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void stop() throws LifecycleException {
        block22: {
            if (!this.started) {
                throw new LifecycleException(sm.getString("authenticator.notStarted"));
            }
            long startTime = System.currentTimeMillis();
            SSOStorePoolElement store = null;
            this.lifecycle.fireLifecycleEvent("stop", null);
            this.started = false;
            store = (SSOStorePoolElement)this._pool.take();
            store.setContainer(this.getContainer());
            HashMap hashMap = this.cache;
            synchronized (hashMap) {
                Iterator it = this.cache.keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    SingleSignOnEntry sso = (SingleSignOnEntry)this.cache.get(key);
                    if (!((HASingleSignOnEntry)sso).dirty) continue;
                    if (this.debug >= 1) {
                        this.log("Stop: updating the SSO session " + key);
                    }
                    store.save(key, sso);
                    ((HASingleSignOnEntry)sso).dirty = false;
                }
            }
            Object var10_10 = null;
            if (store == null) break block22;
            try {
                this._pool.put(store);
                long endTime = System.currentTimeMillis();
                if (this.debug >= 1) {
                    this.log("stop_TIME MILLIS = " + (endTime - startTime));
                }
                break block22;
            }
            catch (InterruptedException ex1) {
                ex1.printStackTrace();
            }
            break block22;
            {
                catch (InterruptedException iex) {
                    iex.printStackTrace();
                    Object var10_11 = null;
                    if (store == null) break block22;
                    try {
                        this._pool.put(store);
                        long endTime = System.currentTimeMillis();
                        if (this.debug >= 1) {
                            this.log("stop_TIME MILLIS = " + (endTime - startTime));
                        }
                        break block22;
                    }
                    catch (InterruptedException ex1) {
                        ex1.printStackTrace();
                    }
                    break block22;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Object var10_12 = null;
                    if (store == null) break block22;
                    try {
                        this._pool.put(store);
                        long endTime = System.currentTimeMillis();
                        if (this.debug >= 1) {
                            this.log("stop_TIME MILLIS = " + (endTime - startTime));
                        }
                        break block22;
                    }
                    catch (InterruptedException ex1) {
                        ex1.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                if (store != null) {
                    try {
                        this._pool.put(store);
                        long endTime = System.currentTimeMillis();
                        if (this.debug >= 1) {
                            this.log("stop_TIME MILLIS = " + (endTime - startTime));
                        }
                    }
                    catch (InterruptedException ex1) {
                        ex1.printStackTrace();
                    }
                }
                throw throwable;
            }
        }
        this.threadStop();
        if (this.debug >= 1) {
            this.log("Stopped");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processExpires() {
        block11: {
            long tooOld = System.currentTimeMillis() - (long)(this.getMaxInactive() * 1000);
            if (this.debug >= 1) {
                this.log(tooOld + "*******************SSO Expiration thread started. Current entries: " + this.cache.size());
            }
            ArrayList<String> removals = new ArrayList<String>(this.cache.size() / 2);
            try {
                HashMap hashMap = this.cache;
                synchronized (hashMap) {
                    Iterator it = this.cache.keySet().iterator();
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        SingleSignOnEntry sso = (SingleSignOnEntry)this.cache.get(key);
                        if (this.debug >= 1) {
                            this.log(tooOld + "*******************  " + sso.lastAccessTime + "   SSO Expiration thread started. Current entries: " + this.cache.size());
                        }
                        if (sso.sessions.length != 0 || sso.lastAccessTime >= tooOld) continue;
                        removals.add(key);
                    }
                }
                int removalCount = removals.size();
                if (this.debug >= 1) {
                    this.log("SSO cache will expire " + removalCount + " entries.");
                }
                for (int i = 0; i < removalCount; ++i) {
                    if (this.debug >= 1) {
                        this.log(" SSO Expiration removing entry: " + removals.get(i));
                    }
                    this.deregister((String)removals.get(i), true);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (this.debug < 1) break block11;
                this.log("  ", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void processUpdateLat() {
        block23: {
            if (this.debug >= 1) {
                this.log("In processUpdateLat");
            }
            long startTime = System.currentTimeMillis();
            SSOStorePoolElement store = null;
            Hashtable<String, SingleSignOnEntry> updatedLats = new Hashtable<String, SingleSignOnEntry>(this.cache.size() / 2);
            try {
                Iterator it;
                HashMap hashMap = this.cache;
                synchronized (hashMap) {
                    it = this.cache.keySet().iterator();
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        SingleSignOnEntry sso = (SingleSignOnEntry)this.cache.get(key);
                        if (this.debug >= 1) {
                            this.log("====" + sso.lastAccessTime + "   SSO Expiration/Updation thread started. Current cache entries: " + this.cache.size());
                        }
                        if (!((HASingleSignOnEntry)sso).dirty) continue;
                        updatedLats.put(key, sso);
                    }
                }
                int updatedLatsCount = updatedLats.size();
                if (this.debug >= 1) {
                    this.log("SSO table will updated " + updatedLatsCount + " entries.");
                }
                store = (SSOStorePoolElement)this._pool.take();
                store.setContainer(this.getContainer());
                it = updatedLats.keySet().iterator();
                while (it.hasNext()) {
                    String ssoId = (String)it.next();
                    if (this.debug >= 1) {
                        this.log(" SSO LATupdation updating entry: " + ssoId);
                    }
                    store.updateLastAccessTime(ssoId, ((SingleSignOnEntry)updatedLats.get((Object)ssoId)).lastAccessTime);
                    ((HASingleSignOnEntry)((Object)updatedLats.get((Object)ssoId))).dirty = false;
                }
                Object var11_12 = null;
                if (store == null) break block23;
                try {
                    this._pool.put(store);
                    long endTime = System.currentTimeMillis();
                    if (this.debug >= 1) {
                        this.log("processUpdateLat_TIME MILLIS = " + (endTime - startTime));
                    }
                    break block23;
                }
                catch (InterruptedException ex1) {
                    ex1.printStackTrace();
                }
                break block23;
                {
                    catch (InterruptedException iex) {
                        iex.printStackTrace();
                        Object var11_13 = null;
                        if (store == null) break block23;
                        try {
                            this._pool.put(store);
                            long endTime = System.currentTimeMillis();
                            if (this.debug >= 1) {
                                this.log("processUpdateLat_TIME MILLIS = " + (endTime - startTime));
                            }
                            break block23;
                        }
                        catch (InterruptedException ex1) {
                            ex1.printStackTrace();
                        }
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    if (store != null) {
                        try {
                            this._pool.put(store);
                            long endTime = System.currentTimeMillis();
                            if (this.debug >= 1) {
                                this.log("processUpdateLat_TIME MILLIS = " + (endTime - startTime));
                            }
                        }
                        catch (InterruptedException ex1) {
                            ex1.printStackTrace();
                        }
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (this.debug < 1) break block23;
                this.log("  ", e);
            }
        }
    }

    private void threadSleep() {
        if (this.debug >= 1) {
            this.log("*************   threadSleep()");
        }
        try {
            Thread.sleep((long)this.getReapInterval() * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void threadStart() {
        if (this.debug >= 1) {
            this.log("*************   threadStart()");
        }
        if (this.thread != null) {
            return;
        }
        this.threadDone = false;
        String threadName = "HASingleSignOnExpiration";
        this.thread = new Thread((Runnable)((Object)this), threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void threadStop() {
        if (this.debug >= 1) {
            this.log("*************   threadStop()");
        }
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.thread = null;
    }

    public void run() {
        while (!this.threadDone) {
            this.threadSleep();
            this.processExpires();
            this.processUpdateLat();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("HASingleSignOn[");
        sb.append(this.container.getName());
        sb.append("]");
        return sb.toString();
    }
}

