/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.ee.iiop;

import com.sun.corba.ee.internal.core.EndPoint;
import java.io.Serializable;
import java.net.InetAddress;

public class IIOPEndPoint
implements EndPoint,
Serializable {
    static final String IIOP_CLEAR_TEXT = "IIOP_CLEAR_TEXT";
    static final String SSL = "SSL";
    static final String MUTUAL_AUTH = "MUTUAL_AUTH";
    private InetAddress m_host;
    private int m_iport;
    private String m_stype;
    private int m_ilocatorPort;

    public IIOPEndPoint(InetAddress host, int port, String type) {
        this.m_stype = type;
        this.m_iport = port;
        this.m_host = host;
        this.m_ilocatorPort = -1;
    }

    public String getType() {
        return this.m_stype;
    }

    public int getPort() {
        return this.m_iport;
    }

    public int getLocatorPort() {
        return this.m_ilocatorPort;
    }

    public void setLocatorPort(int port) {
        this.m_ilocatorPort = port;
    }

    public String getHostAddress() {
        return this.m_host.getHostAddress();
    }

    public String getHostName() {
        return this.m_host.getHostName();
    }

    public int hashCode() {
        return this.m_stype.hashCode() ^ this.m_host.hashCode() ^ this.m_iport;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IIOPEndPoint)) {
            return false;
        }
        IIOPEndPoint otherEndPoint = (IIOPEndPoint)obj;
        if (!this.m_stype.equals(otherEndPoint.getType())) {
            return false;
        }
        if (this.m_iport != otherEndPoint.getPort()) {
            return false;
        }
        return this.m_host.getHostAddress().equals(otherEndPoint.getHostAddress());
    }

    public String toString() {
        return this.m_host.toString() + ":" + this.m_iport + " " + this.m_stype;
    }
}

