/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.ee.iiop;

import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.AvailabilityService;
import com.iplanet.ias.config.serverbeans.IiopCluster;
import com.iplanet.ias.config.serverbeans.IiopEndpoint;
import com.iplanet.ias.config.serverbeans.IiopServerInstance;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerBeansFactory;
import com.iplanet.ias.server.ApplicationServer;
import com.iplanet.ias.server.ServerContext;
import com.sun.appserv.ee.iiop.IIOPEndPoint;
import com.sun.enterprise.iiop.AlternateIIOPAddressComponent;
import com.sun.enterprise.iiop.AlternateIIOPAddressComponentHelper;
import com.sun.logging.LogDomains;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.IOP.Codec;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;

public class EEIORInterceptor
extends LocalObject
implements IORInterceptor {
    public static final String INTERCEPTOR_NAME = EEIORInterceptor.class.getName();
    private static Logger _logger = null;
    private Codec codec;

    public EEIORInterceptor(Codec c) {
        this.codec = c;
    }

    private Vector getIIOPClusterEndPoints() {
        Vector<IIOPEndPoint> endPoints = null;
        try {
            IiopServerInstance[] s1asInstances;
            IiopCluster iiopClusterBean;
            ServerContext serverContext = ApplicationServer.getServerContext();
            ConfigContext configContext = serverContext.getConfigContext();
            Server serverBean = ServerBeansFactory.getServerBean((ConfigContext)configContext);
            AvailabilityService availabilityService = serverBean.getAvailabilityService();
            if (availabilityService != null && (iiopClusterBean = availabilityService.getIiopCluster()) != null && (s1asInstances = iiopClusterBean.getIiopServerInstance()) != null) {
                endPoints = new Vector<IIOPEndPoint>(10, 5);
                for (int i = 0; i < s1asInstances.length; ++i) {
                    IiopEndpoint[] iiopEndPoints = s1asInstances[i].getIiopEndpoint();
                    for (int j = 0; j < iiopEndPoints.length; ++j) {
                        _logger.log(Level.FINE, "Obtained IIOP endpoint from Config" + iiopEndPoints[j]);
                        IiopEndpoint iiopEndpoint = iiopEndPoints[j];
                        String host = iiopEndpoint.getHost();
                        String port = iiopEndpoint.getPort();
                        String type = "IIOP_CLEAR_TEXT";
                        IIOPEndPoint endPoint = new IIOPEndPoint(InetAddress.getByName(host), Integer.parseInt(port), type);
                        endPoints.add(endPoint);
                    }
                }
            }
        }
        catch (ConfigException configExp) {
            _logger.log(Level.SEVERE, "Config error in " + INTERCEPTOR_NAME, configExp);
            endPoints = null;
        }
        catch (UnknownHostException exp) {
            _logger.log(Level.WARNING, "Host could not be resoloved", exp);
            endPoints = null;
        }
        return endPoints;
    }

    public void destroy() {
    }

    public void establish_components(IORInfo iorInfo) {
        _logger.log(Level.FINE, "EEIORINTERCEPTOR_CALLED_ESTB_COMP");
        Vector iiopEndPoints = this.getIIOPClusterEndPoints();
        if (iiopEndPoints != null) {
            this.addAlternateIIOPAddressComponents(iorInfo, iiopEndPoints);
        }
    }

    public String name() {
        return INTERCEPTOR_NAME;
    }

    private void addAlternateIIOPAddressComponents(IORInfo iorInfo, Vector iiopEndPoints) {
        try {
            _logger.log(Level.FINEST, "EEInterceptor adding alternate tags");
            _logger.log(Level.FINEST, "Number of IIOPEndpoints from config: " + iiopEndPoints.size());
            for (int i = 0; i < iiopEndPoints.size(); ++i) {
                IIOPEndPoint endpoint = (IIOPEndPoint)iiopEndPoints.get(i);
                String host = endpoint.getHostAddress();
                int port = endpoint.getPort();
                AlternateIIOPAddressComponent iiopAddress = new AlternateIIOPAddressComponent(host, this.intToShort(port));
                Any any = ORB.init().create_any();
                AlternateIIOPAddressComponentHelper.insert((Any)any, (AlternateIIOPAddressComponent)iiopAddress);
                byte[] data = this.codec.encode_value(any);
                TaggedComponent taggedComponent = new TaggedComponent(89374, data);
                iorInfo.add_ior_component(taggedComponent);
                _logger.log(Level.FINEST, "Added Alternate tag component for: " + endpoint);
            }
        }
        catch (Exception exp) {
            _logger.log(Level.WARNING, "Exception in making IORs cluster aware" + INTERCEPTOR_NAME, exp);
        }
    }

    protected short intToShort(int value) {
        if (value > Short.MAX_VALUE) {
            return (short)(value - 65536);
        }
        return (short)value;
    }

    static {
        _logger = LogDomains.getLogger((String)"javax.enterprise.resource.corba");
    }
}

