/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.ee.ejb.sfsb;

import com.iplanet.ias.web.ShutdownCleanupCapable;
import com.sun.appserv.ee.ejb.sfsb.EJBModuleStatistics;
import com.sun.ejb.spi.BaseSFSBStoreManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;

public abstract class HASFSBStoreManagerBase
extends BaseSFSBStoreManager
implements ShutdownCleanupCapable {
    protected boolean isMonitoringEnabled = false;
    protected EJBModuleStatistics ejbStatistics = null;
    private Map _connectionsMap = Collections.synchronizedMap(new WeakHashMap(50));

    public HASFSBStoreManagerBase() {
        try {
            Properties props = System.getProperties();
            String str = props.getProperty("MONITOR_EJB_CONTAINER");
            if (null != str && str.equalsIgnoreCase("TRUE")) {
                this.isMonitoringEnabled = true;
                this.ejbStatistics = new EJBModuleStatistics();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void putConnection(Connection conn) {
        _logger.log(Level.FINEST, "In HASFSBStoreManagerBase.putConnection  :" + this._connectionsMap.size());
        this._connectionsMap.put(conn, null);
    }

    public int doShutdownCleanup() {
        _logger.log(Level.FINEST, "In HASFSBStoreManagerBase.doShutdownCleanup");
        return this.closeAllConnections();
    }

    private int closeAllConnections() {
        _logger.log(Level.FINEST, "In HASFSBStoreManagerBase.closeAllConnections");
        int count = 0;
        int iterations = 0;
        Set connections = this._connectionsMap.keySet();
        Iterator it = connections.iterator();
        while (it.hasNext()) {
            _logger.log(Level.FINEST, "In HASFSBStoreManagerBase.closeAllConnections:iteration" + ++iterations);
            Connection nextConn = (Connection)it.next();
            _logger.log(Level.FINEST, "In HASFSBStoreManagerBase.nextConn=" + nextConn);
            if (nextConn == null) continue;
            try {
                nextConn.close();
                ++count;
            }
            catch (SQLException ex) {
                _logger.log(Level.WARNING, "In HASFSBStoreManagerBase.closeAllConnections: failed ");
                break;
            }
        }
        _logger.log(Level.FINEST, "In HASFSBStoreManagerBase.closeAllConnections manager closed " + count + " connections");
        return count;
    }

    public void doCloseCachedConnection() {
    }

    public EJBModuleStatistics getEJBModuleStatistics() {
        return this.ejbStatistics;
    }

    public void setEJBModuleStatistics(EJBModuleStatistics statistics) {
        this.ejbStatistics = statistics;
    }

    public boolean isMonitoringEnabled() {
        return this.isMonitoringEnabled;
    }
}

