/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.ee.ejb.sfsb;

public class EJBModuleStatistics {
    private long saveLow;
    private long saveHigh;
    private long saveAverage;
    private long totalSaves;
    private long totalSaveTime;
    private long checkpointSaveLow;
    private long checkpointSaveHigh;
    private long checkpointSaveAverage;
    private long totalCheckpointSaveTime;
    private long totalCheckpointSaves;
    private long passivateSaveLow;
    private long passivateSaveHigh;
    private long passivateSaveAverage;
    private long totalPassivateSaveTime;
    private long totalPassivateSaves;
    private long beanSizeAverage;
    private long beanSizeHigh;
    private long beanSizeLow;
    private long totalBeanSize;
    private long totalStoredBeans;
    private long executeStatementAverage;
    private long executeStatementHigh;
    private long executeStatementLow;
    private long totalExecuteStatementTime;
    private long totalExecuteStatements;
    private long getConnectionAverage;
    private long getConnectionHigh;
    private long getConnectionLow;
    private long totalGetConnectionTime;
    private long totalGetConnections;
    private long statementPrepAverage;
    private long statementPrepHigh;
    private long statementPrepLow;
    private long totalStatementPrepTime;
    private long totalStatementPreps;

    synchronized void processSave(long elapsedTime) {
        this.totalSaves = this.totalCheckpointSaves + this.totalPassivateSaves;
        this.totalSaveTime = this.totalCheckpointSaveTime + this.totalPassivateSaveTime;
        this.saveLow = this.getSaveLow();
        this.saveHigh = this.getSaveHigh();
        this.saveAverage = this.getSaveAverage();
    }

    void resetSaveStats() {
        this.totalSaves = 0L;
        this.totalSaveTime = 0L;
        this.saveAverage = 0L;
        this.saveLow = 0L;
        this.saveHigh = 0L;
    }

    long getSaveLow() {
        return Math.min(this.checkpointSaveLow, this.passivateSaveLow);
    }

    long getSaveHigh() {
        return Math.max(this.checkpointSaveHigh, this.passivateSaveHigh);
    }

    long getSaveAverage() {
        if (this.totalCheckpointSaves + this.totalPassivateSaves > 0L) {
            return (this.totalCheckpointSaveTime + this.totalPassivateSaveTime) / (this.totalCheckpointSaves + this.totalPassivateSaves);
        }
        return 0L;
    }

    synchronized void processCheckpointSave(long elapsedTime) {
        ++this.totalCheckpointSaves;
        this.totalCheckpointSaveTime += elapsedTime;
        if (this.totalCheckpointSaves > 0L) {
            this.checkpointSaveAverage = this.totalCheckpointSaveTime / this.totalCheckpointSaves;
        }
        if (this.checkpointSaveLow == 0L | elapsedTime < this.checkpointSaveLow) {
            this.checkpointSaveLow = elapsedTime;
        }
        if (elapsedTime > this.checkpointSaveHigh) {
            this.checkpointSaveHigh = elapsedTime;
        }
    }

    void resetCheckpointSaveStats() {
        this.totalCheckpointSaves = 0L;
        this.totalCheckpointSaveTime = 0L;
        this.checkpointSaveAverage = 0L;
        this.checkpointSaveLow = 0L;
        this.checkpointSaveHigh = 0L;
    }

    long getCheckpointSaveLow() {
        return this.checkpointSaveLow;
    }

    long getCheckpointSaveHigh() {
        return this.checkpointSaveHigh;
    }

    long getCheckpointSaveAverage() {
        return this.checkpointSaveAverage;
    }

    synchronized void processPassivateSave(long elapsedTime) {
        ++this.totalPassivateSaves;
        this.totalPassivateSaveTime += elapsedTime;
        if (this.totalPassivateSaves > 0L) {
            this.passivateSaveAverage = this.totalPassivateSaveTime / this.totalPassivateSaves;
        }
        if (this.passivateSaveLow == 0L | elapsedTime < this.passivateSaveLow) {
            this.passivateSaveLow = elapsedTime;
        }
        if (elapsedTime > this.passivateSaveHigh) {
            this.passivateSaveHigh = elapsedTime;
        }
    }

    void resetPassivateSaveStats() {
        this.totalPassivateSaves = 0L;
        this.totalPassivateSaveTime = 0L;
        this.passivateSaveAverage = 0L;
        this.passivateSaveLow = 0L;
        this.passivateSaveHigh = 0L;
    }

    long getPassivateSaveLow() {
        return this.passivateSaveLow;
    }

    long getPassivateSaveHigh() {
        return this.passivateSaveHigh;
    }

    long getPassivateSaveAverage() {
        return this.passivateSaveAverage;
    }

    synchronized void processBeanSize(long beanSize) {
        ++this.totalStoredBeans;
        this.totalBeanSize += beanSize;
        if (this.totalStoredBeans > 0L) {
            this.beanSizeAverage = this.totalBeanSize / this.totalStoredBeans;
        }
        if (this.beanSizeLow == 0L | beanSize < this.beanSizeLow) {
            this.beanSizeLow = beanSize;
        }
        if (beanSize > this.beanSizeHigh) {
            this.beanSizeHigh = beanSize;
        }
    }

    void resetBeanSizeStats() {
        this.totalStoredBeans = 0L;
        this.totalBeanSize = 0L;
        this.beanSizeAverage = 0L;
        this.beanSizeLow = 0L;
        this.beanSizeHigh = 0L;
    }

    long getBeanSizeLow() {
        return this.beanSizeLow;
    }

    long getBeanSizeHigh() {
        return this.beanSizeHigh;
    }

    long getBeanSizeAverage() {
        return this.beanSizeAverage;
    }

    synchronized void processExecuteStatement(long elapsedTime) {
        ++this.totalExecuteStatements;
        this.totalExecuteStatementTime += elapsedTime;
        if (this.totalExecuteStatements > 0L) {
            this.executeStatementAverage = this.totalExecuteStatementTime / this.totalExecuteStatements;
        }
        if (this.executeStatementLow == 0L | elapsedTime < this.executeStatementLow) {
            this.executeStatementLow = elapsedTime;
        }
        if (elapsedTime > this.executeStatementHigh) {
            this.executeStatementHigh = elapsedTime;
        }
    }

    void resetExecuteStatementStats() {
        this.totalExecuteStatements = 0L;
        this.totalExecuteStatementTime = 0L;
        this.executeStatementLow = 0L;
        this.executeStatementHigh = 0L;
        this.executeStatementAverage = 0L;
    }

    long getExecuteStatementLow() {
        return this.executeStatementLow;
    }

    long getExecuteStatementHigh() {
        return this.executeStatementHigh;
    }

    long getExecuteStatementAverage() {
        return this.executeStatementAverage;
    }

    synchronized void processGetConnectionFromPool(long elapsedTime) {
        ++this.totalGetConnections;
        this.totalGetConnectionTime += elapsedTime;
        if (this.totalGetConnections > 0L) {
            this.getConnectionAverage = this.totalGetConnectionTime / this.totalGetConnections;
        }
        if (this.getConnectionLow == 0L | elapsedTime < this.getConnectionLow) {
            this.getConnectionLow = elapsedTime;
        }
        if (elapsedTime > this.getConnectionHigh) {
            this.getConnectionHigh = elapsedTime;
        }
    }

    long getGetConnectionLow() {
        return this.getConnectionLow;
    }

    long getGetConnectionHigh() {
        return this.getConnectionHigh;
    }

    long getGetConnectionAverage() {
        return this.getConnectionAverage;
    }

    void resetGetConnectionStats() {
        this.totalGetConnections = 0L;
        this.totalGetConnectionTime = 0L;
        this.getConnectionLow = 0L;
        this.getConnectionHigh = 0L;
        this.getConnectionAverage = 0L;
    }

    synchronized void processStatementPrepBlock(long elapsedTime) {
        ++this.totalStatementPreps;
        this.totalStatementPrepTime += elapsedTime;
        if (this.totalStatementPreps > 0L) {
            this.statementPrepAverage = this.totalStatementPrepTime / this.totalStatementPreps;
        }
        if (this.statementPrepLow == 0L | elapsedTime < this.statementPrepLow) {
            this.statementPrepLow = elapsedTime;
        }
        if (elapsedTime > this.statementPrepHigh) {
            this.statementPrepHigh = elapsedTime;
        }
    }

    void resetStatementPrepStats() {
        this.totalStatementPreps = 0L;
        this.totalStatementPrepTime = 0L;
        this.statementPrepLow = 0L;
        this.statementPrepHigh = 0L;
        this.statementPrepAverage = 0L;
    }

    synchronized void resetStats() {
        this.resetSaveStats();
        this.resetCheckpointSaveStats();
        this.resetPassivateSaveStats();
        this.resetBeanSizeStats();
        this.resetExecuteStatementStats();
        this.resetGetConnectionStats();
        this.resetStatementPrepStats();
    }

    long getStatementPrepLow() {
        return this.statementPrepLow;
    }

    long getStatementPrepHigh() {
        return this.statementPrepHigh;
    }

    long getStatementPrepAverage() {
        return this.statementPrepAverage;
    }
}

