/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sun.appserv;

import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.sun.appserv.AppServerAdmin;

public class InstanceTask
extends AppServerAdmin {
    private String action;
    private static final String ACTION_START = "start";
    private static final String ACTION_STOP = "stop";
    private static final String ACTION_RESTART = "restart";
    private static final String ACTION_CREATE = "create";
    private static final String ACTION_DELETE = "delete";
    private static final Map ACTION_MAP = new HashMap(5);

    public void setAction(String string) {
        this.action = string;
    }

    protected AppServerAdmin.Server getNewServer() {
        return new InstanceServer(this.server);
    }

    public void setDebug(boolean bl) {
        ((InstanceServer)this.server).setDebug(bl);
    }

    public void setLocal(boolean bl) {
        ((InstanceServer)this.server).setLocal(bl);
    }

    public void setDomain(String string) {
        ((InstanceServer)this.server).setDomain(string);
    }

    public void setInstanceport(int n) {
        ((InstanceServer)this.server).setInstanceport(n);
    }

    protected void checkConfiguration() throws BuildException {
        super.checkConfiguration();
        if (this.action == null) {
            String string = "The action command must be specified.";
            throw new BuildException(string, this.getLocation());
        }
        if (!ACTION_MAP.containsKey(this.action)) {
            String string = "The action command (\"" + this.action + "\") is invalid.";
            throw new BuildException(string, this.getLocation());
        }
    }

    protected void checkConfiguration(AppServerAdmin.Server server) throws BuildException {
        String string;
        if (server.getInstance() == null) {
            String string2 = "The \"instance\" attribute was not specified and it is a required.";
            throw new BuildException(string2, this.getLocation());
        }
        InstanceServer instanceServer = (InstanceServer)server;
        if (instanceServer.isLocal() || instanceServer.getDomain() != null) {
            if (instanceServer.getHost() != null) {
                string = "The \"host\" attribute is ignored when \"local\" is set to true or \"domain\" is used.";
                this.log(string, 1);
            }
            if (instanceServer.getPort() != 0) {
                string = "The \"port\" attribute is ignored when \"local\" is set to true or \"domain\" is used.";
                this.log(string, 1);
            }
            if (instanceServer.getUser() != null && !instanceServer.getUser().equals("admin")) {
                string = "The \"user\" attribute is ignored when \"local\" is set to true or \"domain\" is used.";
                this.log(string, 1);
            }
            if (instanceServer.getPassword() != null) {
                string = "The \"password\" attribute is ignored when \"local\" is set to true or \"domain\" is used.";
                this.log(string, 1);
            }
        } else if (instanceServer.getPassword() == null) {
            String string3 = "The \"password\" attribute was not specified.  The \"password\" attribute is required unless \"local\" is set to true or \"domain\" is used.";
            throw new BuildException(string3, this.getLocation());
        }
        if (instanceServer.getDomain() != null && !instanceServer.isLocal()) {
            string = "The \"domain\" attribute may not be used when the \"local\" attribute is set to \"false.\"  The domain value will be ignored.";
            this.log(string, 1);
        }
    }

    protected void execute(AppServerAdmin.Server server) throws BuildException {
        InstanceServer instanceServer = (InstanceServer)server;
        StringBuffer stringBuffer = new StringBuffer((String)ACTION_MAP.get(this.action));
        if (this.action.equals(ACTION_CREATE)) {
            stringBuffer.append(" --instanceport " + instanceServer.getInstanceport());
        } else if (this.action.equals(ACTION_START)) {
            stringBuffer.append(" --debug=" + instanceServer.isDebug());
        }
        if (instanceServer.isLocal()) {
            if (instanceServer.getDomain() != null) {
                stringBuffer.append(" --domain ").append(instanceServer.getDomain());
            }
            stringBuffer.append(" --local=true");
        } else {
            stringBuffer.append(instanceServer.getCommandParameters(false));
        }
        stringBuffer.append(' ').append(instanceServer.getInstance());
        this.execAdminCommand(stringBuffer.toString());
    }

    static {
        ACTION_MAP.put(ACTION_START, "start-instance");
        ACTION_MAP.put(ACTION_STOP, "stop-instance");
        ACTION_MAP.put(ACTION_RESTART, "restart-instance");
        ACTION_MAP.put(ACTION_CREATE, "create-instance");
        ACTION_MAP.put(ACTION_DELETE, "delete-instance");
    }

    public class InstanceServer
    extends AppServerAdmin.Server {
        private boolean debug;
        private boolean local;
        private String domain;
        private int instanceport;
        private boolean debugIsSet;
        private boolean localIsSet;
        private static final boolean DEFAULT_DEBUG = false;
        private static final boolean DEFAULT_LOCAL = false;

        public InstanceServer() {
            this(null);
        }

        public InstanceServer(AppServerAdmin.Server server) {
            super(server);
            this.debugIsSet = false;
            this.localIsSet = false;
        }

        public void setDebug(boolean bl) {
            this.debug = bl;
            this.debugIsSet = true;
        }

        protected boolean isDebug() {
            InstanceServer instanceServer = (InstanceServer)this.getParent();
            if (!this.debugIsSet) {
                return instanceServer == null ? false : instanceServer.isDebug();
            }
            return this.debug;
        }

        public void setLocal(boolean bl) {
            this.local = bl;
            this.localIsSet = true;
        }

        protected boolean isLocal() {
            InstanceServer instanceServer = (InstanceServer)this.getParent();
            if (!this.localIsSet) {
                return instanceServer == null ? false : instanceServer.isLocal();
            }
            return this.local;
        }

        public void setDomain(String string) {
            this.domain = string;
        }

        protected String getDomain() {
            InstanceServer instanceServer = (InstanceServer)this.getParent();
            if (this.domain == null) {
                return instanceServer == null ? null : instanceServer.getDomain();
            }
            return this.domain;
        }

        public void setInstanceport(int n) {
            this.instanceport = n;
        }

        protected int getInstanceport() {
            InstanceServer instanceServer = (InstanceServer)this.getParent();
            if (this.instanceport == 0 && instanceServer != null) {
                return instanceServer.getInstanceport();
            }
            return this.instanceport;
        }
    }
}

