/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sun.appserv;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.sun.appserv.AppServerAdmin;
import org.apache.tools.ant.taskdefs.optional.sun.appserv.ComponentAdmin;

public class DeployTask
extends ComponentAdmin {
    private static final String DEPLOY_COMMAND = "deploy";
    private static final String DEPLOY_DIR_COMMAND = "deploydir";

    protected AppServerAdmin.Server getNewServer() {
        return new DeployServer(this.server);
    }

    protected ComponentAdmin.Component getNewComponent() {
        return new DeployComponent(this.component);
    }

    public void setUpload(boolean bl) {
        ((DeployServer)this.server).setUpload(bl);
    }

    public void setVirtualServers(String string) {
        ((DeployServer)this.server).setVirtualServers(string);
    }

    public void setForce(boolean bl) {
        ((DeployComponent)this.component).setForce(bl);
    }

    public void setRetrieveStubs(File file) {
        ((DeployComponent)this.component).setRetrieveStubs(file);
    }

    public void setContextroot(String string) {
        ((DeployComponent)this.component).setContextroot(string);
    }

    public void setPrecompileJsp(boolean bl) {
        ((DeployComponent)this.component).setPrecompileJsp(bl);
    }

    public void setVerify(boolean bl) {
        ((DeployComponent)this.component).setVerify(bl);
    }

    public AppServerAdmin.Server createServer() {
        this.log("createServer using DeployServer object", 4);
        DeployServer deployServer = new DeployServer(this.server);
        this.servers.add(deployServer);
        return deployServer;
    }

    protected void checkComponentConfig(AppServerAdmin.Server server, ComponentAdmin.Component component) throws BuildException {
        String string;
        String string2;
        this.log("Checking component and server config in DeployTask", 4);
        DeployServer deployServer = (DeployServer)server;
        DeployComponent deployComponent = (DeployComponent)component;
        File file = component.getFile();
        if (file == null) {
            String string3 = "A component file must be specified in the " + this.getTaskName() + " element, specified in each \"" + "component\" subelement, or found using the \"" + "fileset\" subelement.";
            throw new BuildException(string3, this.getLocation());
        }
        super.checkComponentConfig(server, component);
        if (file.isDirectory() && deployServer.getUpload()) {
            String string4 = server.getHost();
            if (string4 == null) {
                string4 = "localhost";
            }
            String string5 = "The \"upload\" attribute may not be set to \"true\" when a directory is being deployed.  The directory \"" + file.getAbsolutePath() + "\" " + "may not be uploaded to the \"" + string4 + "\" server.";
            throw new BuildException(string5, this.getLocation());
        }
        File file2 = deployComponent.getRetrieveStubs();
        if (file2 != null) {
            if (!file2.exists()) {
                String string6 = "The \"retrievestubs\" directory (" + file2 + ") does not exist.";
                throw new BuildException(string6, this.getLocation());
            }
            if (!file2.isDirectory()) {
                String string7 = "The \"retrievestubs\" attribute (" + file2 + ") does not refer to a directory.";
                throw new BuildException(string7, this.getLocation());
            }
        }
        if ((string2 = component.getType()) != null && !string2.equals("web") && deployComponent.contextRootIsSet()) {
            string = "The \"contextroot\" attribute doesn't apply to " + component.getType() + " files -- it only applies to war files.";
            this.log(string, 1);
        }
        if (string2 != null && !string2.equals("application") && !string2.equals("web")) {
            if (deployComponent.isPrecompileJsp()) {
                string = "The \"precompilejsp\" attribute doesn't apply to " + component.getType() + " components -- it only applies " + "to WAR or EAR components.  It will be ignored.";
                this.log(string, 1);
            }
            if (deployServer.getVirtualServers() != null) {
                string = "The \"virtualservers\" attribute doesn't apply to " + component.getType() + " components -- it only applies " + "to WAR or EAR components.  It will be ignored.";
                this.log(string, 1);
            }
        }
    }

    protected String getCommandString(AppServerAdmin.Server server, ComponentAdmin.Component component) {
        DeployServer deployServer = (DeployServer)server;
        DeployComponent deployComponent = (DeployComponent)component;
        boolean bl = component.getFile().isFile();
        StringBuffer stringBuffer = new StringBuffer(bl ? DEPLOY_COMMAND : DEPLOY_DIR_COMMAND);
        stringBuffer.append(server.getCommandParameters(true));
        if (component.getType() != null) {
            stringBuffer.append(" --type ").append(component.getType());
            if (component.getType().equals("application") || component.getType().equals("web")) {
                stringBuffer.append(" --precompilejsp=");
                stringBuffer.append(deployComponent.isPrecompileJsp());
                if (deployServer.getVirtualServers() != null) {
                    stringBuffer.append(" --virtualservers ");
                    stringBuffer.append(deployServer.getVirtualServers());
                }
                if (component.getType().equals("web")) {
                    stringBuffer.append(" --contextroot ").append(deployComponent.getContextroot());
                }
            }
        }
        stringBuffer.append(" --force=").append(deployComponent.isForce());
        stringBuffer.append(" --name ").append(component.getName());
        stringBuffer.append(" --verify=").append(deployComponent.isVerify());
        if (bl) {
            stringBuffer.append(" --upload=").append(deployServer.getUpload());
        }
        if (deployComponent.getRetrieveStubs() != null) {
            stringBuffer.append(" --retrieve ");
            stringBuffer.append(deployComponent.getRetrieveStubs());
        }
        stringBuffer.append(" ").append(component.getFile().getPath());
        return stringBuffer.toString();
    }

    public class DeployComponent
    extends ComponentAdmin.Component {
        private boolean force;
        private boolean precompile;
        private File stubsDir;
        private String contextroot;
        private boolean verify;
        private boolean forceIsSet;
        private boolean precompileIsSet;
        private boolean verifyIsSet;
        private static final boolean DEFAULT_FORCE = true;
        private static final boolean DEFAULT_PRECOMPILE = false;
        private static final boolean DEFAULT_VERIFY = false;

        public DeployComponent(ComponentAdmin.Component component) {
            super(component);
            this.forceIsSet = false;
            this.precompileIsSet = false;
            this.verifyIsSet = false;
        }

        public void setForce(boolean bl) {
            this.force = bl;
            this.forceIsSet = true;
        }

        protected boolean isForce() {
            if (!this.forceIsSet) {
                return this.parent == null ? true : ((DeployComponent)this.parent).isForce();
            }
            return this.force;
        }

        public void setRetrieveStubs(File file) {
            this.stubsDir = file;
        }

        protected File getRetrieveStubs() {
            if (this.stubsDir == null) {
                return this.parent == null ? null : ((DeployComponent)this.parent).getRetrieveStubs();
            }
            return this.stubsDir;
        }

        public void setContextroot(String string) {
            this.contextroot = string;
        }

        protected String getContextroot() {
            return this.contextroot != null ? this.contextroot : this.getName();
        }

        protected boolean contextRootIsSet() {
            return this.contextroot != null;
        }

        public void setPrecompileJsp(boolean bl) {
            this.precompile = bl;
            this.precompileIsSet = true;
        }

        protected boolean isPrecompileJsp() {
            if (!this.precompileIsSet) {
                return this.parent == null ? false : ((DeployComponent)this.parent).isPrecompileJsp();
            }
            return this.precompile;
        }

        public void setVerify(boolean bl) {
            this.verify = bl;
            this.verifyIsSet = true;
        }

        protected boolean isVerify() {
            if (!this.verifyIsSet) {
                return this.parent == null ? false : ((DeployComponent)this.parent).isVerify();
            }
            return this.verify;
        }
    }

    public class DeployServer
    extends AppServerAdmin.Server {
        private boolean upload;
        private String virtualServers;
        private boolean uploadIsSet;
        private static final boolean DEFAULT_UPLOAD = true;

        public DeployServer() {
            this(null);
        }

        public DeployServer(AppServerAdmin.Server server) {
            super(server);
            this.uploadIsSet = false;
        }

        public void setUpload(boolean bl) {
            this.upload = bl;
            this.uploadIsSet = true;
        }

        protected boolean getUpload() {
            DeployServer deployServer = (DeployServer)this.getParent();
            if (!this.uploadIsSet) {
                return deployServer == null ? true : deployServer.getUpload();
            }
            return this.upload;
        }

        public void setVirtualServers(String string) {
            this.virtualServers = string;
        }

        public String getVirtualServers() {
            return this.virtualServers;
        }
    }
}

