/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sun.appserv;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.optional.sun.appserv.AppServerAdmin;
import org.apache.tools.ant.types.FileSet;

public abstract class ComponentAdmin
extends AppServerAdmin {
    protected Component component;
    protected List components = new ArrayList();
    private List filesets = new ArrayList();
    protected static final String TYPE_APP = "application";
    protected static final String TYPE_EJB = "ejb";
    protected static final String TYPE_WEB = "web";
    protected static final String TYPE_CONN = "connector";
    protected static final String TYPE_CLIENT = "client";
    protected static final Map TYPE_MAP = new HashMap(4);

    public ComponentAdmin() {
        this.component = this.getNewComponent();
    }

    protected Component getNewComponent() {
        return new Component(this.component);
    }

    public void setFile(File file) {
        this.component.setFile(file);
    }

    public void setName(String string) {
        this.component.setName(string);
    }

    public void setType(String string) {
        this.component.setType(string);
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.add(fileSet);
    }

    public Component createComponent() {
        Component component = this.getNewComponent();
        this.components.add(component);
        return component;
    }

    protected void prepareToExecute() throws BuildException {
        super.prepareToExecute();
        this.processFilesets();
        if (this.components.size() == 0) {
            this.components.add(this.component);
        }
    }

    protected void execute(AppServerAdmin.Server server) throws BuildException {
        Iterator iterator = this.components.iterator();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            String string = this.getCommandString(server, component);
            this.execAdminCommand(string);
        }
    }

    private void processFilesets() {
        for (int i = 0; i < this.filesets.size(); ++i) {
            FileSet fileSet = (FileSet)this.filesets.get(i);
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.project);
            File file = directoryScanner.getBasedir();
            String[] stringArray = directoryScanner.getIncludedFiles();
            for (int j = 0; j < stringArray.length; ++j) {
                Component component = this.getNewComponent();
                component.setFile(new File(file, stringArray[j]));
                this.components.add(component);
            }
            String[] stringArray2 = directoryScanner.getIncludedDirectories();
            for (int j = 0; j < stringArray2.length; ++j) {
                Component component = this.getNewComponent();
                component.setFile(new File(file, stringArray2[j]));
                this.components.add(component);
            }
        }
    }

    protected void checkConfiguration() throws BuildException {
        super.checkConfiguration();
        this.log(this.components.size() + " components were found.", 4);
        if (this.components.size() == 0) {
            this.log("WARNING!  No components were specified.", 1);
        }
    }

    protected void checkConfiguration(AppServerAdmin.Server server) throws BuildException {
        String string = server.getHost();
        if (string == null) {
            string = "localhost";
        }
        this.log("Checking server config for " + string, 4);
        if (server.getPassword() == null) {
            String string2 = "A password must be specified in the " + this.getTaskName() + " element or in each \"server\" subelement.  A " + "password for host \"" + string + "\" was not " + "specified.";
            throw new BuildException(string2, this.getLocation());
        }
        Iterator iterator = this.components.iterator();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            this.checkComponentConfig(server, component);
        }
    }

    protected void checkComponentConfig(AppServerAdmin.Server server, Component component) {
        this.log("Checking config for server \"" + server + "\" and component \"" + component + "\"", 4);
        File file = component.getFile();
        this.log("The file for this component: " + file, 4);
        if (file != null && !file.exists()) {
            String string = "The file specified (" + file + ") could not be found.";
            throw new BuildException(string, this.getLocation());
        }
        String string = component.getName();
        if (string == null || string.length() == 0) {
            String string2 = "A valid name for the component could not be determined.";
            throw new BuildException(string2, this.getLocation());
        }
        String string3 = component.getType();
        if (string3 != null && !TYPE_MAP.values().contains(string3)) {
            String string4 = "The type specified (" + string3 + ") is not valid.";
            throw new BuildException(string4, this.getLocation());
        }
    }

    protected abstract String getCommandString(AppServerAdmin.Server var1, Component var2);

    static {
        TYPE_MAP.put("ear", TYPE_APP);
        TYPE_MAP.put("jar", TYPE_EJB);
        TYPE_MAP.put("war", TYPE_WEB);
        TYPE_MAP.put("rar", TYPE_CONN);
    }

    public class Component {
        protected Component parent;
        private File file;
        private String name;
        private String type;
        private static final String DEFAULT_TYPE = "application";

        public Component() {
            this(null);
        }

        public Component(Component component) {
            this.parent = component;
        }

        public void setParent(Component component) {
            this.parent = component;
        }

        public void setFile(File file) {
            this.file = file;
        }

        protected File getFile() {
            return this.file;
        }

        public void setName(String string) {
            this.name = string;
        }

        protected String getName() {
            if (this.name == null) {
                String string = null;
                if (this.file == null) {
                    return null;
                }
                string = this.file.getName();
                int n = string.indexOf(46);
                this.name = n < 0 ? string : string.substring(0, n);
            }
            return this.name;
        }

        public void setType(String string) {
            this.type = string;
        }

        protected String getType() {
            if (this.type == null) {
                String string = null;
                String string2 = null;
                if (this.file != null) {
                    string = this.file.getName();
                    int n = string.lastIndexOf(46);
                    if (n >= 0) {
                        string2 = string.substring(n + 1);
                    }
                    this.type = (String)TYPE_MAP.get(string2);
                }
            }
            if (this.type == null) {
                return this.parent == null ? null : this.parent.getType();
            }
            return this.type;
        }

        public String toString() {
            return this.getName();
        }
    }
}

