/*
 * Decompiled with CFR 0.152.
 */
package samples.connectors.simple;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import samples.connectors.simple.CometConnectionFactory;
import samples.connectors.simple.CometManagedConnection;
import samples.connectors.simple.Debug;
import samples.connectors.simple.Messages;
import samples.connectors.simple.Util;

public class CometManagedConnectionFactory
implements ManagedConnectionFactory,
Serializable {
    private transient PrintWriter out;
    private transient PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private String host = null;
    private String port = null;

    public CometManagedConnectionFactory() {
        System.out.println(" 1. In CometManagedConnectionFactory ctor");
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes.addPropertyChangeListener(l);
    }

    public Object createConnectionFactory() throws ResourceException {
        System.out.println("createConnectionFactory 2 ");
        return new CometConnectionFactory(this, null);
    }

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        System.out.println("createConnectionFactory 1 this" + this);
        CometConnectionFactory cf = null;
        try {
            cf = new CometConnectionFactory(this, cxManager);
        }
        catch (Exception e) {
            throw new ResourceException(e.getMessage());
        }
        return cf;
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        System.out.println(" -- In CometManagedConnectionFactory:: createManagedConnection");
        String userName = null;
        CometManagedConnection gmc = null;
        PasswordCredential pc = Util.getPasswordCredential(this, subject, cxRequestInfo);
        if (pc != null) {
            userName = pc.getUserName();
        }
        if (!(gmc = new CometManagedConnection(this, userName)).connect(this.host, this.port)) {
            System.out.println(" -- Connect to backend FAIL !!!");
            Object[] args = new Object[]{this.host, this.port};
            throw new ResourceException(MessageFormat.format(Messages.getMessage("10"), args), "10");
        }
        return gmc;
    }

    public boolean equals(Object other) {
        boolean equal = false;
        if (other != null && other instanceof CometManagedConnectionFactory) {
            String host1 = ((CometManagedConnectionFactory)other).host;
            String host2 = this.host;
            String port1 = ((CometManagedConnectionFactory)other).port;
            String port2 = this.port;
            equal = Util.isEqual(host1, host2) && Util.isEqual(port1, port2);
        }
        return equal;
    }

    public String getHost() {
        return this.host;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.out;
    }

    public String getPort() {
        return this.port;
    }

    public int hashCode() {
        int hashcode = 0;
        if (this.host != null && this.port != null) {
            hashcode = this.host.hashCode() + this.port.hashCode();
        }
        return hashcode;
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        PasswordCredential pc = Util.getPasswordCredential(this, subject, cxRequestInfo);
        String userName = null;
        if (pc != null) {
            userName = pc.getUserName();
        }
        Iterator it = connectionSet.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof CometManagedConnection)) continue;
            CometManagedConnection mc = (CometManagedConnection)obj;
            ManagedConnectionFactory mcf = mc.getManagedConnectionFactory();
            if (!Util.isEqual(mc.getUserName(), userName) || !mcf.equals((Object)this)) continue;
            Debug.printDebug("In matchManagedConnections mc=" + mc);
            return mc;
        }
        return null;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        System.out.println("Before readObject mcf");
        in.defaultReadObject();
        this.changes = new PropertyChangeSupport(this);
        this.out = null;
        System.out.println("after readObject mcf");
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes.removePropertyChangeListener(l);
    }

    public void setHost(String host) {
        String oldName = this.host;
        this.host = host;
        this.changes.firePropertyChange("host", oldName, host);
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.out = out;
    }

    public void setPort(String port) {
        String oldName = this.port;
        this.port = port;
        this.changes.firePropertyChange("port", oldName, port);
    }
}

