/*
 * Decompiled with CFR 0.152.
 */
package samples.connectors.simple;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import samples.connectors.simple.CometConnection;
import samples.connectors.simple.CometConnectionEventListener;
import samples.connectors.simple.CometManagedConnectionMetaData;
import samples.connectors.simple.Messages;
import samples.connectors.simple.Util;

public class CometManagedConnection
implements ManagedConnection {
    private String user;
    private ManagedConnectionFactory mcf;
    private CometConnectionEventListener CometListener;
    private Set connectionSet;
    private PrintWriter logWriter;
    private boolean destroyed;
    private static int testCounter = 0;
    private Socket backendSocket = null;
    private OutputStream outStream = null;
    private ObjectOutputStream objOutputStream = null;
    private InputStream inStream = null;
    private ObjectInputStream objInputStream = null;

    CometManagedConnection(ManagedConnectionFactory mcf, String user) {
        System.out.println(" 4. In CometManagedConnection ctor " + testCounter++);
        this.mcf = mcf;
        this.user = user;
        this.connectionSet = new HashSet();
        this.CometListener = new CometConnectionEventListener(this);
    }

    public void addCometConnection(CometConnection CometCon) {
        this.connectionSet.add(CometCon);
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.CometListener.addConnectorListener(listener);
    }

    public void associateConnection(Object connection) throws ResourceException {
        this.checkIfDestroyed();
        if (!(connection instanceof CometConnection)) {
            throw new IllegalStateException(Messages.getMessage("3"), "3");
        }
        CometConnection CometCon = (CometConnection)connection;
        CometCon.associateConnection(this);
    }

    private void checkIfDestroyed() throws ResourceException {
        if (this.destroyed) {
            throw new IllegalStateException(Messages.getMessage("4"), "4");
        }
    }

    public void cleanup() throws ResourceException {
        this.checkIfDestroyed();
        Iterator it = this.connectionSet.iterator();
        while (it.hasNext()) {
            CometConnection CometCon = (CometConnection)it.next();
            CometCon.invalidate();
        }
        this.connectionSet.clear();
    }

    public boolean connect(String host, String port) {
        try {
            System.out.println(" -- In CometManagedConnection:: connect (" + testCounter + ") " + host + ":" + port);
            this.backendSocket = new Socket(InetAddress.getByName(host), Integer.parseInt(port));
            this.outStream = this.backendSocket.getOutputStream();
            this.objOutputStream = new ObjectOutputStream(this.outStream);
            this.inStream = this.backendSocket.getInputStream();
            this.objInputStream = new ObjectInputStream(this.inStream);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void destroy() throws ResourceException {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        --testCounter;
        try {
            this.objInputStream.close();
            this.objOutputStream.close();
            this.backendSocket.close();
        }
        catch (Exception exception) {}
        Iterator it = this.connectionSet.iterator();
        while (it.hasNext()) {
            CometConnection CometCon = (CometConnection)it.next();
            CometCon.invalidate();
        }
        this.connectionSet.clear();
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        PasswordCredential pc = Util.getPasswordCredential(this.mcf, subject, cxRequestInfo);
        if (pc == null ? this.user != null : !pc.getUserName().equals(this.user)) {
            throw new SecurityException(Messages.getMessage("7"), "7");
        }
        this.checkIfDestroyed();
        CometConnection CometCon = new CometConnection(this);
        this.addCometConnection(CometCon);
        return CometCon;
    }

    public Object getData() throws ResourceException {
        Object obj = null;
        try {
            obj = this.objInputStream.readObject();
        }
        catch (Exception exception) {
            System.out.println(" -- Get data FAILED !!!");
            throw new ResourceException(Messages.getMessage("11"), "11");
        }
        return obj;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new NotSupportedException(Messages.getMessage("1"), "1");
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public ManagedConnectionFactory getManagedConnectionFactory() {
        return this.mcf;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        this.checkIfDestroyed();
        return new CometManagedConnectionMetaData(this);
    }

    public String getUserName() {
        return this.user;
    }

    public XAResource getXAResource() throws ResourceException {
        throw new NotSupportedException(Messages.getMessage("8"), "8");
    }

    boolean isDestroyed() {
        return this.destroyed;
    }

    public void removeCometConnection(CometConnection CometCon) {
        this.connectionSet.remove(CometCon);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.CometListener.removeConnectorListener(listener);
    }

    public void sendData(Object obj) throws ResourceException {
        try {
            this.objOutputStream.writeObject(obj);
            this.objOutputStream.flush();
        }
        catch (Exception exception) {
            System.out.println(" -- Send data FAILED !!!");
            throw new ResourceException(Messages.getMessage("11"), "11");
        }
    }

    public void sendEvent(int eventType, Exception ex) {
        this.CometListener.sendEvent(eventType, ex, null);
    }

    public void sendEvent(int eventType, Exception ex, Object connectionHandle) {
        this.CometListener.sendEvent(eventType, ex, connectionHandle);
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.logWriter = out;
    }
}

