/*
 * Decompiled with CFR 0.152.
 */
package samples.connectors.simple;

import java.io.PrintWriter;
import java.io.Serializable;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceAdapterMetaData;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import samples.connectors.simple.CometConnectionManager;
import samples.connectors.simple.CometConnectionRequestInfo;
import samples.connectors.simple.CometConnectionSpec;
import samples.connectors.simple.CometRecordFactory;
import samples.connectors.simple.CometResourceAdapterMetaData;

public class CometConnectionFactory
implements ConnectionFactory,
Serializable,
Referenceable {
    private ManagedConnectionFactory mcf;
    private ConnectionManager cm;
    private Reference reference;
    private transient PrintWriter out;
    private transient int milliseconds;

    public CometConnectionFactory() {
    }

    public CometConnectionFactory(ManagedConnectionFactory mcf, ConnectionManager cm) {
        System.out.println(" 2. In CometConnectionFactory ctor, mcf=" + mcf + " cm=" + cm);
        this.mcf = mcf;
        this.cm = cm == null ? new CometConnectionManager() : cm;
    }

    public Connection getConnection() throws ResourceException {
        Connection con = null;
        System.out.println("In getConnection---before allocateConnection");
        con = (Connection)this.cm.allocateConnection(this.mcf, null);
        System.out.println("In getConnection---after allocateConnection");
        return con;
    }

    public Connection getConnection(ConnectionSpec properties) throws ResourceException {
        Connection con = null;
        CometConnectionRequestInfo info = new CometConnectionRequestInfo(((CometConnectionSpec)properties).getUser(), ((CometConnectionSpec)properties).getPassword());
        con = (Connection)this.cm.allocateConnection(this.mcf, (ConnectionRequestInfo)info);
        return con;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.out;
    }

    public ResourceAdapterMetaData getMetaData() throws ResourceException {
        return new CometResourceAdapterMetaData();
    }

    public RecordFactory getRecordFactory() throws ResourceException {
        return new CometRecordFactory();
    }

    public Reference getReference() {
        System.out.println("In CometConnectionFactory::getReference");
        return this.reference;
    }

    public int getTimeout() throws ResourceException {
        return this.milliseconds;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.out = out;
    }

    public void setReference(Reference reference) {
        System.out.println("In CometConnectionFactory::setReference");
        this.reference = reference;
    }

    public void setTimeout(int milliseconds) throws ResourceException {
        this.milliseconds = milliseconds;
    }
}

