/*
 * Decompiled with CFR 0.152.
 */
package samples.jms.soaptojms;

import com.sun.messaging.TopicConnectionFactory;
import com.sun.messaging.xml.MessageTransformer;
import java.net.URL;
import javax.activation.DataHandler;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;

public class SendSOAPMessageWithJMS {
    TopicConnectionFactory tcf = null;
    TopicConnection tc = null;
    TopicSession session = null;
    Topic topic = null;
    TopicPublisher publisher = null;

    public SendSOAPMessageWithJMS(String string) {
        this.init(string);
    }

    public void init(String string) {
        try {
            this.tcf = new TopicConnectionFactory();
            this.tc = this.tcf.createTopicConnection();
            this.session = this.tc.createTopicSession(false, 1);
            this.topic = this.session.createTopic(string);
            this.publisher = this.session.createPublisher(this.topic);
        }
        catch (JMSException jMSException) {
            jMSException.printStackTrace();
        }
    }

    public void send() throws Exception {
        MessageFactory messageFactory = MessageFactory.newInstance();
        System.out.println("Create a SOAP message");
        SOAPMessage sOAPMessage = messageFactory.createMessage();
        SOAPPart sOAPPart = sOAPMessage.getSOAPPart();
        SOAPEnvelope sOAPEnvelope = sOAPPart.getEnvelope();
        SOAPBody sOAPBody = sOAPEnvelope.getBody();
        Name name = sOAPEnvelope.createName("HelloWorld", "hw", "http://www.sun.com/imq");
        SOAPElement sOAPElement = sOAPBody.addChildElement(name);
        sOAPElement.addTextNode("Welcome to Sun Java (tm) System Web Services.");
        System.out.println("Attach http://java.sun.com/webservices web site to the message");
        URL uRL = new URL("http://java.sun.com/webservices/");
        DataHandler dataHandler = new DataHandler(uRL);
        AttachmentPart attachmentPart = sOAPMessage.createAttachmentPart(dataHandler);
        attachmentPart.setContentType("text/html");
        attachmentPart.setContentId("cid-001");
        sOAPMessage.addAttachmentPart(attachmentPart);
        sOAPMessage.saveChanges();
        System.out.println("Convert the message to JMS message");
        Message message = MessageTransformer.SOAPMessageIntoJMSMessage((SOAPMessage)sOAPMessage, (Session)this.session);
        System.out.println("Publish the message.");
        this.publisher.publish(message);
    }

    public void close() throws JMSException {
        this.tc.close();
    }

    public static void main(String[] stringArray) {
        String string = "TestTopic";
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        try {
            SendSOAPMessageWithJMS sendSOAPMessageWithJMS = new SendSOAPMessageWithJMS(string);
            sendSOAPMessageWithJMS.send();
            sendSOAPMessageWithJMS.close();
            System.out.println("Finished");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

