/*
 * Decompiled with CFR 0.152.
 */
package samples.jms.soaptojms;

import com.sun.messaging.TopicConnectionFactory;
import com.sun.messaging.xml.MessageTransformer;
import java.util.Iterator;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPMessage;

public class ReceiveSOAPMessageWithJMS
implements MessageListener {
    TopicConnectionFactory tcf = null;
    TopicConnection tc = null;
    TopicSession session = null;
    Topic topic = null;
    TopicSubscriber subscriber = null;
    MessageFactory messageFactory = null;

    public ReceiveSOAPMessageWithJMS(String string) {
        this.init(string);
    }

    public void init(String string) {
        try {
            this.messageFactory = MessageFactory.newInstance();
            this.tcf = new TopicConnectionFactory();
            this.tc = this.tcf.createTopicConnection();
            this.session = this.tc.createTopicSession(false, 1);
            this.topic = this.session.createTopic(string);
            this.subscriber = this.session.createSubscriber(this.topic);
            this.subscriber.setMessageListener((MessageListener)this);
            this.tc.start();
            System.out.println("Ready to receive SOAP messages ...");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onMessage(Message message) {
        try {
            System.out.println("Message received! Converting the JMS message to SOAP message");
            SOAPMessage sOAPMessage = MessageTransformer.SOAPMessageFromJMSMessage((Message)message, (MessageFactory)this.messageFactory);
            System.out.println("Attachment counts: " + sOAPMessage.countAttachments());
            Iterator iterator = sOAPMessage.getAttachments();
            while (iterator.hasNext()) {
                AttachmentPart attachmentPart = (AttachmentPart)iterator.next();
                String string = attachmentPart.getContentType();
                System.out.println("Content type: " + string);
                String string2 = attachmentPart.getContentId();
                System.out.println("Content Id: " + string2);
                if (string.indexOf("text") < 0) continue;
                String string3 = (String)attachmentPart.getContent();
                System.out.println("Attachment content:\n\n" + string3);
                System.out.println("*** attachment content ends ***");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        String string = "TestTopic";
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        try {
            ReceiveSOAPMessageWithJMS receiveSOAPMessageWithJMS = new ReceiveSOAPMessageWithJMS(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

