/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util;

import com.iplanet.ias.util.Assertion;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class StringUtils {
    private StringUtils() {
    }

    public static int safeLength(String string) {
        if (string == null) {
            return 0;
        }
        return string.length();
    }

    public static boolean ok(String string) {
        return string != null && string.length() > 0;
    }

    public static String formatSQLException(SQLException sQLException) {
        Assertion.check((Object)sQLException);
        String string = "SQLException:\n";
        do {
            string = string + "SQLState: " + sQLException.getSQLState() + "\n";
            string = string + "Message:  " + sQLException.getMessage() + "\n";
            string = string + "Vendor:   " + sQLException.getErrorCode() + "\n";
            string = string + "\n";
        } while ((sQLException = sQLException.getNextException()) != null);
        return string;
    }

    public static int maxWidth(Vector vector) {
        int n = 0;
        if (vector == null || vector.size() <= 0 || !(vector.elementAt(0) instanceof String)) {
            return 0;
        }
        for (int i = vector.size() - 1; i >= 0; --i) {
            int n2 = ((String)vector.elementAt(i)).length();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public static boolean isHex(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (StringUtils.isHex(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isHex(char c) {
        String string = "0123456789abcdefABCDEF";
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) != c) continue;
            return true;
        }
        return false;
    }

    public static String getPenultimateDirName(String string) {
        if (string == null || string.length() <= 0) {
            return string;
        }
        if (string.indexOf(47) < 0 && string.indexOf(92) < 0) {
            return "";
        }
        int n = (string = string.replace('\\', '/')).lastIndexOf(47);
        if (n < 0) {
            return "";
        }
        if ((n = (string = string.substring(0, n)).lastIndexOf(47)) >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static String toShortClassName(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0 && n < string.length() - 1) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static String padRight(String string, int n) {
        if (string == null || string.length() >= n) {
            return string;
        }
        for (int i = n - string.length(); i > 0; --i) {
            string = string + ' ';
        }
        return string;
    }

    public static String padLeft(String string, int n) {
        String string2 = "";
        if (string == null || string.length() >= n) {
            return string;
        }
        for (int i = n - string.length(); i > 0; --i) {
            string2 = string2 + ' ';
        }
        return string2 + string;
    }

    public static String[] toLines(String string) {
        if (string == null) {
            return new String[0];
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        int n2 = 0;
        n2 = string.indexOf(10, n);
        while (n2 >= 0 && n < string.length()) {
            vector.addElement(string.substring(n, n2));
            n = n2 + 1;
            n2 = string.indexOf(10, n);
        }
        if (n < string.length()) {
            vector.addElement(string.substring(n));
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static void prepend(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = string + stringArray[i];
        }
    }

    public static String UpperCaseFirstLetter(String string) {
        if (string == null || string.length() <= 0) {
            return string;
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static String replace(String string, String string2, String string3) {
        if (string == null || string.length() <= 0 || string2 == null || string2.length() <= 0) {
            return string;
        }
        int n = string.indexOf(string2);
        if (n < 0) {
            return string;
        }
        int n2 = string2.length();
        String string4 = string.substring(0, n);
        string4 = string4 + string3;
        string4 = string4 + string.substring(n + n2);
        return string4;
    }

    public static String toString(Properties properties) {
        String string;
        Map.Entry<Object, Object> entry;
        if (properties == null || properties.size() <= 0) {
            return "No entries";
        }
        Set<Map.Entry<Object, Object>> set = properties.entrySet();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        Iterator<Map.Entry<Object, Object>> iterator = set.iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            string = (String)entry.getKey();
            int n2 = string.length();
            if (n2 <= n) continue;
            n = n2;
        }
        ++n;
        iterator = set.iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            stringBuffer.append(StringUtils.padRight(string, n));
            stringBuffer.append("= ");
            stringBuffer.append(string2);
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        int n = stringArray.length;
        if (n == 1 && stringArray[0].equalsIgnoreCase("toLine")) {
            StringUtils.testToLine();
        } else if (n > 1 && stringArray[0].equalsIgnoreCase("isHex")) {
            StringUtils.testHex(stringArray);
        } else {
            StringUtils.usage();
        }
    }

    private static void usage() {
        System.out.println("StringUtils -- main() for testing usage:\n");
        System.out.println("java netscape.blizzard.util.StringUtils toLine");
        System.out.println("java netscape.blizzard.util.StringUtils isHex number1 number2 ...");
    }

    private static void testHex(String[] stringArray) {
        System.out.println("StringUtils -- Testing Hex");
        for (int i = 1; i < stringArray.length; ++i) {
            System.out.println(StringUtils.padRight(stringArray[i], 16) + "  " + (StringUtils.isHex(stringArray[i]) ? "yesHex" : "notHex"));
        }
    }

    private static void testToLine() {
        System.out.println("StringUtils -- Testing toLine()");
        String[] stringArray = new String[]{null, "", "abc\ndef\n", "abc\ndef", "abc", "abc\n", "abc\n\n", "q", "\n\nk\n\nz\n\n", "sd.adj;ld"};
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = StringUtils.toLines(stringArray[i]);
            System.out.println("String #" + i + ", Number of Lines:  " + stringArray2.length);
            for (int j = 0; j < stringArray2.length; ++j) {
                System.out.println(stringArray2[j]);
            }
        }
    }

    public static void testUpperCase() {
        String[] stringArray = new String[]{"xyz", "HITHERE", "123aa", "aSSS", "yothere"};
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println(stringArray[i] + " >>> " + StringUtils.UpperCaseFirstLetter(stringArray[i]));
        }
    }

    public static String makeFilePath(String[] stringArray, boolean bl) {
        StringBuffer stringBuffer = null;
        String string = System.getProperty("file.separator");
        if (stringArray != null) {
            stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (string2 == null || string2.length() == 0) {
                    throw new IllegalArgumentException();
                }
                stringBuffer.append(string2);
                if (i >= stringArray.length - 1) continue;
                stringBuffer.append(string);
            }
            if (bl) {
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public static List parseStringList(String string) {
        return StringUtils.parseStringList(string, null);
    }

    public static List parseStringList(String string, String string2) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = string2 == null ? new StringTokenizer(string) : new StringTokenizer(string, string2);
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if (string3.length() <= 0) continue;
            vector.add(string3);
        }
        return vector;
    }
}

