/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli.util.sessionstore;

import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.util.sessionstore.SessionStoreException;
import com.iplanet.ias.tools.cli.util.sessionstore.SessionStoreUtil;
import com.sun.hadb.jdbc.LobConnection;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class HADBSessionStoreUtil
extends SessionStoreUtil {
    private String storeuser = null;
    private String storepassword = null;
    private String storeurl = null;
    private String systemuser = null;
    private String systempassword = null;
    private Connection hadbConnection = null;

    public HADBSessionStoreUtil(String string, String string2, String string3) {
        this.storeuser = string;
        this.storepassword = string2;
        this.storeurl = string3;
    }

    public HADBSessionStoreUtil(String string, String string2, String string3, String string4, String string5) {
        this.storeuser = string;
        this.storepassword = string2;
        this.storeurl = string3;
        this.systemuser = string4;
        this.systempassword = string5;
    }

    public HADBSessionStoreUtil(String string, String string2, String string3, String string4) {
        this.storeuser = string;
        this.storepassword = string2;
        this.storeurl = string3;
        this.systemuser = "system";
        this.systempassword = string4;
    }

    public void createSessionStore() throws SessionStoreException {
        try {
            this.getConnection(this.storeurl, this.systemuser, this.systempassword);
            String string = this.getOldUser();
            this.dropTables();
            this.dropSchema();
            if (string != null) {
                this.dropUser(string);
            }
            this.setSchema("sysroot");
            if (this.newUserExists() && !this.checkPermission().equals("128")) {
                this.dropUser();
            }
            this.createNewUser();
            this.createNewSchema();
            this.changeSchemaUser();
            this.hadbConnection.close();
            this.hadbConnection = null;
            this.getConnection();
            this.createModifiedSessionTables();
            this.createModifiedAttributeTables();
            this.createSingleSignOnTable();
            this.createStatefulSessionBeanTable();
            this.hadbConnection.commit();
            this.hadbConnection.close();
        }
        catch (SQLException sQLException) {
            throw new SessionStoreException(sQLException.toString());
        }
    }

    public void clearSessionStore() throws SessionStoreException {
        try {
            this.getConnection();
            this.setSchema();
            this.dropModifiedSessionTables();
            this.dropModifiedAttributeTables();
            this.dropSingleSignOnTable();
            this.dropStatefulSessionBeanTable();
            this.createModifiedSessionTables();
            this.createModifiedAttributeTables();
            this.createSingleSignOnTable();
            this.createStatefulSessionBeanTable();
            this.hadbConnection.commit();
            this.hadbConnection.close();
        }
        catch (SQLException sQLException) {
            throw new SessionStoreException(sQLException.toString());
        }
    }

    private void getConnection() throws SQLException {
        if (this.hadbConnection == null) {
            this.getConnection(this.storeurl, this.storeuser, this.storepassword);
        }
    }

    private void getConnection(String string) throws SQLException {
        Debug.println(" Get connection.....");
        if (this.hadbConnection == null) {
            this.hadbConnection = DriverManager.getConnection(string);
        }
    }

    private void getConnection(String string, String string2, String string3) throws SQLException {
        Debug.println(" Get connection.....");
        if (this.hadbConnection == null) {
            this.hadbConnection = DriverManager.getConnection(string, string2, string3);
        }
    }

    private void createModifiedSessionTables() throws SQLException {
        Debug.println(" Creating table .....blobsessions");
        String string = "CREATE TABLE blobsessions (id varchar(100) not null primary key,valid char(1) not null,maxinactive int not null,lastaccess double integer,appid varchar(100),sessdata integer,userName varchar(100),ssoid varchar(100))";
        Statement statement = this.hadbConnection.createStatement();
        statement.executeUpdate(string);
        ((LobConnection)this.hadbConnection).createLobTable(null, "blobsessions");
    }

    private void createModifiedAttributeTables() throws SQLException {
        this.createModifiedAttributesHeaderTable();
        this.createModifiedAttributesAttributeTable();
    }

    private void dropModifiedSessionTables() throws SQLException {
        Debug.println(" Droping table .....blobsessions");
        String string = "DROP TABLE blobsessions";
        Statement statement = this.hadbConnection.createStatement();
        statement.executeUpdate(string);
        ((LobConnection)this.hadbConnection).dropLobTable(null, "blobsessions");
    }

    private void dropModifiedAttributeTables() throws SQLException {
        this.dropModifiedAttributesHeaderTable();
        this.dropModifiedAttributesAttributeTable();
    }

    private void createModifiedAttributesHeaderTable() throws SQLException {
        Debug.println(" Creating table .....sessionheader");
        String string = "CREATE TABLE sessionheader (id varchar(100) not null primary key,valid char(1) not null,maxinactive int not null,lastaccess double integer,appid varchar(100),username varchar(100),ssoid varchar(100))";
        Statement statement = this.hadbConnection.createStatement();
        statement.executeUpdate(string);
    }

    private void createModifiedAttributesAttributeTable() throws SQLException {
        Debug.println(" Creating table .....sessionattribute");
        String string = "CREATE TABLE sessionattribute (rowid varchar(200) not null,sessattrdata integer,id varchar(100) not null,attributename varchar(100), constraint pk primary key(rowid))";
        Statement statement = this.hadbConnection.createStatement();
        statement.executeUpdate(string);
        ((LobConnection)this.hadbConnection).createLobTable(null, "sessionattribute");
    }

    private void dropModifiedAttributesHeaderTable() throws SQLException {
        Debug.println(" Dropping table .....sessionheader");
        String string = "DROP TABLE sessionheader";
        Statement statement = this.hadbConnection.createStatement();
        statement.executeUpdate(string);
    }

    private void dropModifiedAttributesAttributeTable() throws SQLException {
        Debug.println(" Dropping table .....sessionattribute");
        String string = "DROP TABLE sessionattribute";
        Statement statement = this.hadbConnection.createStatement();
        statement.executeUpdate(string);
        ((LobConnection)this.hadbConnection).dropLobTable(null, "sessionattribute");
    }

    private void createSingleSignOnTable() throws SQLException {
        Debug.println(" Creating table .....singlesignon");
        String string = "CREATE TABLE singlesignon (ssoid varchar(100) not null primary key, lastaccess double integer, authType varchar(100), userName varchar(100))";
        Statement statement = this.hadbConnection.createStatement();
        statement.executeUpdate(string);
    }

    private void dropSingleSignOnTable() throws SQLException {
        Debug.println(" Dropping table .....singlesignon");
        String string = "DROP TABLE singlesignon";
        Statement statement = this.hadbConnection.createStatement();
        statement.executeUpdate(string);
    }

    private void createStatefulSessionBeanTable() throws SQLException {
        Debug.println(" Creating table .....statefulsessionbean");
        String string = "CREATE TABLE statefulsessionbean (id varchar(100) not null primary key, clusterid varchar(100), containerid varchar(100), lastaccess double integer, beandata integer)";
        Statement statement = this.hadbConnection.createStatement();
        statement.executeUpdate(string);
        ((LobConnection)this.hadbConnection).createLobTable(null, "statefulsessionbean");
    }

    private void dropStatefulSessionBeanTable() throws SQLException {
        Debug.println(" Dropping table .....statefulsessionbean");
        String string = "DROP TABLE statefulsessionbean";
        Statement statement = this.hadbConnection.createStatement();
        statement.executeUpdate(string);
        ((LobConnection)this.hadbConnection).dropLobTable(null, "statefulsessionbean");
    }

    private void createNewUser() throws SQLException {
        Debug.println(" Creating user .....");
        String string = "CREATE USER " + this.storeuser + " PASSWORD '" + this.storepassword + "'";
        Statement statement = this.hadbConnection.createStatement();
        statement.executeUpdate(string);
    }

    private void createNewSchema() throws SQLException {
        Debug.println(" Creating schema.....");
        String string = "CREATE SCHEMA haschema OWNER " + this.storeuser;
        Statement statement = this.hadbConnection.createStatement();
        statement.executeUpdate(string);
    }

    private void dropSchema() {
        Debug.println(" Droping schema.....");
        try {
            String string = "DROP SCHEMA haschema";
            Statement statement = this.hadbConnection.createStatement();
            statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            Debug.println(" Exception in dropschema " + sQLException.toString());
        }
    }

    private void grantUsageToNewUser() throws SQLException {
        Debug.println(" Granting usage access to new user.....");
        String string = "GRANT USAGE ON SCHEMA haschema TO " + this.storeuser;
        Statement statement = this.hadbConnection.createStatement();
        statement.executeUpdate(string);
    }

    private void changeSchemaUser() throws SQLException {
        Debug.println(" Change schema user to new user.....");
        String string = "ALTER USER " + this.storeuser + " SCHEMA " + "haschema";
        Statement statement = this.hadbConnection.createStatement();
        statement.executeUpdate(string);
    }

    private void setSchema() throws SQLException {
        this.setSchema("haschema");
    }

    private void setSchema(String string) throws SQLException {
        Debug.println(" Changing schema of the user ....." + string);
        String string2 = "SET SCHEMA " + string;
        Statement statement = this.hadbConnection.createStatement();
        statement.executeUpdate(string2);
    }

    private void dropTables() {
        try {
            this.setSchema();
            this.dropModifiedSessionTables();
            this.dropModifiedAttributeTables();
            this.dropSingleSignOnTable();
            this.dropStatefulSessionBeanTable();
        }
        catch (SQLException sQLException) {
            Debug.println(" Exception in droptable " + sQLException.toString());
        }
    }

    private boolean newUserExists() throws SQLException {
        Debug.println(" Does the user exist ? .....");
        String string = "SELECT * FROM allusers WHERE username='" + this.storeuser + "'";
        Statement statement = this.hadbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        return resultSet.next();
    }

    private void dropUser() throws SQLException {
        Debug.println(" Droping User .....");
        this.dropUser(this.storeuser);
    }

    private void dropUser(String string) throws SQLException {
        Debug.println(" Droping User ....." + string);
        String string2 = "DROP USER " + string;
        Statement statement = this.hadbConnection.createStatement();
        statement.executeUpdate(string2);
    }

    private String getOldUser() throws SQLException {
        Debug.println(" Getting Old User .....");
        String string = "SELECT ownername FROM allschemas WHERE schemaname='haschema'";
        Statement statement = this.hadbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        if (resultSet.next()) {
            return resultSet.getString("ownername");
        }
        return null;
    }

    private String checkPermission() throws SQLException {
        Debug.println(" Checking permission of existing store user .....");
        String string = "SELECT privilege FROM allusers WHERE username='" + this.storeuser + "'";
        Statement statement = this.hadbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        if (resultSet.next()) {
            return resultSet.getString("privilege");
        }
        return null;
    }

    static {
        try {
            Class.forName("com.sun.hadb.jdbc.Driver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Debug.println(classNotFoundException);
            Debug.printStackTrace(classNotFoundException);
            Debug.println("Unable to load jdbc driver for HADB");
        }
    }
}

