/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli.framework;

import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.framework.CLIPropertiesReader;
import com.iplanet.ias.tools.cli.framework.CliUtil;
import com.iplanet.ias.tools.cli.framework.Command;
import com.iplanet.ias.tools.cli.framework.CommandNotFoundException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.GlobalsManager;
import com.iplanet.ias.tools.cli.framework.ICommandEnvironment;
import com.iplanet.ias.tools.cli.framework.InputsAndOutputs;
import com.iplanet.ias.tools.cli.framework.Option;
import com.iplanet.ias.tools.cli.framework.ValidCommand;
import com.iplanet.ias.tools.cli.framework.ValidCommandsList;
import com.iplanet.ias.tools.cli.framework.ValidOption;
import com.iplanet.ias.tools.cli.framework.ValidOptionsList;
import java.util.Vector;

public class CommandFactory {
    private static ValidCommandsList commandsList = null;
    private static ValidOptionsList optionsList = null;
    private static final String sEnvPrefix = "AS_ADMIN_";
    private static final String DELIMETER = "=";

    public static ValidCommandsList getCommandsList() throws CommandValidationException {
        if (commandsList == null) {
            CommandFactory.setListAndEnv();
        }
        return commandsList;
    }

    public static ValidOptionsList getOptionsList() throws CommandValidationException {
        if (optionsList == null) {
            CommandFactory.setListAndEnv();
        }
        return optionsList;
    }

    private static void setListAndEnv() throws CommandValidationException {
        CLIPropertiesReader cLIPropertiesReader = new CLIPropertiesReader();
        commandsList = cLIPropertiesReader.getCommandsList();
        optionsList = cLIPropertiesReader.getValidOptions();
        ICommandEnvironment iCommandEnvironment = GlobalsManager.getInstance().getGlobalsEnv();
        try {
            String[] stringArray = new CliUtil().getEnv();
            for (int i = 0; i < stringArray.length; ++i) {
                int n = stringArray[i].indexOf(DELIMETER);
                String string = stringArray[i].substring(sEnvPrefix.length(), n).toLowerCase();
                if (optionsList.getValidOption(string) == null) continue;
                iCommandEnvironment.setOption(new Option(string, stringArray[i].substring(n + 1, stringArray[i].length())));
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Debug.println(unsatisfiedLinkError.getLocalizedMessage());
            GlobalsManager.getInstance();
            InputsAndOutputs inputsAndOutputs = GlobalsManager.getInputsAndOutputs();
            inputsAndOutputs.getUserOutput().println(GlobalsManager.getLocalizedString("UnableToReadEnv"));
        }
    }

    public static Command createCommand(ValidCommand validCommand, Vector vector, Vector vector2) throws CommandNotFoundException {
        Command command = null;
        String string = validCommand.getName();
        String string2 = validCommand.getClassName();
        if (validCommand.getClassName() == null) {
            throw new CommandNotFoundException(GlobalsManager.getLocalizedString("NoSuchCommand") + " " + string);
        }
        try {
            Class<?> clazz = Class.forName(string2);
            command = (Command)clazz.newInstance();
            command.setName(string);
            command.setOptions(vector);
            command.setOperands(vector2);
            command.setHelp(validCommand.getHelpText());
            command.setUsage(validCommand.getUsageText());
            CommandFactory.addOptionsWithDefaultValues(command, validCommand.getValidOptions());
            CommandFactory.addOptionsWithDefaultValues(command, validCommand.getRequiredOptions());
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            throw new CommandNotFoundException(GlobalsManager.getLocalizedString("FatalError") + " " + exception.getClass());
        }
        return command;
    }

    public static String getClassName(String string) {
        ValidCommand validCommand = commandsList.getValidCommand(string);
        return validCommand.getClassName();
    }

    public static ValidCommand getValidCommand(String string) {
        ValidCommand validCommand = commandsList.getValidCommand(string);
        return validCommand;
    }

    public static void addOptionsWithDefaultValues(Command command, Vector vector) {
        ICommandEnvironment iCommandEnvironment = GlobalsManager.getInstance().getGlobalsEnv();
        for (int i = 0; i < vector.size(); ++i) {
            ValidOption validOption = (ValidOption)vector.get(i);
            if (!validOption.hasDefaultValue() || iCommandEnvironment.findOption(validOption.getName()) != null) continue;
            Option option = new Option(validOption.getName());
            option.setValue(validOption.getDefaultValue());
            option.setDefaultAssigned(true);
            command.addOption(option);
        }
    }
}

