/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli.framework;

import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandFactory;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.GlobalsManager;
import com.iplanet.ias.tools.cli.framework.ICommand;
import com.iplanet.ias.tools.cli.framework.IUserInput;
import com.iplanet.ias.tools.cli.framework.IUserOutput;
import com.iplanet.ias.tools.cli.framework.InputsAndOutputs;
import com.iplanet.ias.tools.cli.framework.Operand;
import com.iplanet.ias.tools.cli.framework.Option;
import com.iplanet.ias.tools.cli.framework.ValidCommand;
import com.iplanet.ias.tools.cli.framework.ValidOption;
import java.util.Vector;

public abstract class Command
implements ICommand {
    private static final String kResultPrefix = "";
    private static final String ZERO_OR_MORE = "*";
    private static final String ONE_OR_MORE = "+";
    private static final String ZERO_OR_ONE = "?";
    protected String name;
    protected Vector options;
    protected Vector operands = new Vector();
    protected String helpStr = null;
    protected String usageStr = null;

    public Command() {
        this.options = new Vector();
    }

    public abstract void runCommand() throws CommandException, CommandValidationException;

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Vector getOperands() {
        return this.operands;
    }

    public void setOperands(Vector vector) {
        this.operands = vector;
    }

    public int addOperand(Operand operand) {
        if (this.hasOperand(operand)) {
            return -1;
        }
        this.operands.add(operand);
        return 1;
    }

    public int removeOperand(Operand operand) {
        return 1;
    }

    private boolean hasOperand(Operand operand) {
        for (int i = 0; i < this.operands.size(); ++i) {
            if (!((Operand)this.operands.get(i)).getName().equals(operand.getName())) continue;
            return true;
        }
        return false;
    }

    public Vector getOptions() {
        return this.options;
    }

    public void setOptions(Vector vector) {
        this.options = vector;
    }

    protected int addOption(Option option) {
        if (this.hasOption(option)) {
            return -1;
        }
        this.options.add(option);
        return 1;
    }

    protected int removeOption(String string) {
        Option option = this.findOption(string);
        if (option != null) {
            this.options.remove(option);
            return 1;
        }
        return -1;
    }

    private boolean hasOption(Option option) {
        for (int i = 0; i < this.options.size(); ++i) {
            if (!((Option)this.options.get(i)).getName().equals(option.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean validateOptions() throws CommandValidationException {
        boolean bl = true;
        ValidCommand validCommand = CommandFactory.getCommandsList().getValidCommand(this.name);
        int n = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string = validCommand.getNumberOfOperands();
        Debug.println("Number of operands = " + string);
        if (string.equals(ZERO_OR_MORE)) {
            bl2 = true;
        } else if (string.equals(ONE_OR_MORE)) {
            bl3 = true;
        } else if (string.equals(ZERO_OR_ONE)) {
            bl4 = true;
        } else {
            try {
                n = Integer.valueOf(string);
            }
            catch (Exception exception) {
                Debug.printStackTrace(exception);
                throw new CommandValidationException(this.getLocalizedString("InvalidOperandSize"));
            }
        }
        if (bl3) {
            if (this.operands.size() == 0) {
                bl = false;
                throw new CommandValidationException(this.getLocalizedString("InvalidNumberOfOperands"));
            }
        } else if (bl4) {
            if (this.operands.size() != 0 && this.operands.size() != 1) {
                bl = false;
                throw new CommandValidationException(this.getLocalizedString("InvalidNumberOfOperands"));
            }
        } else if (!bl2 && this.operands.size() != n) {
            bl = false;
            throw new CommandValidationException(this.getLocalizedString("InvalidNumberOfOperands"));
        }
        if (!this.isRequiredOptionsProvided()) {
            bl = false;
        }
        return bl;
    }

    public void echoCommand() {
        this.printMessage(this.toString());
    }

    public String getHelp() {
        return this.helpStr;
    }

    public void setHelp(String string) {
        this.helpStr = string;
    }

    public String getUsage() {
        return this.usageStr;
    }

    public void setUsage(String string) {
        this.usageStr = string;
    }

    public String toString() {
        Object object;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName());
        for (n = 0; n < this.options.size(); ++n) {
            stringBuffer.append(" ");
            object = (Option)this.options.get(n);
            stringBuffer.append("--" + ((Option)object).getName() + " " + ((Option)object).getValue());
        }
        for (n = 0; n < this.operands.size(); ++n) {
            stringBuffer.append(" ");
            object = (Operand)this.operands.get(n);
            stringBuffer.append(((Operand)object).getName());
            if (((Operand)object).getValue() == null) continue;
            stringBuffer.append("=" + ((Operand)object).getValue());
        }
        return stringBuffer.toString();
    }

    public boolean isRequiredOptionsProvided() throws CommandValidationException {
        boolean bl = true;
        ValidCommand validCommand = CommandFactory.getValidCommand(this.name);
        Vector vector = validCommand.getRequiredOptions();
        for (int i = 0; i < vector.size(); ++i) {
            ValidOption validOption = (ValidOption)vector.get(i);
            if (this.hasOption(validOption)) continue;
            throw new CommandValidationException(this.getLocalizedString("RequiredOptionsNotProvided", new Object[]{validOption.getName()}));
        }
        return bl;
    }

    public boolean isOptionsValid() {
        boolean bl = true;
        ValidCommand validCommand = CommandFactory.getValidCommand(this.name);
        for (int i = 0; i < this.options.size(); ++i) {
            String string = ((Option)this.options.get(i)).getName();
            if (validCommand.hasValidOption(string) || validCommand.hasRequiredOption(string)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean hasOption(ValidOption validOption) {
        Option option;
        boolean bl = false;
        for (int i = 0; i < this.options.size(); ++i) {
            String string = ((Option)this.options.get(i)).getName();
            if (!validOption.getName().equals(string)) continue;
            bl = true;
            break;
        }
        if (!bl && (option = this.getGlobalsMgr().getOption(validOption.getName())) != null) {
            bl = true;
        }
        return bl;
    }

    protected Option findOption(String string) {
        Option option = null;
        for (int i = 0; i < this.options.size(); ++i) {
            Option option2 = (Option)this.options.get(i);
            if (!option2.getName().equals(string)) continue;
            option = option2;
            break;
        }
        if (option == null) {
            option = this.getGlobalsMgr().getOption(string);
        }
        return option;
    }

    public GlobalsManager getGlobalsMgr() {
        return GlobalsManager.getInstance();
    }

    protected IUserOutput getUserOutput() {
        this.getGlobalsMgr();
        InputsAndOutputs inputsAndOutputs = GlobalsManager.getInputsAndOutputs();
        return inputsAndOutputs.getUserOutput();
    }

    protected IUserInput getUserInput() {
        this.getGlobalsMgr();
        InputsAndOutputs inputsAndOutputs = GlobalsManager.getInputsAndOutputs();
        return inputsAndOutputs.getUserInput();
    }

    protected void setUserInput(IUserInput iUserInput) {
        this.getGlobalsMgr();
        InputsAndOutputs inputsAndOutputs = GlobalsManager.getInputsAndOutputs();
        inputsAndOutputs.setUserInput(iUserInput);
    }

    private void printResult(Object object) {
        this.getUserOutput().println(this.getResultPrefix() + object);
    }

    public void printMessage(Object object) {
        this.printResult(object);
    }

    public void printError(Object object) {
        this.printResult(object);
    }

    protected String getLocalizedString(String string, Object[] objectArray) {
        return GlobalsManager.getLocalizedString(string, objectArray);
    }

    protected String getLocalizedString(String string) {
        return GlobalsManager.getLocalizedString(string);
    }

    private String getResultPrefix() {
        return kResultPrefix;
    }
}

