/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli.framework;

import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.GlobalsManager;
import com.iplanet.ias.tools.cli.framework.ValidCommand;
import com.iplanet.ias.tools.cli.framework.ValidCommandsList;
import com.iplanet.ias.tools.cli.framework.ValidOption;
import com.iplanet.ias.tools.cli.framework.ValidOptionsList;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CLIPropertiesReader {
    private static final URL propertiesFile = CLIPropertiesReader.class.getClassLoader().getResource("com/iplanet/ias/tools/cli/CLIProperties.xml");
    private ValidCommandsList commandsList = null;
    private Document document;
    private Vector validOptionsForAllCommands;
    private Vector requiredOptionsForAllCommands;
    private ValidOptionsList validOptions;

    public CLIPropertiesReader() throws CommandValidationException {
        this.initProperties();
        this.commandsList = new ValidCommandsList();
        this.validOptionsForAllCommands = new Vector();
        this.requiredOptionsForAllCommands = new Vector();
        this.validOptions = new ValidOptionsList();
        this.generateOptionsAndCommands();
    }

    public ValidCommandsList getCommandsList() {
        return this.commandsList;
    }

    public ValidOptionsList getValidOptions() {
        return this.validOptions;
    }

    public void initProperties() throws CommandValidationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilderFactory.setValidating(true);
            Debug.println("Validation against DTD is " + documentBuilderFactory.isValidating());
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            if (propertiesFile == null) {
                throw new CommandValidationException(GlobalsManager.getLocalizedString("NoPropertiesFile"));
            }
            Debug.println(propertiesFile);
            InputSource inputSource = new InputSource(propertiesFile.toString());
            this.document = documentBuilder.parse(inputSource);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Debug.printStackTrace(parserConfigurationException);
            throw new CommandValidationException(parserConfigurationException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            Debug.printStackTrace(iOException);
            throw new CommandValidationException(iOException.getLocalizedMessage());
        }
    }

    private void generateOptionsAndCommands() {
        if (this.document != null) {
            for (Node node = this.document.getDocumentElement().getFirstChild(); node != null; node = node.getNextSibling()) {
                Object object;
                String string;
                Node node2;
                String string2 = node.getNodeName();
                if (string2.equalsIgnoreCase("Options")) {
                    for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                        string = node2.getNodeName();
                        if (!string.equalsIgnoreCase("Option")) continue;
                        object = this.generateOption(node2);
                        this.validOptions.addOption((ValidOption)object);
                    }
                    continue;
                }
                if (string2.equalsIgnoreCase("ValidOptionsForAllCommands")) {
                    for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                        string = node2.getNodeName();
                        if (!string.equalsIgnoreCase("ValidOption")) continue;
                        object = node2.getFirstChild().getNodeValue();
                        this.validOptionsForAllCommands.add(object);
                    }
                    continue;
                }
                if (string2.equalsIgnoreCase("RequiredOptionsForAllCommands")) {
                    for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                        string = node2.getNodeName();
                        if (!string.equalsIgnoreCase("RequiredOption")) continue;
                        object = node2.getFirstChild().getNodeValue();
                        this.requiredOptionsForAllCommands.add(object);
                    }
                    continue;
                }
                if (!string2.equalsIgnoreCase("ValidCommands")) continue;
                for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    string = node2.getNodeName();
                    if (!string.equalsIgnoreCase("ValidCommand")) continue;
                    object = this.generateCommand(node2);
                    this.commandsList.addCommand((ValidCommand)object);
                }
            }
        }
    }

    private ValidOption generateOption(Node node) {
        ValidOption validOption = new ValidOption();
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            String string;
            String string2 = node2.getNodeName();
            if (string2.equalsIgnoreCase("name")) {
                string = node2.getFirstChild().getNodeValue();
                if (string == null) continue;
                string = string.trim();
                validOption.setName(string);
                continue;
            }
            if (string2.equalsIgnoreCase("value-required")) {
                string = node2.getFirstChild().getNodeValue();
                if (string == null) continue;
                if ((string = string.trim()).equalsIgnoreCase("REQUIRED")) {
                    validOption.setRequired(1);
                    continue;
                }
                if (string.equalsIgnoreCase("OPTIONAL")) {
                    validOption.setRequired(2);
                    continue;
                }
                if (!string.equalsIgnoreCase("NOT_REQUIRED")) continue;
                validOption.setRequired(3);
                continue;
            }
            if (string2.equalsIgnoreCase("shortoption")) {
                string = node2.getFirstChild().getNodeValue();
                if ((string = string.trim()) == null) continue;
                validOption.setShortName(string);
                continue;
            }
            if (string2.equalsIgnoreCase("type")) {
                string = node2.getFirstChild().getNodeValue();
                if ((string = string.trim()) == null) continue;
                validOption.setType(string);
                continue;
            }
            if (string2.equalsIgnoreCase("default")) {
                string = node2.getFirstChild().getNodeValue();
                if ((string = string.trim()) == null) continue;
                validOption.setDefaultValue(string);
                continue;
            }
            if (!string2.equalsIgnoreCase("help-text")) continue;
            string = node2.getFirstChild().getNodeValue();
            if ((string = string.trim()) == null) continue;
            validOption.setHelpText(string);
        }
        return validOption;
    }

    private ValidCommand generateCommand(Node node) {
        ValidCommand validCommand = new ValidCommand();
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            ValidOption validOption;
            String string;
            String string2 = node2.getNodeName();
            if (string2.equalsIgnoreCase("name")) {
                string = node2.getFirstChild().getNodeValue();
                if (string == null) continue;
                string = string.trim();
                validCommand.setName(string);
                continue;
            }
            if (string2.equalsIgnoreCase("numberofoperands")) {
                string = node2.getFirstChild().getNodeValue();
                if (string == null) continue;
                string = string.trim();
                validCommand.setNumberOfOperands(string);
                continue;
            }
            if (string2.equalsIgnoreCase("className")) {
                string = node2.getFirstChild().getNodeValue();
                if (string == null) continue;
                string = string.trim();
                validCommand.setClassName(string);
                continue;
            }
            if (string2.equalsIgnoreCase("ValidOption")) {
                string = node2.getFirstChild().getNodeValue();
                validOption = this.findOption(string);
                if (validOption == null) {
                    System.out.println("Valid option (" + string + ")is not found in xml : " + validCommand.getName());
                    return validCommand;
                }
                validCommand.addValidOption(validOption);
                continue;
            }
            if (string2.equalsIgnoreCase("RequiredOption")) {
                string = node2.getFirstChild().getNodeValue();
                validOption = this.findOption(string);
                if (validOption == null) {
                    System.out.println("Required option (" + string + ")is not found in xml : " + validCommand.getName());
                    return validCommand;
                }
                validCommand.addRequiredOption(validOption);
                continue;
            }
            if (string2.equalsIgnoreCase("help-text")) {
                string = node2.getFirstChild().getNodeValue();
                if (string == null) continue;
                string = string.trim();
                validCommand.setHelpText(string);
                continue;
            }
            if (!string2.equalsIgnoreCase("usage-text") || (string = node2.getFirstChild().getNodeValue()) == null) continue;
            string = string.trim();
            validCommand.setUsageText(string);
        }
        this.appendOptionsValidForAllCommands(validCommand);
        this.appendOptionsRequiredForAllCommands(validCommand);
        return validCommand;
    }

    private ValidOption findOption(String string) {
        return this.validOptions.getValidOption(string);
    }

    private void appendOptionsValidForAllCommands(ValidCommand validCommand) {
        for (int i = 0; i < this.validOptionsForAllCommands.size(); ++i) {
            String string = (String)this.validOptionsForAllCommands.get(i);
            validCommand.addValidOption(this.findOption(string));
        }
    }

    private void appendOptionsRequiredForAllCommands(ValidCommand validCommand) {
        for (int i = 0; i < this.requiredOptionsForAllCommands.size(); ++i) {
            String string = (String)this.requiredOptionsForAllCommands.get(i);
            validCommand.addRequiredOption(this.findOption(string));
        }
    }
}

