/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.IasCommand;
import com.iplanet.ias.tools.cli.framework.IUserOutput;
import java.io.IOException;
import java.net.URL;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLManReader
extends IasCommand {
    private URL XMLFile;
    private Document document;
    private IUserOutput io = null;
    private String nodeName = "";
    private boolean firstRow = true;
    private String Tab = "     ";
    private String Spacer = "                              ";
    private int previousDiff = 0;
    private boolean bInformalTable = false;
    private boolean bExample = false;
    private int iCountRow = 0;
    private int iCountCol = this.Tab.length();
    private int col = 79;
    private int row = 22;

    public XMLManReader(String string) {
        this.XMLFile = XMLManReader.class.getClassLoader().getResource(string);
        this.initXML();
        this.printManSections(this.document);
    }

    public XMLManReader(String string, IUserOutput iUserOutput) {
        this.XMLFile = ClassLoader.getSystemClassLoader().getResource(string);
        this.io = iUserOutput;
        this.initXML();
        this.printManSections(this.document);
    }

    public void initXML() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            if (this.XMLFile == null) {
                Debug.println("NoXMLFile");
                return;
            }
            InputSource inputSource = new InputSource(this.XMLFile.toString());
            this.document = documentBuilder.parse(inputSource);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Debug.println(parserConfigurationException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            Debug.println(iOException.getLocalizedMessage());
        }
    }

    private void printManSections(Document document) {
        Object object;
        NodeList nodeList;
        Element element;
        int n;
        Element element2;
        this.printLine("");
        String string = "";
        String string2 = "";
        String string3 = "";
        NodeList nodeList2 = document.getElementsByTagName("refentrytitle");
        if (nodeList2.getLength() > 0) {
            Element element3 = (Element)nodeList2.item(0);
            string = element3.getFirstChild().getNodeValue().replace('\n', ' ');
        }
        nodeList2 = document.getElementsByTagName("refmiscinfo");
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            element2 = (Element)nodeList2.item(i);
            if (!element2.getAttribute("class").equals("sectdesc")) continue;
            string2 = element2.getFirstChild().getNodeValue();
        }
        nodeList2 = document.getElementsByTagName("manvolnum");
        if (nodeList2.getLength() > 0) {
            Element element4 = (Element)nodeList2.item(0);
            string3 = element4.getFirstChild().getNodeValue();
        }
        this.printTitle(string2 + this.Tab + this.Tab + this.Tab + this.Tab + this.Tab + string + "(" + string3 + ")");
        this.printTitle("NAME");
        String string4 = "";
        nodeList2 = document.getElementsByTagName("refname");
        if (nodeList2.getLength() > 0) {
            element2 = (Element)nodeList2.item(0);
            string4 = element2.getFirstChild().getNodeValue();
        }
        if ((nodeList2 = document.getElementsByTagName("refpurpose")).getLength() > 0) {
            element2 = (Element)nodeList2.item(0);
            this.printWord(this.Tab);
            this.printLine(string4 + " - " + element2.getFirstChild().getNodeValue().replace('\n', ' '));
        }
        this.printLine("");
        nodeList2 = document.getElementsByTagName("refsynopsisdiv");
        for (n = 0; n < nodeList2.getLength(); ++n) {
            element = (Element)nodeList2.item(n);
            nodeList = element.getElementsByTagName("title");
            if (nodeList != null) {
                Element element5 = (Element)nodeList.item(0);
                this.printTitle(element5.getFirstChild().getNodeValue().replace('\n', ' '));
            }
            nodeList = element.getElementsByTagName("cmdsynopsis");
            this.printWord(this.Tab);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element6 = (Element)nodeList.item(i);
                object = this.getAllNodes(element6, "");
                this.printLine((String)object);
            }
        }
        nodeList2 = document.getElementsByTagName("refsect1");
        for (n = 0; n < nodeList2.getLength(); ++n) {
            element = (Element)nodeList2.item(n);
            nodeList = element.getElementsByTagName("title");
            String string5 = "";
            if (nodeList != null) {
                Element element7 = (Element)nodeList.item(0);
                string5 = element7.getFirstChild().getNodeValue().replace('\n', ' ');
                this.printTitle("\n" + string5);
            }
            if (string5.equals(this.getLocalizedString("Description"))) {
                nodeList = element.getElementsByTagName("para");
                if (nodeList.getLength() > 0) {
                    Element element8 = (Element)nodeList.item(0);
                    this.printWord(this.Tab);
                    object = this.getAllNodes(element8, "");
                    this.printLine((String)object);
                }
                if ((nodeList = element.getElementsByTagName("informaltable")) != null && nodeList.getLength() > 0) {
                    this.bInformalTable = true;
                    this.printLine("");
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        object = (Element)nodeList.item(i);
                        NodeList nodeList3 = object.getElementsByTagName("row");
                        for (int j = 0; j < nodeList3.getLength(); ++j) {
                            Element element9 = (Element)nodeList3.item(j);
                            this.firstRow = true;
                            String string6 = this.getAllNodes(element9, "");
                            this.print(string6);
                            this.printLine("");
                        }
                    }
                    this.bInformalTable = false;
                }
                this.printLine("");
                continue;
            }
            if (string5.startsWith(this.getLocalizedString("Example"))) {
                this.bExample = true;
                nodeList = element.getElementsByTagName("example");
                this.checkList(nodeList);
                this.bExample = false;
                continue;
            }
            nodeList = element.getElementsByTagName("screen");
            this.checkList(nodeList);
            nodeList = element.getElementsByTagName("varlistentry");
            if (nodeList.getLength() > 0) {
                this.checkList(nodeList);
                continue;
            }
            nodeList = element.getElementsByTagName("para");
            this.checkList(nodeList);
        }
        this.printLine("");
    }

    private void checkList(NodeList nodeList) {
        if (nodeList != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                if (element != null && element.getFirstChild() != null) {
                    this.iCountCol = this.Tab.length();
                    this.printWord(this.Tab);
                    String string = this.getAllNodes(element, "");
                    this.printWord(string);
                }
                this.printLine("");
            }
        }
    }

    private String getAllNodes(Node node, String string) {
        String string2 = string;
        switch (node.getNodeType()) {
            case 1: {
                this.nodeName = node.getNodeName();
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null) break;
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    string2 = this.getAllNodes(nodeList.item(i), string2);
                }
                break;
            }
            case 3: 
            case 4: {
                if (this.bInformalTable && this.nodeName.equals("para")) {
                    String string3 = node.getNodeValue().replace('\n', ' ');
                    if (string3.equals(" ")) break;
                    string2 = this.firstRow ? string2.concat(this.Tab) : string2.concat(this.Spacer.substring(0, this.previousDiff));
                    string2 = string2.concat(string3);
                    this.previousDiff = this.Spacer.length() - string3.length();
                    this.firstRow = false;
                    break;
                }
                if (this.bExample) {
                    string2 = string2.concat(node.getNodeValue());
                    break;
                }
                if (this.nodeName.equals("term")) {
                    string2 = string2.concat(node.getNodeValue().replace('\n', ' ') + " ");
                    break;
                }
                if (this.nodeName.equals("command") || this.nodeName.equals("para") || this.nodeName.equals("option")) {
                    string2 = string2.concat(node.getNodeValue().replace('\n', ' ') + " ");
                    break;
                }
                if (this.nodeName.equals("manvolnum")) {
                    char c = node.getNodeValue().charAt(0);
                    if (Character.isDigit(c)) {
                        string2 = string2.concat("(" + node.getNodeValue().replace('\n', ' ') + ")");
                        break;
                    }
                    string2 = string2.concat(node.getNodeValue().replace('\n', ' '));
                    break;
                }
                String string4 = node.getNodeValue().replace('\n', ' ');
                string2 = string2.concat(string4);
                break;
            }
        }
        return string2;
    }

    private void printAllNodes(Node node) {
        switch (node.getNodeType()) {
            case 1: {
                this.nodeName = node.getNodeName();
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null) break;
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    this.printAllNodes(nodeList.item(i));
                }
                break;
            }
            case 3: 
            case 4: {
                if (this.bInformalTable && this.nodeName.equals("para")) {
                    String string = node.getNodeValue().replace('\n', ' ');
                    if (this.firstRow) {
                        this.printWord(this.Tab);
                    } else {
                        this.printWord(this.Spacer.substring(0, this.previousDiff));
                    }
                    this.printWord(string);
                    this.previousDiff = this.Spacer.length() - string.length();
                    this.firstRow = false;
                    break;
                }
                if (this.nodeName.equals("command")) {
                    this.printWord(node.getNodeValue().replace('\n', ' ') + " ");
                    break;
                }
                String string = node.getNodeValue().replace('\n', ' ');
                this.printWord(string);
                this.iCountCol += string.length();
                if (this.iCountCol <= this.col) break;
                this.printLine("");
                this.printWord(this.Tab);
                this.iCountCol = this.Tab.length();
                break;
            }
        }
    }

    void printTitle(String string) {
        if (string != null) {
            this.println(string);
            this.checkForPrompt();
        }
    }

    void printWord(String string) {
        if (string != null) {
            if (string.length() + this.Tab.length() > this.col) {
                this.printLine(string);
            } else {
                this.print(string);
            }
        }
    }

    void println(String string) {
        if (this.io == null) {
            System.out.println(string);
        } else {
            this.io.println(string);
        }
    }

    void print(String string) {
        if (this.io == null) {
            System.out.print(string);
        } else {
            this.io.print(string);
        }
    }

    void printLine(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            int n = this.Spacer.length();
            while (stringTokenizer.hasMoreTokens()) {
                StringTokenizer stringTokenizer2;
                String string2 = stringTokenizer.nextToken();
                n = n + string2.length() + 1;
                if (string2.indexOf(10) > -1 && (stringTokenizer2 = new StringTokenizer(string2, "\n")).hasMoreTokens()) {
                    String string3 = stringTokenizer2.nextToken();
                    if (string2.indexOf(10) == 0) {
                        string3 = "\n" + this.Tab + string3;
                    }
                    while (stringTokenizer2.hasMoreTokens()) {
                        string3 = string3 + "\n" + this.Tab + stringTokenizer2.nextToken();
                        n = this.Spacer.length();
                    }
                    string2 = string3;
                }
                if (n > this.col) {
                    this.print("\n");
                    this.checkForPrompt();
                    this.print(this.Tab);
                    n = this.Spacer.length();
                }
                this.print(string2 + " ");
            }
            this.print("\n");
            this.checkForPrompt();
        }
    }

    private void checkForPrompt() {
        ++this.iCountRow;
        if (this.iCountRow > this.row) {
            this.print(this.getLocalizedString("PressEnterToContinue") + ">");
            try {
                while (System.in.read() != 10) {
                }
            }
            catch (IOException iOException) {
                this.println(iOException.getMessage());
            }
            this.iCountRow = 0;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("Usage: java XMLManReader [XML URI] ");
            System.exit(0);
        }
        String string = stringArray[0];
        XMLManReader xMLManReader = new XMLManReader(string);
    }
}

