/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseLifeCycleCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class ShutdownCommand
extends BaseLifeCycleCommand {
    public ShutdownCommand() {
    }

    public ShutdownCommand(String string) {
        this.setName(string);
    }

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            return;
        }
        try {
            ServerInstanceManager serverInstanceManager = this.getServerInstanceManager();
            serverInstanceManager.stopServer();
            this.waitForWebContainerShutdown();
            this.printMessage(this.getLocalizedString("AdminServerShutdown"));
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printMessage(exception.getLocalizedMessage());
            this.printMessage(this.getLocalizedString("CannotStopAdminServer"));
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }

    private void waitForWebContainerShutdown() throws CommandException, CommandValidationException, MalformedURLException {
        long l = 60000L;
        long l2 = 2000L;
        long l3 = System.currentTimeMillis();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        URL uRL = null;
        try {
            uRL = this.getAdminServerConnection();
        }
        catch (IOException iOException) {
            Debug.printStackTrace(iOException);
            throw new CommandException(iOException.getLocalizedMessage());
        }
        this.printMessage(this.getLocalizedString("WaitingForAdminServerToShutdown"));
        while (!bl2) {
            long l4 = System.currentTimeMillis();
            this.sleep(l2);
            bl = l4 - l3 >= l;
            try {
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.connect();
            }
            catch (Exception exception) {
                Debug.println("Shutdown occured");
                bl3 = true;
            }
            bl2 = bl || bl3;
        }
    }

    private URL getAdminServerConnection() throws CommandValidationException, MalformedURLException, IOException {
        String string = "web1/entry";
        String string2 = "http://";
        String string3 = string2 + this.getHost() + ":" + this.getPort();
        string3 = string3 + "/" + string;
        URL uRL = new URL(string3);
        return uRL;
    }

    private void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

