/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseConfigurationCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Operand;
import com.iplanet.ias.tools.cli.framework.Option;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;

public class SetAttributeCommand
extends BaseConfigurationCommand {
    private static final char DOUBLE_QUOTE_CHAR = '\"';

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            return;
        }
        ServerInstanceManager serverInstanceManager = this.getServerInstanceManager();
        AttributeList attributeList = this.getAttributes();
        attributeList = this.setPrefixForAllAttributes(attributeList);
        AttributeList attributeList2 = null;
        try {
            attributeList2 = this.isMonitoring() ? serverInstanceManager.setMonitorAttributes(attributeList) : serverInstanceManager.setGenericAttributes(attributeList);
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotSetAttribute"));
            throw new CommandException(exception.getMessage());
        }
        if (!this.isMonitoring()) {
            this.validateAttributeList(attributeList, attributeList2);
        } else if (attributeList2 == null) {
            this.printError(this.getLocalizedString("CannotSetAttribute"));
            throw new CommandException(this.getLocalizedString("NoAttributeNameMatch"));
        }
        Iterator iterator = attributeList2.iterator();
        if (!iterator.hasNext()) {
            this.printMessage(this.getLocalizedString("AttributeNotFound"));
        }
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            this.printMessage(this.getLocalizedString("AttributeSetTo", new Object[]{attribute.getName(), attribute.getValue().toString()}));
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }

    private AttributeList getAttributes() throws CommandException, CommandValidationException {
        Object object;
        int n;
        AttributeList attributeList = new AttributeList();
        for (n = 0; n < this.operands.size(); ++n) {
            object = ((Operand)this.operands.get(n)).getName();
            Debug.println("Attribute (" + n + ") = " + (String)object);
            int n2 = this.getSingleAttributeValueIndex((String)object);
            if (n2 == -1) {
                throw new CommandValidationException(this.getLocalizedString("ValueNotSetForAttribute"));
            }
            String string = ((String)object).substring(0, n2);
            if (((String)object).length() <= n2) {
                throw new CommandValidationException(this.getLocalizedString("InvalidSetSyntax"));
            }
            String string2 = ((String)object).substring(n2 + 1);
            string2 = this.removeEscapeChars(string2);
            Attribute attribute = new Attribute(string, string2);
            attributeList.add(attribute);
        }
        for (n = 0; n < attributeList.size(); ++n) {
            object = (Attribute)attributeList.get(n);
            Debug.println("Attribute(name,value) = " + ((Attribute)object).getName() + " , " + ((Attribute)object).getValue());
        }
        return attributeList;
    }

    private int getSingleAttributeValueIndex(String string) {
        int n;
        int n2 = -1;
        boolean bl = false;
        for (n = 0; n < string.length(); ++n) {
            if (string.charAt(n) == '\"') {
                if ((n = string.indexOf(34, n + 1)) == -1) {
                    return n;
                }
                if (string.length() != n) continue;
                return -1;
            }
            if (string.charAt(n) != '=' || string.charAt(n - 1) == '\\') continue;
            if (n == 0) {
                return -1;
            }
            return n;
        }
        return n;
    }

    private String removeEscapeChars(String string) throws CommandValidationException {
        int n = 0;
        String string2 = string;
        String string3 = "";
        while (n < string2.length()) {
            int n2 = this.getDelimeterIndex(string2, String.valueOf('\\'), n);
            if (n2 == -1) {
                string3 = string3 + string2.substring(n);
                break;
            }
            string3 = string3 + string2.substring(n, n2);
            n = n2 + 1;
        }
        if (!string3.equals("") && string3.charAt(0) == '\"' && string3.charAt(string3.length() - 1) == '\"') {
            string3 = string3.substring(1, string3.length() - 1);
        }
        return string3;
    }

    private AttributeList setPrefixForAllAttributes(AttributeList attributeList) {
        Option option = this.findOption("prefix");
        if (option == null || option.getValue().equals("")) {
            return attributeList;
        }
        AttributeList attributeList2 = new AttributeList();
        String string = option.getValue();
        for (int i = 0; i < attributeList.size(); ++i) {
            Attribute attribute = (Attribute)attributeList.get(i);
            String string2 = string + "." + attribute.getName();
            Attribute attribute2 = new Attribute(string2, attribute.getValue());
            attributeList2.add(attribute2);
        }
        return attributeList2;
    }
}

